/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.LimitObjectInput;
import org.apache.derby.iapi.store.raw.Compensation;
import org.apache.derby.iapi.store.raw.ContainerKey;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.iapi.store.raw.Undoable;
import org.apache.derby.iapi.store.raw.data.RawContainerHandle;
import org.apache.derby.iapi.store.raw.log.LogInstant;
import org.apache.derby.iapi.store.raw.xact.RawTransaction;
import org.apache.derby.iapi.util.ByteArray;
import org.apache.derby.impl.store.raw.data.BaseDataFileFactory;
import org.apache.derby.impl.store.raw.data.EncryptContainerUndoOperation;
import org.apache.derby.impl.store.raw.data.EncryptData;

public class EncryptContainerOperation
implements Undoable {
    private ContainerKey containerId;

    protected EncryptContainerOperation(RawContainerHandle hdl) throws StandardException {
        this.containerId = hdl.getId();
    }

    public EncryptContainerOperation() {
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        this.containerId.writeExternal(out);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.containerId = ContainerKey.read(in);
    }

    public ByteArray getPreparedLog() {
        return null;
    }

    public void releaseResource(Transaction tran) {
    }

    public int group() {
        return 256;
    }

    public boolean needsRedo(Transaction xact) throws StandardException {
        return false;
    }

    public int getTypeFormatId() {
        return 459;
    }

    public final void doMe(Transaction tran, LogInstant instant, LimitObjectInput in) throws StandardException {
        this.releaseResource(tran);
    }

    public void undoMe(Transaction tran) throws StandardException {
        BaseDataFileFactory bdff = (BaseDataFileFactory)((RawTransaction)tran).getDataFactory();
        EncryptData ed = new EncryptData(bdff);
        ed.restoreContainer(this.containerId);
        this.releaseResource(tran);
    }

    public Compensation generateUndo(Transaction tran, LimitObjectInput in) throws StandardException {
        return new EncryptContainerUndoOperation(this);
    }

    public String toString() {
        return "Encrypt container " + this.containerId;
    }
}

