/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.xact;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.iapi.services.io.CompressedNumber;
import org.apache.derby.iapi.services.io.LimitObjectInput;
import org.apache.derby.iapi.store.raw.GlobalTransactionId;
import org.apache.derby.iapi.store.raw.Loggable;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.iapi.store.raw.log.LogInstant;
import org.apache.derby.iapi.store.raw.xact.RawTransaction;
import org.apache.derby.iapi.util.ByteArray;

public class EndXact
implements Loggable {
    private int transactionStatus;
    private GlobalTransactionId xactId;

    public EndXact(GlobalTransactionId xid, int s) {
        this.xactId = xid;
        this.transactionStatus = s;
    }

    public EndXact() {
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.xactId);
        CompressedNumber.writeInt(out, this.transactionStatus);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.xactId = (GlobalTransactionId)in.readObject();
        this.transactionStatus = CompressedNumber.readInt(in);
    }

    public int getTypeFormatId() {
        return 102;
    }

    public void doMe(Transaction xact, LogInstant instant, LimitObjectInput in) {
        if ((this.transactionStatus & 2) == 0) {
            ((RawTransaction)xact).removeUpdateTransaction();
        } else {
            ((RawTransaction)xact).prepareTransaction();
        }
    }

    public ByteArray getPreparedLog() {
        return null;
    }

    public boolean needsRedo(Transaction xact) {
        return true;
    }

    public void releaseResource(Transaction xact) {
    }

    public int group() {
        int group = 256;
        if ((this.transactionStatus & 4) != 0) {
            group |= 0x12;
        } else if ((this.transactionStatus & 1) != 0) {
            group |= 0x22;
        } else if ((this.transactionStatus & 2) != 0) {
            group |= 0x40;
        }
        return group;
    }

    public String toString() {
        String endStatus;
        switch (this.transactionStatus & 7) {
            case 1: {
                endStatus = " Aborted";
                break;
            }
            case 2: {
                endStatus = " Prepared";
                break;
            }
            case 4: {
                endStatus = " Committed";
                break;
            }
            default: {
                endStatus = "Unknown";
            }
        }
        return "EndXact " + this.xactId + endStatus + " : transactionStatus = " + endStatus;
    }
}

