/*
 * Decompiled with CFR 0.152.
 */
package org.apache.thrift.async;

import java.io.IOException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.SelectorProvider;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeoutException;
import org.apache.thrift.TException;
import org.apache.thrift.async.TAsyncClient;
import org.apache.thrift.async.TAsyncMethodCall;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TAsyncClientManager {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)TAsyncClientManager.class.getName());
    private final SelectThread selectThread;
    private final ConcurrentLinkedQueue<TAsyncMethodCall> pendingCalls = new ConcurrentLinkedQueue();

    public TAsyncClientManager() throws IOException {
        this.selectThread = new SelectThread();
        this.selectThread.start();
    }

    public void call(TAsyncMethodCall method) throws TException {
        method.prepareMethodCall();
        this.pendingCalls.add(method);
        this.selectThread.getSelector().wakeup();
    }

    public void stop() {
        this.selectThread.finish();
    }

    private class SelectThread
    extends Thread {
        private static final long SELECT_TIME = 5L;
        private final Selector selector;
        private volatile boolean running = true;
        private final Set<TAsyncMethodCall> timeoutWatchSet = new HashSet<TAsyncMethodCall>();

        public SelectThread() throws IOException {
            this.selector = SelectorProvider.provider().openSelector();
            this.setDaemon(true);
        }

        public Selector getSelector() {
            return this.selector;
        }

        public void finish() {
            this.running = false;
            this.selector.wakeup();
        }

        public void run() {
            while (this.running) {
                try {
                    try {
                        this.selector.select(5L);
                    }
                    catch (IOException e) {
                        LOGGER.error("Caught IOException in TAsyncClientManager!", (Throwable)e);
                    }
                    this.transitionMethods();
                    this.timeoutIdleMethods();
                    this.startPendingMethods();
                }
                catch (Throwable throwable) {
                    LOGGER.error("Ignoring uncaught exception in SelectThread", throwable);
                }
            }
        }

        private void transitionMethods() {
            try {
                Iterator<SelectionKey> keys = this.selector.selectedKeys().iterator();
                while (keys.hasNext()) {
                    SelectionKey key = keys.next();
                    keys.remove();
                    if (!key.isValid()) continue;
                    TAsyncMethodCall methodCall = (TAsyncMethodCall)key.attachment();
                    methodCall.transition(key);
                    if (!methodCall.isFinished() && !methodCall.getClient().hasError()) continue;
                    this.timeoutWatchSet.remove(methodCall);
                }
            }
            catch (ClosedSelectorException e) {
                LOGGER.error("Caught ClosedSelectorException in TAsyncClientManager!", (Throwable)e);
            }
        }

        private void timeoutIdleMethods() {
            Iterator<TAsyncMethodCall> iterator = this.timeoutWatchSet.iterator();
            while (iterator.hasNext()) {
                TAsyncMethodCall methodCall = iterator.next();
                long clientTimeout = methodCall.getClient().getTimeout();
                long timeElapsed = System.currentTimeMillis() - methodCall.getLastTransitionTime();
                if (timeElapsed <= clientTimeout) continue;
                iterator.remove();
                methodCall.onError(new TimeoutException("Operation " + methodCall.getClass() + " timed out after " + timeElapsed + " milliseconds."));
            }
        }

        private void startPendingMethods() {
            TAsyncMethodCall methodCall;
            while ((methodCall = (TAsyncMethodCall)TAsyncClientManager.this.pendingCalls.poll()) != null) {
                try {
                    methodCall.start(this.selector);
                    TAsyncClient client = methodCall.getClient();
                    if (!client.hasTimeout() || client.hasError()) continue;
                    this.timeoutWatchSet.add(methodCall);
                }
                catch (Throwable e) {
                    LOGGER.warn("Caught throwable in TAsyncClientManager!", e);
                    methodCall.onError(e);
                }
            }
        }
    }
}

