/*
	Copyright (c) 2004-2008, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/book/dojo-book-0-9/introduction/licensing
*/


if(!dojo._hasResource["dojox.widget.Loader"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["dojox.widget.Loader"] = true;
dojo.provide("dojox.widget.Loader");
dojo.experimental("dojox.widget.Loader"); 

dojo.require("dijit._Widget");
dojo.require("dijit._Templated"); 

dojo.declare("dojox.widget.Loader", [dijit._Widget,dijit._Templated], {
	// summary: a configurable global xhr-listener to display
	// a loading message during running xhr's or to simply provide 
	// base-level topic to subscribe to for custom loading messages 

	// loadIcon: String
	// 	location to the icon used. 
	loadIcon: dojo.moduleUrl("dojox.widget.Loader","icons/loading.gif"),

	// loadMessage: String
	//	string to use for progress loading
	loadMessage: 'Loading ...',

	// hasVisuals: Boolean
	// 	true to display a fixed loading message in TR cornder, false to unly provide
	//	"Loader" topic to subscribe to for your own custom loading message.	
	hasVisuals: true,

	// attachToPointer
	// 	true to use visual indicator where cursor is
	attachToPointer: true,

	// duration: Integer
	//	time in ms to toggle in/out the visual load indicator
	duration: 125,

	// _offset: Integer
	//	distance in px from the mouse pointer to show attachToPointer avatar
	_offset: 16, 

	// holder for mousemove connection
	_pointerConnect: null, 
	_xhrStart: null,
	_xhrEnd: null,

	templateString: '<div dojoAttachPoint="loadNode" class="dojoxLoader">'
		+'<img src="${loadIcon}" class="dojoxLoaderIcon"> <span dojoAttachPoint="loadMessageNode" class="dojoxLoaderMessage"></span>'
		+'</div>',
	
	postCreate: function(){
		// summary: setup the loader

		if(!this.hasVisuals){ 
			this.loadNode.style.display = "none"; // _destroy()?
		}else{
			if(this.attachToPointer){
				dojo.removeClass(this.loadNode,"dojoxLoader"); 
				dojo.addClass(this.loadNode,"dojoxLoaderPointer"); 
			}
			this._hide();
		}
		this._setMessage(this.loadMessage); 

		// FIXME: create our connections.  would be easier, and this might be redundant
		// if Deferred published something
		this._xhrStart = dojo.connect(dojo,"_ioSetArgs",this,"_show"); 
		this._xhrEnd = dojo.connect(dojo.Deferred.prototype,"_fire",this,"_hide"); 

	},

	_setMessage: function(/* String */ message){
		// summary: set's the message in the loader
		this.loadMessageNode.innerHTML = message;
	},

	_putLoader: function(/* Event */ e){
		// summary: place the floating loading element based on mousemove connection position
		dijit.placeOnScreen(this.loadNode,{ x: e.clientX+this._offset, y:e.clientY+this._offset }, ["TL","BR"]); 
	},

	_show: function(){
		// summary: publish and show progress indicator
		dojo.publish("Loader",[{ message: 'started' }]);
		if(this.hasVisuals){ 
			if(this.attachToPointer){
				this._pointerConnect = dojo.connect(document,"onmousemove",this,"_putLoader");
			}
			dojo.fadeIn({ node: this.loadNode, duration:this.duration }).play(); 
		}
	},

	_hide: function(){
		// summary: publish "xhr ended" and hide progress indicator
		dojo.publish("Loader",[{ message: 'ended' }]);
		if(this.hasVisuals){ 
			if(this.attachToPointer){
				dojo.disconnect(this._pointerConnect); 
			}
			dojo.fadeOut({ node: this.loadNode, duration:this.duration }).play();
		}
	}

});

}
