/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.creation;

import org.mockito.MockSettings;
import org.mockito.exceptions.Reporter;
import org.mockito.internal.util.MockName;
import org.mockito.stubbing.Answer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockSettingsImpl
implements MockSettings {
    private static final long serialVersionUID = 4475297236197939568L;
    private Class<?>[] extraInterfaces;
    private String name;
    private Object spiedInstance;
    private Answer<Object> defaultAnswer;
    private MockName mockName;
    private boolean serializable;

    @Override
    public MockSettings serializable() {
        this.serializable = true;
        return this;
    }

    @Override
    public MockSettings extraInterfaces(Class<?> ... extraInterfaces) {
        if (extraInterfaces == null || extraInterfaces.length == 0) {
            new Reporter().extraInterfacesRequiresAtLeastOneInterface();
        }
        for (Class<?> i : extraInterfaces) {
            if (i == null) {
                new Reporter().extraInterfacesDoesNotAcceptNullParameters();
                continue;
            }
            if (i.isInterface()) continue;
            new Reporter().extraInterfacesAcceptsOnlyInterfaces(i);
        }
        this.extraInterfaces = extraInterfaces;
        return this;
    }

    public MockName getMockName() {
        return this.mockName;
    }

    public Class<?>[] getExtraInterfaces() {
        return this.extraInterfaces;
    }

    public Object getSpiedInstance() {
        return this.spiedInstance;
    }

    @Override
    public MockSettings name(String name) {
        this.name = name;
        return this;
    }

    @Override
    public MockSettings spiedInstance(Object spiedInstance) {
        this.spiedInstance = spiedInstance;
        return this;
    }

    @Override
    public MockSettings defaultAnswer(Answer defaultAnswer) {
        this.defaultAnswer = defaultAnswer;
        return this;
    }

    public Answer<Object> getDefaultAnswer() {
        return this.defaultAnswer;
    }

    public boolean isSerializable() {
        return this.serializable;
    }

    public void initiateMockName(Class classToMock) {
        this.mockName = new MockName(this.name, classToMock);
    }
}

