/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.stubbing;

import org.mockito.internal.stubbing.answers.CallsRealMethods;
import org.mockito.internal.stubbing.answers.Returns;
import org.mockito.internal.stubbing.answers.ThrowsException;
import org.mockito.stubbing.DeprecatedOngoingStubbing;
import org.mockito.stubbing.OngoingStubbing;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseStubbing<T>
implements OngoingStubbing<T>,
DeprecatedOngoingStubbing<T> {
    @Override
    public OngoingStubbing<T> thenReturn(T value) {
        return this.thenAnswer(new Returns(value));
    }

    @Override
    public OngoingStubbing<T> thenReturn(T value, T ... values) {
        OngoingStubbing<T> stubbing = this.thenReturn(value);
        if (values == null) {
            return stubbing.thenReturn(null);
        }
        for (T v : values) {
            stubbing = stubbing.thenReturn(v);
        }
        return stubbing;
    }

    private OngoingStubbing<T> thenThrow(Throwable throwable) {
        return this.thenAnswer(new ThrowsException(throwable));
    }

    @Override
    public OngoingStubbing<T> thenThrow(Throwable ... throwables) {
        if (throwables == null) {
            this.thenThrow((Throwable)null);
        }
        OngoingStubbing<T> stubbing = null;
        for (Throwable t : throwables) {
            stubbing = stubbing == null ? this.thenThrow(t) : stubbing.thenThrow(t);
        }
        return stubbing;
    }

    @Override
    public OngoingStubbing<T> thenCallRealMethod() {
        return this.thenAnswer(new CallsRealMethods());
    }

    @Override
    public DeprecatedOngoingStubbing<T> toReturn(T value) {
        return this.toAnswer(new Returns(value));
    }

    @Override
    public DeprecatedOngoingStubbing<T> toThrow(Throwable throwable) {
        return this.toAnswer(new ThrowsException(throwable));
    }
}

