/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.stubbing;

import java.util.LinkedList;
import java.util.List;
import org.mockito.exceptions.Reporter;
import org.mockito.internal.stubbing.answers.DoesNothing;
import org.mockito.internal.stubbing.answers.Returns;
import org.mockito.internal.stubbing.answers.ThrowsException;
import org.mockito.internal.util.MockUtil;
import org.mockito.stubbing.Answer;
import org.mockito.stubbing.Stubber;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StubberImpl
implements Stubber {
    final List<Answer> answers = new LinkedList<Answer>();
    private final Reporter reporter = new Reporter();

    @Override
    public <T> T when(T mock) {
        MockUtil mockUtil = new MockUtil();
        if (mock == null) {
            this.reporter.nullPassedToWhenMethod();
        } else if (!mockUtil.isMock(mock)) {
            this.reporter.notAMockPassedToWhenMethod();
        }
        mockUtil.getMockHandler(mock).setAnswersForStubbing(this.answers);
        return mock;
    }

    @Override
    public Stubber doReturn(Object toBeReturned) {
        this.answers.add(new Returns(toBeReturned));
        return this;
    }

    @Override
    public Stubber doThrow(Throwable toBeThrown) {
        this.answers.add(new ThrowsException(toBeThrown));
        return this;
    }

    @Override
    public Stubber doNothing() {
        this.answers.add(new DoesNothing());
        return this;
    }

    @Override
    public Stubber doAnswer(Answer answer) {
        this.answers.add(answer);
        return this;
    }
}

