/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.util;

import org.mockito.exceptions.Reporter;
import org.mockito.internal.creation.jmock.ClassImposterizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockCreationValidator {
    public boolean isTypeMockable(Class<?> clz) {
        return ClassImposterizer.INSTANCE.canImposterise(clz);
    }

    public void validateType(Class classToMock) {
        if (!this.isTypeMockable(classToMock)) {
            new Reporter().cannotMockFinalClass(classToMock);
        }
    }

    public void validateExtraInterfaces(Class classToMock, Class ... extraInterfaces) {
        if (extraInterfaces == null) {
            return;
        }
        for (Class i : extraInterfaces) {
            if (classToMock != i) continue;
            new Reporter().extraInterfacesCannotContainMockedType(classToMock);
        }
    }

    public void validateMockedType(Class classToMock, Object spiedInstance) {
        if (classToMock == null || spiedInstance == null) {
            return;
        }
        if (!classToMock.equals(spiedInstance.getClass())) {
            new Reporter().mockedTypeIsInconsistentWithSpiedInstanceType(classToMock, spiedInstance);
        }
    }
}

