/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.util;

import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockName
implements Serializable {
    private static final long serialVersionUID = 8014974700844306925L;
    private final String mockName;
    private boolean surrogate;

    public MockName(String mockName, Class classToMock) {
        if (mockName == null) {
            this.mockName = MockName.toInstanceName(classToMock);
            this.surrogate = true;
        } else {
            this.mockName = mockName;
        }
    }

    private static String toInstanceName(Class<?> clazz) {
        String className = clazz.getSimpleName();
        if (className.length() == 0) {
            className = clazz.getSuperclass().getSimpleName();
        }
        return className.substring(0, 1).toLowerCase() + className.substring(1);
    }

    public boolean isSurrogate() {
        return this.surrogate;
    }

    public String toString() {
        return this.mockName;
    }
}

