/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.verification;

import java.util.List;
import org.mockito.exceptions.base.MockitoException;
import org.mockito.internal.invocation.Invocation;
import org.mockito.internal.invocation.InvocationMatcher;
import org.mockito.internal.verification.api.VerificationData;
import org.mockito.internal.verification.api.VerificationDataInOrder;
import org.mockito.internal.verification.api.VerificationInOrderMode;
import org.mockito.internal.verification.checkers.AtLeastXNumberOfInvocationsChecker;
import org.mockito.internal.verification.checkers.AtLeastXNumberOfInvocationsInOrderChecker;
import org.mockito.internal.verification.checkers.MissingInvocationChecker;
import org.mockito.internal.verification.checkers.MissingInvocationInOrderChecker;
import org.mockito.verification.VerificationMode;

public class AtLeast
implements VerificationInOrderMode,
VerificationMode {
    final int wantedCount;

    public AtLeast(int wantedNumberOfInvocations) {
        if (wantedNumberOfInvocations < 0) {
            throw new MockitoException("Negative value is not allowed here");
        }
        this.wantedCount = wantedNumberOfInvocations;
    }

    public void verify(VerificationData data) {
        MissingInvocationChecker missingInvocation = new MissingInvocationChecker();
        AtLeastXNumberOfInvocationsChecker numberOfInvocations = new AtLeastXNumberOfInvocationsChecker();
        if (this.wantedCount == 1) {
            missingInvocation.check(data.getAllInvocations(), data.getWanted());
        }
        numberOfInvocations.check(data.getAllInvocations(), data.getWanted(), this.wantedCount);
    }

    public void verifyInOrder(VerificationDataInOrder data) {
        List<Invocation> allInvocations = data.getAllInvocations();
        InvocationMatcher wanted = data.getWanted();
        MissingInvocationInOrderChecker missingInvocation = new MissingInvocationInOrderChecker();
        AtLeastXNumberOfInvocationsInOrderChecker numberOfCalls = new AtLeastXNumberOfInvocationsInOrderChecker(data.getOrderingContext());
        if (this.wantedCount == 1) {
            missingInvocation.check(allInvocations, wanted, this, data.getOrderingContext());
        }
        numberOfCalls.check(allInvocations, wanted, this.wantedCount);
    }

    public String toString() {
        return "Wanted invocations count: at least " + this.wantedCount;
    }
}

