/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.verification.checkers;

import java.util.List;
import org.mockito.exceptions.Reporter;
import org.mockito.internal.invocation.Invocation;
import org.mockito.internal.invocation.InvocationMatcher;
import org.mockito.internal.invocation.InvocationsFinder;
import org.mockito.internal.reporting.SmartPrinter;
import org.mockito.internal.verification.argumentmatching.ArgumentMatchingTool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MissingInvocationChecker {
    private final Reporter reporter;
    private final InvocationsFinder finder;

    public MissingInvocationChecker() {
        this(new InvocationsFinder(), new Reporter());
    }

    MissingInvocationChecker(InvocationsFinder finder, Reporter reporter) {
        this.finder = finder;
        this.reporter = reporter;
    }

    public void check(List<Invocation> invocations, InvocationMatcher wanted) {
        List<Invocation> actualInvocations = this.finder.findInvocations(invocations, wanted);
        if (actualInvocations.isEmpty()) {
            Invocation similar = this.finder.findSimilarInvocation(invocations, wanted);
            if (similar != null) {
                ArgumentMatchingTool argumentMatchingTool = new ArgumentMatchingTool();
                Integer[] indexesOfSuspiciousArgs = argumentMatchingTool.getSuspiciouslyNotMatchingArgsIndexes(wanted.getMatchers(), similar.getArguments());
                SmartPrinter smartPrinter = new SmartPrinter(wanted, similar, indexesOfSuspiciousArgs);
                this.reporter.argumentsAreDifferent(smartPrinter.getWanted(), smartPrinter.getActual(), similar.getLocation());
            } else {
                this.reporter.wantedButNotInvoked(wanted, invocations);
            }
        }
    }
}

