/*
 * Decompiled with CFR 0.152.
 */
package org.openid4java.message.ax;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openid4java.message.MessageException;
import org.openid4java.message.Parameter;
import org.openid4java.message.ParameterList;
import org.openid4java.message.ax.AxPayload;
import org.openid4java.message.ax.FetchRequest;

public class FetchResponse
extends AxPayload {
    private static Log _log = LogFactory.getLog(FetchResponse.class);
    private static final boolean DEBUG = _log.isDebugEnabled();

    protected FetchResponse() {
        this._parameters.set(new Parameter("mode", "fetch_response"));
        if (DEBUG) {
            _log.debug((Object)"Created empty fetch response.");
        }
    }

    public static FetchResponse createFetchResponse() {
        return new FetchResponse();
    }

    protected FetchResponse(ParameterList params) {
        this._parameters = params;
    }

    public static FetchResponse createFetchResponse(ParameterList params) throws MessageException {
        FetchResponse resp = new FetchResponse(params);
        if (!resp.isValid()) {
            throw new MessageException("Invalid parameters for a fetch response");
        }
        if (DEBUG) {
            _log.debug((Object)("Created fetch response from parameter list:\n" + params));
        }
        return resp;
    }

    public static FetchResponse createFetchResponse(FetchRequest req, Map userData) throws MessageException {
        FetchResponse resp = new FetchResponse();
        Map attributes = req.getAttributes();
        for (String alias : attributes.keySet()) {
            Object value = userData.get(alias);
            if (value == null) continue;
            if (value instanceof String) {
                resp.addAttribute(alias, (String)attributes.get(alias), (String)value);
                continue;
            }
            if (!(value instanceof List)) continue;
            Iterator values = ((List)value).iterator();
            int max = req.getCount(alias);
            for (int count = 0; count < max && values.hasNext(); ++count) {
                String val = (String)values.next();
                if (val == null) {
                    --count;
                    continue;
                }
                resp.addAttribute(alias, (String)attributes.get(alias), val);
            }
        }
        return resp;
    }

    public void setUpdateUrl(String updateUrl) throws MessageException {
        try {
            new URL(updateUrl);
        }
        catch (MalformedURLException e) {
            throw new MessageException("Invalid update_url: " + updateUrl);
        }
        if (DEBUG) {
            _log.debug((Object)("Setting fetch response update_url: " + updateUrl));
        }
        this._parameters.set(new Parameter("update_url", updateUrl));
    }

    public String getUpdateUrl() {
        return this._parameters.hasParameter("update_url") ? this._parameters.getParameterValue("update_url") : null;
    }

    protected boolean isValid() {
        if (!this._parameters.hasParameter("mode") || !"fetch_response".equals(this._parameters.getParameterValue("mode"))) {
            _log.warn((Object)("Invalid mode value in fetch_reponse: " + this._parameters.getParameterValue("mode")));
            return false;
        }
        return super.isValid();
    }
}

