/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.format;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.php.internal.core.documentModel.parser.regions.IPhpScriptRegion;
import org.eclipse.php.internal.core.documentModel.partitioner.PHPPartitionTypes;
import org.eclipse.php.internal.core.format.FormatPreferencesSupport;
import org.eclipse.php.internal.core.format.FormatterUtils;
import org.eclipse.php.internal.core.format.IIndentationStrategy;
import org.eclipse.php.internal.core.util.text.PHPTextSequenceUtilities;
import org.eclipse.php.internal.core.util.text.TextSequence;
import org.eclipse.wst.sse.core.internal.parser.ContextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionContainer;

public class DefaultIndentationStrategy
implements IIndentationStrategy {
    protected static boolean isBlanks(IStructuredDocument document, int startOffset, int endOffset, int currentOffset) throws BadLocationException {
        return document.get(startOffset, endOffset - startOffset).trim().length() == 0 || document.get(startOffset, currentOffset - startOffset).trim().length() == 0;
    }

    public static int getIndentationBaseLine(IStructuredDocument document, int lineNumber, int offset, boolean checkMultiLine) throws BadLocationException {
        int currLineIndex = lineNumber;
        while (currLineIndex >= 0) {
            IRegion lineInfo = document.getLineInformation(currLineIndex);
            if (lineInfo.getLength() == 0) {
                --currLineIndex;
                continue;
            }
            int currLineEndOffset = lineInfo.getOffset() + lineInfo.getLength();
            boolean isIndentationBase = DefaultIndentationStrategy.isIndentationBase(document, Math.min(offset, currLineEndOffset), offset, currLineIndex, checkMultiLine);
            if (isIndentationBase) {
                return currLineIndex;
            }
            --currLineIndex;
        }
        return 0;
    }

    private static ITextRegion getLastTokenRegion(IStructuredDocument document, IRegion line, int forOffset) throws BadLocationException {
        int offset = forOffset;
        int lineStartOffset = line.getOffset();
        IStructuredDocumentRegion sdRegion = document.getRegionAtCharacterOffset(offset);
        if (sdRegion == null) {
            return null;
        }
        ITextRegion tRegion = sdRegion.getRegionAtCharacterOffset(offset);
        if (tRegion == null && offset == document.getLength()) {
            tRegion = sdRegion.getRegionAtCharacterOffset(--offset);
        }
        int regionStart = sdRegion.getStartOffset(tRegion);
        if (tRegion instanceof ITextRegionContainer) {
            ITextRegionContainer container = (ITextRegionContainer)tRegion;
            tRegion = container.getRegionAtCharacterOffset(offset);
            regionStart += tRegion.getStart();
        }
        if (tRegion instanceof IPhpScriptRegion) {
            IPhpScriptRegion scriptRegion = (IPhpScriptRegion)tRegion;
            if ((tRegion = scriptRegion.getPhpToken(offset - regionStart)) == null) {
                return null;
            }
            do {
                String token = tRegion.getType();
                if (regionStart + tRegion.getStart() >= forOffset || PHPPartitionTypes.isPHPCommentState(token) || token == "WHITESPACE") continue;
                return tRegion;
            } while ((tRegion = scriptRegion.getPhpToken(tRegion.getStart() - 1)) != null && tRegion.getStart() + regionStart > lineStartOffset);
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private static boolean isIndentationBase(IStructuredDocument document, int checkedOffset, int forOffset, int currLineIndex, boolean checkMultiLine) throws BadLocationException {
        lineInfo = document.getLineInformationOfOffset(checkedOffset);
        lineStart = lineInfo.getOffset();
        if (!DefaultIndentationStrategy.isBlanks(document, lineStart, checkedOffset, forOffset)) ** GOTO lbl6
        return false;
lbl-1000:
        // 1 sources

        {
            ++lineStart;
lbl6:
            // 2 sources

            ** while (Character.isWhitespace((char)document.getChar((int)lineStart)))
        }
lbl7:
        // 1 sources

        checkedLineBeginState = FormatterUtils.getPartitionType(document, lineStart, true);
        checkedLineEndState = FormatterUtils.getPartitionType(document, checkedOffset, true);
        forLineEndState = FormatterUtils.getPartitionType(document, forOffset);
        if (DefaultIndentationStrategy.shouldNotConsiderAsIndentationBase(checkedLineBeginState, forLineEndState) || checkMultiLine && DefaultIndentationStrategy.isInMultiLineStatement(document, checkedLineBeginState, checkedLineEndState, checkedOffset, lineStart, currLineIndex)) {
            return false;
        }
        if ((checkedLineBeginState == "org.eclipse.php.PHP_MULTI_LINE_COMMENT" || checkedLineBeginState == "org.eclipse.php.PHP_DOC") && checkedLineBeginState == forLineEndState) {
            sdRegion = document.getRegionAtCharacterOffset(lineStart);
            phpScriptRegion = sdRegion.getRegionAtCharacterOffset(lineStart);
            phpContentStartOffset = sdRegion.getStartOffset(phpScriptRegion);
            if (phpScriptRegion instanceof ITextRegionContainer) {
                container = (ITextRegionContainer)phpScriptRegion;
                phpScriptRegion = container.getRegionAtCharacterOffset(lineStart);
                phpContentStartOffset += phpScriptRegion.getStart();
            }
            if (phpScriptRegion instanceof IPhpScriptRegion) {
                scriptRegion = (IPhpScriptRegion)phpScriptRegion;
                checkedRegion = (ContextRegion)scriptRegion.getPhpToken(lineStart - phpContentStartOffset);
                currentRegion = (ContextRegion)scriptRegion.getPhpToken(forOffset - phpContentStartOffset);
                checkedType = checkedRegion.getType();
                currentType = currentRegion.getType();
                if (currentType.equals("PHPDOC_COMMENT_START") || currentType.equals("PHP_COMMENT_START")) {
                    return checkedType.equals("PHPDOC_COMMENT_START") != false || checkedType.equals("PHP_COMMENT_START") != false;
                }
            }
        }
        return DefaultIndentationStrategy.lineShouldInedent(checkedLineBeginState, checkedLineEndState) != false || forLineEndState == checkedLineBeginState;
    }

    private static boolean isInMultiLineStatement(IStructuredDocument document, String checkedLineBeginState, String checkedLineEndState, int checkedOffset, int lineStart, int currLineIndex) {
        try {
            char[] line = document.get(lineStart, document.getLineLength(currLineIndex)).toCharArray();
            int i = 0;
            while (i < line.length) {
                char c = line[i];
                if (!Character.isWhitespace(c)) {
                    lineStart += i + 1;
                    break;
                }
                ++i;
            }
        }
        catch (BadLocationException badLocationException) {}
        TextSequence textSequence = PHPTextSequenceUtilities.getStatement(lineStart, document.getRegionAtCharacterOffset(lineStart), true);
        return textSequence != null && DefaultIndentationStrategy.isRegionTypeAllowedMultiline(FormatterUtils.getRegionType(document, textSequence.getOriginalOffset(0))) && document.getLineOfOffset(textSequence.getOriginalOffset(0)) < currLineIndex;
    }

    private static boolean isRegionTypeAllowedMultiline(String regionType) {
        return regionType != null && !"PHPDOC_COMMENT_START".equals(regionType) && !"PHP_CASE".equals(regionType);
    }

    public static boolean lineShouldInedent(String beginState, String endState) {
        return beginState == "org.eclipse.php.PHP_DEFAULT" || endState == "org.eclipse.php.PHP_DEFAULT";
    }

    public void placeMatchingBlanks(IStructuredDocument document, StringBuffer result, int lineNumber, int forOffset) throws BadLocationException {
        DefaultIndentationStrategy.placeMatchingBlanksForStructuredDocument(document, result, lineNumber, forOffset);
    }

    public static void placeMatchingBlanksForStructuredDocument(IStructuredDocument document, StringBuffer result, int lineNumber, int forOffset) throws BadLocationException {
        int line;
        int offset;
        boolean enterKeyPressed = document.getLineDelimiter().equals(result.toString());
        int lastNonEmptyLineIndex = DefaultIndentationStrategy.getIndentationBaseLine(document, lineNumber, forOffset, false);
        int indentationBaseLineIndex = DefaultIndentationStrategy.getIndentationBaseLine(document, lineNumber, forOffset, true);
        IRegion lastNonEmptyLine = document.getLineInformation(lastNonEmptyLineIndex);
        IRegion indentationBaseLine = document.getLineInformation(indentationBaseLineIndex);
        String blanks = FormatterUtils.getLineBlanks(document, indentationBaseLine);
        result.append(blanks);
        int lastLineEndOffset = lastNonEmptyLine.getOffset() + lastNonEmptyLine.getLength();
        if (forOffset < lastLineEndOffset) {
            offset = forOffset;
            line = lineNumber;
        } else {
            offset = lastLineEndOffset;
            line = lastNonEmptyLineIndex;
        }
        if (DefaultIndentationStrategy.shouldIndent(document, offset, line)) {
            int indentationSize = FormatPreferencesSupport.getInstance().getIndentationSize((IDocument)document);
            char indentationChar = FormatPreferencesSupport.getInstance().getIndentationChar((IDocument)document);
            int i = 0;
            while (i < indentationSize) {
                result.append(indentationChar);
                ++i;
            }
        } else {
            IRegion lineInfo;
            lastNonEmptyLineIndex = lineNumber;
            if (!enterKeyPressed && lastNonEmptyLineIndex > 0) {
                --lastNonEmptyLineIndex;
            }
            while (lastNonEmptyLineIndex >= 0) {
                lineInfo = document.getLineInformation(lastNonEmptyLineIndex);
                String content = document.get(lineInfo.getOffset(), lineInfo.getLength());
                if (content.trim().length() > 0) break;
                --lastNonEmptyLineIndex;
            }
            if (!DefaultIndentationStrategy.isEndOfStatement(document, offset, lastNonEmptyLineIndex) && enterKeyPressed) {
                if (indentationBaseLineIndex == lastNonEmptyLineIndex) {
                    DefaultIndentationStrategy.placeStringIndentation(document, lastNonEmptyLineIndex, result);
                } else {
                    result.setLength(result.length() - blanks.length());
                    lineInfo = document.getLineInformation(lastNonEmptyLineIndex);
                    result.append(FormatterUtils.getLineBlanks(document, lineInfo));
                }
            }
        }
    }

    private static boolean isEndOfStatement(IStructuredDocument document, int offset, int lineNumber) {
        ITextRegion token;
        block4: {
            try {
                IRegion lineInfo = document.getLineInformation(lineNumber);
                document.getRegionAtCharacterOffset(offset);
                token = DefaultIndentationStrategy.getLastTokenRegion(document, lineInfo, lineInfo.getOffset() + lineInfo.getLength());
                if (token != null) break block4;
                return true;
            }
            catch (BadLocationException badLocationException) {}
        }
        if (token.getType() == "PHP_SEMICOLON" || token.getType() == "PHP_CURLY_CLOSE") {
            return true;
        }
        return false;
    }

    private static void placeStringIndentation(IStructuredDocument document, int lineNumber, StringBuffer result) {
        try {
            IRegion lineInfo = document.getLineInformation(lineNumber);
            int offset = lineInfo.getOffset() + lineInfo.getLength();
            IStructuredDocumentRegion sdRegion = document.getRegionAtCharacterOffset(offset);
            ITextRegion token = DefaultIndentationStrategy.getLastTokenRegion(document, lineInfo, offset);
            if (token == null) {
                return;
            }
            String tokenType = token.getType();
            if (tokenType == "PHP_CURLY_OPEN") {
                return;
            }
            ITextRegion scriptRegion = sdRegion.getRegionAtCharacterOffset(offset);
            if (scriptRegion == null && offset == document.getLength()) {
                scriptRegion = sdRegion.getRegionAtCharacterOffset(--offset);
            }
            int regionStart = sdRegion.getStartOffset(scriptRegion);
            if (scriptRegion instanceof ITextRegionContainer) {
                ITextRegionContainer container = (ITextRegionContainer)scriptRegion;
                scriptRegion = container.getRegionAtCharacterOffset(offset);
                regionStart += scriptRegion.getStart();
            }
            if (scriptRegion instanceof IPhpScriptRegion && tokenType == "PHP_TOKEN" && document.getChar(regionStart + token.getStart()) == '.' && (token = ((IPhpScriptRegion)scriptRegion).getPhpToken(token.getStart() - 1)) != null && token.getType() == "PHP_CONSTANT_ENCAPSED_STRING") {
                boolean isToken = true;
                int currentOffset = regionStart + token.getStart() - 1;
                while (currentOffset >= lineInfo.getOffset()) {
                    token = ((IPhpScriptRegion)scriptRegion).getPhpToken(token.getStart() - 1);
                    tokenType = token.getType();
                    if ((!isToken || tokenType != "PHP_TOKEN" || document.getChar(regionStart + token.getStart()) != '.') && (isToken || tokenType != "PHP_CONSTANT_ENCAPSED_STRING")) break;
                    currentOffset = regionStart + token.getStart() - 1;
                }
                int i = 0;
                while (i < regionStart + token.getEnd() - lineInfo.getOffset()) {
                    result.append(' ');
                    ++i;
                }
            }
        }
        catch (BadLocationException badLocationException) {}
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static boolean shouldIndent(IStructuredDocument document, int offset, int lineNumber) {
        try {
            IRegion lineInfo = document.getLineInformation(lineNumber);
            IStructuredDocumentRegion sdRegion = document.getRegionAtCharacterOffset(offset);
            ITextRegion token = DefaultIndentationStrategy.getLastTokenRegion(document, lineInfo, offset);
            if (token == null) {
                return false;
            }
            String tokenType = token.getType();
            if (tokenType == "PHP_CURLY_OPEN") {
                return true;
            }
            ITextRegion scriptRegion = sdRegion.getRegionAtCharacterOffset(offset);
            if (scriptRegion == null && offset == document.getLength()) {
                scriptRegion = sdRegion.getRegionAtCharacterOffset(--offset);
            }
            int regionStart = sdRegion.getStartOffset(scriptRegion);
            if (scriptRegion instanceof ITextRegionContainer) {
                ITextRegionContainer container = (ITextRegionContainer)scriptRegion;
                scriptRegion = container.getRegionAtCharacterOffset(offset);
                regionStart += scriptRegion.getStart();
            }
            if (!(scriptRegion instanceof IPhpScriptRegion)) return false;
            if (tokenType != "PHP_TOKEN") return false;
            if (document.getChar(regionStart + token.getStart()) != ':') return false;
            int currentOffset = regionStart + token.getStart() - 1;
            while (true) {
                if (currentOffset < lineInfo.getOffset()) {
                    return false;
                }
                tokenType = (token = ((IPhpScriptRegion)scriptRegion).getPhpToken(token.getStart() - 1)).getType();
                if (tokenType == "PHP_CASE") return true;
                if (tokenType == "PHP_DEFAULT") {
                    return true;
                }
                currentOffset = regionStart + token.getStart() - 1;
            }
        }
        catch (BadLocationException badLocationException) {}
        return false;
    }

    public static boolean shouldNotConsiderAsIndentationBase(String currentState, String forState) {
        return currentState != forState && (currentState == "org.eclipse.php.PHP_MULTI_LINE_COMMENT" || currentState == "org.eclipse.php.PHP_DOC" || currentState == "org.eclipse.php.PHP_QUOTED_STRING");
    }
}

