/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.project;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.core.preferences.CorePreferencesSupport;

public class ProjectOptions {
    private ProjectOptions() {
    }

    private static IProject getProject(IModelElement modelElement) {
        IScriptProject scriptProject = modelElement.getScriptProject();
        if (scriptProject != null) {
            return scriptProject.getProject();
        }
        return null;
    }

    public static PHPVersion getPhpVersion(IModelElement modelElement) {
        return ProjectOptions.getPhpVersion(ProjectOptions.getProject(modelElement));
    }

    public static PHPVersion getPhpVersion(IProject project) {
        if (project != null) {
            return PHPVersion.byAlias(CorePreferencesSupport.getInstance().getPreferencesValue("phpVersion", null, project));
        }
        return ProjectOptions.getDefaultPhpVersion();
    }

    public static PHPVersion getPhpVersion(IFile file) {
        PHPVersion phpVersion = ProjectOptions.getDefaultPhpVersion();
        IProject project = file.getProject();
        if (project != null && project.isAccessible()) {
            phpVersion = ProjectOptions.getPhpVersion(project);
        }
        return phpVersion;
    }

    public static PHPVersion getPhpVersion(String fileName) {
        IProject project;
        PHPVersion phpVersion = ProjectOptions.getDefaultPhpVersion();
        IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(fileName);
        if (resource != null && (project = resource.getProject()).isAccessible()) {
            phpVersion = ProjectOptions.getPhpVersion(project);
        }
        return phpVersion;
    }

    public static PHPVersion getDefaultPhpVersion() {
        return PHPVersion.byAlias(CorePreferencesSupport.getInstance().getWorkspacePreferencesValue("phpVersion"));
    }

    public static boolean setPhpVersion(PHPVersion version, IProject project) {
        return CorePreferencesSupport.getInstance().setProjectSpecificPreferencesValue("phpVersion", version.getAlias(), project);
    }

    public static final boolean isSupportingAspTags(IProject project) {
        return project == null ? false : Boolean.valueOf(CorePreferencesSupport.getInstance().getPreferencesValue("use_asp_tags_as_php", null, project));
    }

    public static boolean useShortTags(IProject project) {
        String useShortTags = CorePreferencesSupport.getInstance().getPreferencesValue("useShortTags", null, project);
        return "true".equals(useShortTags);
    }

    public static final boolean isSupportingAspTags(IFile file) {
        return ProjectOptions.isSupportingAspTags(file.getProject());
    }

    public static final boolean setSupportingAspTags(boolean value, IProject project) {
        return CorePreferencesSupport.getInstance().setProjectSpecificPreferencesValue("use_asp_tags_as_php", Boolean.toString(value), project);
    }
}

