/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.codeassist.strategies;

import org.eclipse.dltk.internal.core.SourceRange;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.php.core.codeassist.ICompletionContext;
import org.eclipse.php.internal.core.codeassist.ICompletionReporter;
import org.eclipse.php.internal.core.codeassist.contexts.PHPDocTagContext;
import org.eclipse.php.internal.core.codeassist.strategies.GlobalClassesStrategy;

public class PHPDocReturnTypeStrategy
extends GlobalClassesStrategy {
    private static final String ARRAY_TYPE = "array";
    private static final String MIXED_TYPE = "mixed";
    private static final String VOID_TYPE = "void";
    private static final String EMPTY = "";

    public PHPDocReturnTypeStrategy(ICompletionContext context) {
        super(context);
    }

    public void apply(ICompletionReporter reporter) throws BadLocationException {
        ICompletionContext context = this.getContext();
        if (!(context instanceof PHPDocTagContext)) {
            return;
        }
        super.apply(reporter);
        String prefix = ((PHPDocTagContext)context).getPrefix();
        SourceRange replaceRange = this.getReplacementRange(context);
        this.reportKeyword(reporter, replaceRange, ARRAY_TYPE, prefix);
        this.reportKeyword(reporter, replaceRange, MIXED_TYPE, prefix);
        this.reportKeyword(reporter, replaceRange, VOID_TYPE, prefix);
    }

    private void reportKeyword(ICompletionReporter reporter, SourceRange replaceRange, String keyword, String prefix) {
        if (keyword.startsWith(prefix)) {
            reporter.reportKeyword(keyword, EMPTY, replaceRange);
        }
    }

    protected Object getExtraInfo() {
        return "TYPE_ONLY";
    }
}

