/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.typeinference.evaluators.phpdoc;

import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.evaluation.types.MultiTypeType;
import org.eclipse.dltk.ti.GoalState;
import org.eclipse.dltk.ti.goals.IGoal;
import org.eclipse.dltk.ti.types.IEvaluatedType;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPDocBlock;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPDocTag;
import org.eclipse.php.internal.core.index.IPHPDocAwareElement;
import org.eclipse.php.internal.core.typeinference.PHPClassType;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;
import org.eclipse.php.internal.core.typeinference.PHPSimpleTypes;
import org.eclipse.php.internal.core.typeinference.PHPTypeInferenceUtils;
import org.eclipse.php.internal.core.typeinference.evaluators.AbstractMethodReturnTypeEvaluator;
import org.eclipse.php.internal.core.typeinference.goals.AbstractMethodReturnTypeGoal;

public class PHPDocMethodReturnTypeEvaluator
extends AbstractMethodReturnTypeEvaluator {
    private static final Pattern ARRAY_TYPE_PATTERN = Pattern.compile("array\\[.*\\]");
    private static final String SELF_RETURN_TYPE = "self";
    private static final Pattern PIPE_PATTERN = Pattern.compile("\\|");
    private final List<IEvaluatedType> evaluated = new LinkedList<IEvaluatedType>();

    public PHPDocMethodReturnTypeEvaluator(IGoal goal) {
        super(goal);
    }

    public IGoal[] init() {
        IMethod[] iMethodArray = this.getMethods();
        int n = iMethodArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod method = iMethodArray[n2];
            IType currentNamespace = PHPModelUtils.getCurrentNamespace((IModelElement)method);
            if (method instanceof IPHPDocAwareElement) {
                String[] typeNames = ((IPHPDocAwareElement)method).getReturnTypes();
                if (typeNames != null) {
                    String[] stringArray = typeNames;
                    int n3 = typeNames.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String typeName = stringArray[n4];
                        Matcher m = ARRAY_TYPE_PATTERN.matcher(typeName);
                        if (m.find()) {
                            this.evaluated.add((IEvaluatedType)this.getArrayType(m.group(), currentNamespace));
                        } else {
                            IEvaluatedType type = this.getEvaluatedType(typeName, currentNamespace);
                            if (type != null) {
                                this.evaluated.add(type);
                            }
                        }
                        ++n4;
                    }
                }
            } else {
                PHPDocBlock docBlock = PHPModelUtils.getDocBlock(method);
                if (docBlock != null) {
                    AbstractMethodReturnTypeGoal typedGoal = (AbstractMethodReturnTypeGoal)this.goal;
                    IType[] types = typedGoal.getTypes();
                    PHPDocTag[] pHPDocTagArray = docBlock.getTags();
                    int n5 = pHPDocTagArray.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        PHPDocTag tag = pHPDocTagArray[n6];
                        if (tag.getTagKind() == 6) {
                            SimpleReference[] simpleReferenceArray = tag.getReferences();
                            int n7 = simpleReferenceArray.length;
                            int n8 = 0;
                            while (n8 < n7) {
                                String[] typesNames;
                                SimpleReference reference = simpleReferenceArray[n8];
                                String[] stringArray = typesNames = PIPE_PATTERN.split(reference.getName());
                                int n9 = typesNames.length;
                                int n10 = 0;
                                while (n10 < n9) {
                                    String typeName = stringArray[n10];
                                    Matcher m = ARRAY_TYPE_PATTERN.matcher(typeName);
                                    if (m.find()) {
                                        this.evaluated.add((IEvaluatedType)this.getArrayType(m.group(), currentNamespace));
                                    } else if (typeName.equals(SELF_RETURN_TYPE) && types != null) {
                                        IType[] iTypeArray = types;
                                        int n11 = types.length;
                                        int n12 = 0;
                                        while (n12 < n11) {
                                            IType t = iTypeArray[n12];
                                            IEvaluatedType type = this.getEvaluatedType(t.getElementName(), currentNamespace);
                                            if (type != null) {
                                                this.evaluated.add(type);
                                            }
                                            ++n12;
                                        }
                                    } else {
                                        IEvaluatedType type = this.getEvaluatedType(typeName, currentNamespace);
                                        if (type != null) {
                                            this.evaluated.add(type);
                                        }
                                    }
                                    ++n10;
                                }
                                ++n8;
                            }
                        }
                        ++n6;
                    }
                }
            }
            ++n2;
        }
        return IGoal.NO_GOALS;
    }

    private MultiTypeType getArrayType(String type, IType currentNamespace) {
        String[] typeNames;
        int beginIndex = type.indexOf("[") + 1;
        int endIndex = type.lastIndexOf("]");
        type = type.substring(beginIndex, endIndex);
        MultiTypeType arrayType = new MultiTypeType();
        Matcher m = ARRAY_TYPE_PATTERN.matcher(type);
        if (m.find()) {
            arrayType.addType((IEvaluatedType)this.getArrayType(m.group(), currentNamespace));
            type = m.replaceAll("");
        }
        String[] stringArray = typeNames = type.split(",");
        int n = typeNames.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            if (!"".equals(name)) {
                arrayType.addType(this.getEvaluatedType(name, currentNamespace));
            }
            ++n2;
        }
        return arrayType;
    }

    private IEvaluatedType getEvaluatedType(String typeName, IType currentNamespace) {
        Object type = PHPSimpleTypes.fromString(typeName);
        if (type == null) {
            if (typeName.indexOf(92) != -1 || currentNamespace == null) {
                type = new PHPClassType(typeName);
            } else if (currentNamespace != null) {
                type = new PHPClassType(currentNamespace.getElementName(), typeName);
            }
        }
        return type;
    }

    public Object produceResult() {
        return PHPTypeInferenceUtils.combineTypes(this.evaluated);
    }

    public IGoal[] subGoalDone(IGoal subgoal, Object result, GoalState state) {
        return IGoal.NO_GOALS;
    }
}

