/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.codeassist.contexts;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.dltk.core.CompletionRequestor;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.php.internal.core.codeassist.contexts.StatementContext;
import org.eclipse.php.internal.core.util.text.TextSequence;

public abstract class CatchContext
extends StatementContext {
    protected static final Pattern CATCH_PATTERN = Pattern.compile("catch\\s[^{]*", 2);
    private int catchStart;

    public boolean isValid(ISourceModule sourceModule, int offset, CompletionRequestor requestor) {
        if (!super.isValid(sourceModule, offset, requestor)) {
            return false;
        }
        TextSequence statementText = this.getStatementText();
        Matcher matcher = CATCH_PATTERN.matcher(statementText);
        this.catchStart = statementText.length();
        while (matcher.find()) {
            if (statementText.length() != matcher.end()) continue;
            this.catchStart = matcher.start() + 1;
            break;
        }
        return this.catchStart != statementText.length();
    }

    public int getCatchStart() {
        return this.catchStart;
    }
}

