/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.codeassist.strategies;

import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.core.SourceRange;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.php.core.codeassist.ICompletionContext;
import org.eclipse.php.core.codeassist.IElementFilter;
import org.eclipse.php.core.compiler.PHPFlags;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.codeassist.ICompletionReporter;
import org.eclipse.php.internal.core.codeassist.contexts.FunctionParameterTypeContext;
import org.eclipse.php.internal.core.codeassist.strategies.KeywordsStrategy;
import org.eclipse.php.internal.core.language.keywords.PHPKeywords;

public class FunctionParameterKeywordTypeStrategy
extends KeywordsStrategy {
    public static final String[] KEYWORDS = new String[]{"self", "parent"};

    public FunctionParameterKeywordTypeStrategy(ICompletionContext context, IElementFilter elementFilter) {
        super(context, elementFilter);
    }

    public FunctionParameterKeywordTypeStrategy(ICompletionContext context) {
        super(context);
    }

    public void apply(ICompletionReporter reporter) throws BadLocationException {
        FunctionParameterTypeContext context = (FunctionParameterTypeContext)this.getContext();
        if (context.getEnclosingType() != null) {
            try {
                int flags = context.getEnclosingType().getFlags();
                if (!PHPFlags.isNamespace(flags)) {
                    SourceRange replaceRange = this.getReplacementRange(context);
                    String suffix = "";
                    String prefix = context.getPrefix();
                    String[] stringArray = KEYWORDS;
                    int n = KEYWORDS.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String keyword = stringArray[n2];
                        if (keyword.startsWith(prefix)) {
                            reporter.reportKeyword(keyword, suffix, replaceRange);
                        }
                        ++n2;
                    }
                }
            }
            catch (ModelException e) {
                PHPCorePlugin.log(e);
            }
        }
    }

    protected boolean filterKeyword(PHPKeywords.KeywordData keyword) {
        return true;
    }
}

