/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.typeinference.evaluators;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.ti.GoalState;
import org.eclipse.dltk.ti.IContext;
import org.eclipse.dltk.ti.goals.ExpressionTypeGoal;
import org.eclipse.dltk.ti.goals.GoalEvaluator;
import org.eclipse.dltk.ti.goals.IGoal;
import org.eclipse.dltk.ti.types.IEvaluatedType;
import org.eclipse.php.internal.core.compiler.ast.nodes.FormalParameter;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPDocBlock;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPDocTag;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPMethodDeclaration;
import org.eclipse.php.internal.core.typeinference.PHPClassType;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;
import org.eclipse.php.internal.core.typeinference.context.MethodContext;

public class FormalParameterEvaluator
extends GoalEvaluator {
    private IEvaluatedType result;

    public FormalParameterEvaluator(IGoal goal) {
        super(goal);
    }

    public IGoal[] init() {
        ExpressionTypeGoal typedGoal = (ExpressionTypeGoal)this.goal;
        FormalParameter parameter = (FormalParameter)typedGoal.getExpression();
        SimpleReference type = parameter.getParameterType();
        if (type != null) {
            this.result = PHPClassType.fromSimpleReference(type);
        } else {
            IContext context = typedGoal.getContext();
            if (context instanceof MethodContext) {
                MethodContext methodContext = (MethodContext)context;
                PHPMethodDeclaration methodDeclaration = (PHPMethodDeclaration)methodContext.getMethodNode();
                PHPDocBlock[] docBlocks = new PHPDocBlock[]{};
                try {
                    IMethod method = (IMethod)methodContext.getSourceModule().getElementAt(methodDeclaration.getNameStart());
                    docBlocks = method.getDeclaringType() != null ? PHPModelUtils.getTypeHierarchyMethodDoc(method.getDeclaringType(), method.getElementName(), true, null) : new PHPDocBlock[]{methodDeclaration.getPHPDoc()};
                }
                catch (CoreException coreException) {}
                PHPDocBlock[] pHPDocBlockArray = docBlocks;
                int n = docBlocks.length;
                int n2 = 0;
                while (n2 < n) {
                    PHPDocBlock docBlock = pHPDocBlockArray[n2];
                    if (this.result != null) break;
                    if (docBlock != null) {
                        PHPDocTag[] pHPDocTagArray = docBlock.getTags();
                        int n3 = pHPDocTagArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            SimpleReference[] references;
                            PHPDocTag tag = pHPDocTagArray[n4];
                            if (tag.getTagKind() == 7 && (references = tag.getReferences()).length == 2 && references[0].getName().equals(parameter.getName())) {
                                this.result = PHPClassType.fromSimpleReference(references[1]);
                            }
                            ++n4;
                        }
                    }
                    ++n2;
                }
            }
        }
        return IGoal.NO_GOALS;
    }

    public Object produceResult() {
        return this.result;
    }

    public IGoal[] subGoalDone(IGoal subgoal, Object result, GoalState state) {
        return IGoal.NO_GOALS;
    }
}

