/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.preferences;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;
import org.eclipse.php.internal.debug.core.launching.PHPLaunchUtilities;
import org.eclipse.php.internal.debug.core.phpIni.PHPINIUtil;
import org.eclipse.php.internal.debug.core.preferences.PHPexes;

public class PHPexeItem {
    public static final String SAPI_CLI = "CLI";
    public static final String SAPI_CGI = "CGI";
    private static final Pattern PHP_VERSION = Pattern.compile("PHP (\\d\\.\\d\\.\\d+).*? \\((.*?)\\)");
    private static final Pattern PHP_CLI_CONFIG = Pattern.compile("Configuration File \\(php.ini\\) Path => (.*)");
    private static final Pattern PHP_CGI_CONFIG = Pattern.compile("Configuration File \\(php.ini\\) Path </td><td class=\"v\">(.*?)</td>");
    private String sapiType;
    private String name;
    private File config;
    private File detectedConfig;
    private File executable;
    private String version;
    private boolean editable = true;
    private String debuggerID;
    private boolean isDefault;
    private List<PHPVersion> defaultForPHPVersionList = new ArrayList<PHPVersion>();

    public PHPexeItem(String name, String executable, String config, String debuggerID) {
        this.name = name;
        this.debuggerID = debuggerID;
        this.executable = new File(executable);
        if (config != null && config.length() > 0) {
            this.config = new File(config);
        }
        this.detectFromPHPExe();
    }

    public PHPexeItem(String name, File executable, File iniLocation, String debuggerID, boolean editable) {
        this.name = name;
        this.executable = executable;
        this.config = iniLocation;
        this.debuggerID = debuggerID;
        this.editable = editable;
        this.detectFromPHPExe();
    }

    public PHPexeItem() {
    }

    public String getDebuggerID() {
        return this.debuggerID;
    }

    public void setDebuggerID(String debuggerID) {
        this.debuggerID = debuggerID;
    }

    public File getINILocation() {
        return this.config;
    }

    public File getDetectedINILocation() {
        return this.detectedConfig;
    }

    public void setINILocation(File location) {
        this.config = location;
    }

    public String getSapiType() {
        return this.sapiType;
    }

    public void setSapiType(String sapiType) {
        this.sapiType = sapiType;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public File getExecutable() {
        return this.executable;
    }

    public void setExecutable(File executable) {
        if (executable == null) {
            throw new IllegalArgumentException("PHP executable path is null");
        }
        if (executable.equals(this.executable)) {
            return;
        }
        this.executable = executable;
        this.config = null;
        this.detectFromPHPExe();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.executable == null ? 0 : this.executable.hashCode());
        result = 31 * result + (this.config == null ? 0 : this.config.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PHPexeItem other = (PHPexeItem)obj;
        if (this.config == null ? other.config != null : !this.config.equals(other.config)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(this.name);
        buf.append(" [path: ").append(this.executable.getAbsolutePath());
        buf.append(", config file: ").append(this.config.getAbsolutePath());
        buf.append(", sapi: ").append(this.sapiType);
        buf.append("]");
        return buf.toString();
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public void setDefault(boolean isDefault) {
        this.isDefault = isDefault;
    }

    public void setDefaultForPHPVersion(PHPexes phpexes, PHPVersion phpVersion) {
        phpexes.setItemDefaultForPHPVersion(this, phpVersion);
    }

    void addPHPVersionToDefaultList(PHPVersion phpVersion) {
        this.defaultForPHPVersionList.add(phpVersion);
    }

    void removePHPVersionToDefaultList(PHPVersion phpVersion) {
        this.defaultForPHPVersionList.remove(phpVersion);
    }

    public int geDefaultForPHPVersionSize() {
        return this.defaultForPHPVersionList.size();
    }

    public PHPVersion getPHPVersionAtDefaultList(int index) {
        assert (this.geDefaultForPHPVersionSize() > index);
        return this.defaultForPHPVersionList.get(index);
    }

    protected void detectFromPHPExe() {
        block15: {
            if (this.executable == null) {
                throw new IllegalStateException("PHP executable path is null");
            }
            File tempPHPIni = PHPINIUtil.createTemporaryPHPINIFile();
            try {
                PHPexes.changePermissions(this.executable);
                String output = PHPexeItem.exec(this.executable.getAbsolutePath(), "-n", "-c", tempPHPIni.getParentFile().getAbsolutePath(), "-v");
                Matcher m = PHP_VERSION.matcher(output);
                if (m.find()) {
                    this.version = m.group(1);
                    String type = m.group(2);
                    if (type.startsWith("cgi")) {
                        this.sapiType = SAPI_CGI;
                    } else if (type.startsWith("cli")) {
                        this.sapiType = SAPI_CLI;
                    } else {
                        PHPDebugPlugin.logErrorMessage("Can't determine type of the PHP executable");
                        return;
                    }
                    if (this.name == null) {
                        this.name = "PHP " + this.version + " (" + this.sapiType + ")";
                    }
                } else {
                    PHPDebugPlugin.logErrorMessage("Can't determine version of the PHP executable");
                    return;
                }
                if (this.detectedConfig != null) break block15;
                output = PHPexeItem.exec(this.executable.getAbsolutePath(), "-n", "-c", tempPHPIni.getParentFile().getAbsolutePath(), "-i");
                if (this.sapiType == SAPI_CLI) {
                    m = PHP_CLI_CONFIG.matcher(output);
                } else if (this.sapiType == SAPI_CGI) {
                    m = PHP_CGI_CONFIG.matcher(output);
                }
                if (m.find()) {
                    String configDir = m.group(1);
                    this.detectedConfig = new File(configDir.trim(), "php.ini");
                    if (!this.detectedConfig.exists()) {
                        this.detectedConfig = null;
                    }
                    break block15;
                }
                PHPDebugPlugin.logErrorMessage("Can't determine PHP.ini location of the PHP executable");
                return;
            }
            catch (IOException e) {
                DebugPlugin.log((Throwable)e);
            }
        }
    }

    private static String exec(String ... cmd) throws IOException {
        String l;
        String[] envParams = null;
        String env = PHPLaunchUtilities.getLibrarySearchPathEnv(new File(cmd[0]).getParentFile());
        if (env != null) {
            envParams = new String[]{env};
        }
        Process p = Runtime.getRuntime().exec(cmd, envParams);
        BufferedReader r = new BufferedReader(new InputStreamReader(p.getInputStream()));
        StringBuilder buf = new StringBuilder();
        while ((l = r.readLine()) != null) {
            buf.append(l).append('\n');
        }
        return buf.toString();
    }

    public boolean execPhpScript(IProject project, String scriptFile) {
        boolean status = false;
        if (this.executable == null) {
            throw new IllegalStateException("PHP executable path is null");
        }
        File tempPHPIni = PHPINIUtil.createPhpIniByProject(this.getDetectedINILocation(), project);
        try {
            PHPexes.changePermissions(this.executable);
            PHPexeItem.exec(this.executable.getAbsolutePath(), "-n", "-c", tempPHPIni.getParentFile().getAbsolutePath(), "-v", scriptFile);
        }
        catch (IOException e) {
            DebugPlugin.log((Throwable)e);
            status = false;
        }
        return status;
    }
}

