/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.zend.model;

import java.util.ArrayList;
import org.eclipse.core.runtime.jobs.ILock;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.php.internal.debug.core.pathmapper.VirtualPath;
import org.eclipse.php.internal.debug.core.zend.debugger.DefaultExpression;
import org.eclipse.php.internal.debug.core.zend.debugger.DefaultExpressionsManager;
import org.eclipse.php.internal.debug.core.zend.debugger.Expression;
import org.eclipse.php.internal.debug.core.zend.debugger.IRemoteDebugger;
import org.eclipse.php.internal.debug.core.zend.debugger.PHPstack;
import org.eclipse.php.internal.debug.core.zend.debugger.RemoteDebugger;
import org.eclipse.php.internal.debug.core.zend.debugger.StackLayer;
import org.eclipse.php.internal.debug.core.zend.model.PHPDebugTarget;
import org.eclipse.php.internal.debug.core.zend.model.PHPStackFrame;
import org.eclipse.php.internal.debug.core.zend.model.PHPThread;
import org.eclipse.php.internal.debug.core.zend.model.PHPVariable;
import org.eclipse.php.internal.debug.core.zend.model.ResolveBlackList;

public class ContextManager {
    private PHPDebugTarget fTarget;
    private IRemoteDebugger fDebugger;
    private IStackFrame[] fFrames;
    private ILock fFramesInitLock = Job.getJobManager().newLock();
    private int fSuspendCount;
    private static final String DUMMY_PHP_FILE = "dummy.php";
    private static final String THIS_VARIABLE = "$this";

    public ContextManager(PHPDebugTarget target, IRemoteDebugger debugger) {
        this.fTarget = target;
        this.fSuspendCount = target.getSuspendCount();
        this.fDebugger = debugger;
    }

    public void addToResolveBlacklist(VirtualPath path, ResolveBlackList.Type type) {
        ResolveBlackList.getInstance().add(this.fDebugger.getDebugHandler().getDebugTarget().getLaunch(), path, type);
    }

    public boolean isResolveBlacklisted(String remoteFile) {
        return ResolveBlackList.getInstance().containsEntry(this.fDebugger.getDebugHandler().getDebugTarget().getLaunch(), remoteFile);
    }

    private void copyVariablesFromPreviousFrames(IStackFrame[] frames) {
        if (this.fFrames != null) {
            int i = frames.length - 1;
            int c = this.fFrames.length - 1;
            while (i > 0 && c >= 0) {
                ((PHPStackFrame)frames[i]).setStackVariables(((PHPStackFrame)this.fFrames[c]).getStackVariables());
                --i;
                --c;
            }
        }
    }

    public IStackFrame[] getStackFrames() throws DebugException {
        this.fFramesInitLock.acquire();
        try {
            if (this.fSuspendCount == this.fTarget.getSuspendCount()) {
                IStackFrame[] iStackFrameArray = this.fFrames;
                return iStackFrameArray;
            }
            PHPstack stack = this.fDebugger.getCallStack();
            StackLayer[] layers = stack.getLayers();
            if (layers.length == 1 && layers[0].getCalledFileName().endsWith(DUMMY_PHP_FILE)) {
                this.fDebugger.finish();
                IStackFrame[] iStackFrameArray = this.fFrames;
                return iStackFrameArray;
            }
            PHPThread thread = (PHPThread)this.fTarget.getThreads()[0];
            IStackFrame[] newFrames = this.applyDebugFilters(this.createNewFrames(layers, thread));
            this.copyVariablesFromPreviousFrames(newFrames);
            this.fFrames = newFrames;
            this.fSuspendCount = this.fTarget.getSuspendCount();
            IStackFrame[] iStackFrameArray = this.fFrames;
            return iStackFrameArray;
        }
        finally {
            this.fFramesInitLock.release();
        }
    }

    private IStackFrame[] applyDebugFilters(IStackFrame[] previousFrames) {
        ArrayList<IStackFrame> tempStackFrames = new ArrayList<IStackFrame>();
        int i = 0;
        while (i < previousFrames.length) {
            String stackFrameName;
            if (i != previousFrames.length - 1 || !(stackFrameName = ((PHPStackFrame)previousFrames[i]).getAbsoluteFileName()).endsWith(DUMMY_PHP_FILE)) {
                tempStackFrames.add(previousFrames[i]);
            }
            ++i;
        }
        IStackFrame[] result = new IStackFrame[tempStackFrames.size()];
        tempStackFrames.toArray(result);
        return result;
    }

    public IVariable[] getVariables(PHPStackFrame stackFrame) {
        if (stackFrame == null) {
            return this.createVariables();
        }
        IVariable[] variables = null;
        try {
            variables = stackFrame.getVariables();
        }
        catch (DebugException debugException) {}
        return variables == null ? new IVariable[]{} : variables;
    }

    private IStackFrame[] createNewFrames(StackLayer[] layers, PHPThread thread) throws DebugException {
        RemoteDebugger remoteDebugger = (RemoteDebugger)this.fDebugger;
        String cwd = null;
        String currentScript = null;
        IStackFrame[] frames = new IStackFrame[layers.length];
        int frameCt = layers.length;
        int i = 1;
        while (i < layers.length) {
            String sName = layers[i].getCallerFileName();
            String rName = layers[i].getResolvedCallerFileName();
            if (rName == null) {
                rName = remoteDebugger.convertToLocalFilename(sName, cwd, frameCt < frames.length ? ((PHPStackFrame)frames[frameCt]).getSourceName() : null);
                if (rName == null) {
                    rName = sName;
                }
                layers[i].setResolvedCallerFileName(rName);
            }
            frames[frameCt - 1] = new PHPStackFrame(thread, sName, rName, layers[i].getCallerFunctionName(), layers[i].getCallerLineNumber() + 1, layers[i].getDepth(), layers[i - 1].getVariables());
            --frameCt;
            if (!layers[i].getCalledFileName().equals(this.fTarget.getLastFileName())) {
                currentScript = rName;
            }
            ++i;
        }
        String resolvedFile = remoteDebugger.convertToLocalFilename(this.fTarget.getLastFileName(), cwd, currentScript);
        if (resolvedFile == null) {
            resolvedFile = this.fTarget.getLastFileName();
        }
        frames[0] = new PHPStackFrame(thread, this.fTarget.getLastFileName(), resolvedFile, layers.length == 1 ? "" : frames[1].getName(), this.fTarget.getLastStop(), frameCt, this.getLocalVariables());
        return frames;
    }

    private Expression[] getLocalVariables() {
        DefaultExpressionsManager expressionsManager = this.fTarget.getExpressionManager();
        if (expressionsManager == null) {
            return new Expression[0];
        }
        expressionsManager.update(new DefaultExpression(THIS_VARIABLE), 1);
        return expressionsManager.getLocalVariables(1);
    }

    private IVariable[] createVariables() {
        Expression[] localVariables = this.getLocalVariables();
        IVariable[] variables = new PHPVariable[localVariables.length];
        int i = 0;
        while (i < localVariables.length) {
            variables[i] = new PHPVariable(this.fTarget, localVariables[i]);
            ++i;
        }
        return variables;
    }

    public IRemoteDebugger getRemoteDebugger() {
        return this.fDebugger;
    }
}

