/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.preferences;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;
import org.eclipse.php.internal.debug.core.preferences.PHPDebugCorePreferenceNames;

public class PHPProjectPreferences {
    public static String getPreferenceNodeQualifier() {
        return "org.eclipse.php.debug.core.Debug_Process_Preferences";
    }

    public static Preferences getModelPreferences() {
        return PHPDebugPlugin.getDefault().getPluginPreferences();
    }

    public static IScopeContext getProjectScope(IProject project) {
        return new ProjectScope(project);
    }

    public static boolean getElementSettingsForProject(IProject project) {
        IScopeContext pScope = PHPProjectPreferences.getProjectScope(project);
        return pScope.getNode(PHPProjectPreferences.getPreferenceNodeQualifier()).getBoolean(PHPProjectPreferences.getProjectSettingsKey(), false);
    }

    public static String getProjectSettingsKey() {
        return "org.eclipse.php.debug.core.use-project-settings";
    }

    public static boolean getStopAtFirstLine(IProject project) {
        Preferences prefs = PHPProjectPreferences.getModelPreferences();
        boolean stop = prefs.getBoolean(PHPDebugCorePreferenceNames.STOP_AT_FIRST_LINE);
        if (project != null && PHPProjectPreferences.getElementSettingsForProject(project)) {
            IScopeContext projectScope = PHPProjectPreferences.getProjectScope(project);
            stop = projectScope.getNode(PHPProjectPreferences.getPreferenceNodeQualifier()).getBoolean(PHPDebugCorePreferenceNames.STOP_AT_FIRST_LINE, stop);
        }
        return stop;
    }

    public static boolean isEnableCLIDebug(IProject project) {
        Preferences prefs = PHPProjectPreferences.getModelPreferences();
        boolean enableCLIDebug = prefs.getBoolean(PHPDebugCorePreferenceNames.ENABLE_CLI_DEBUG);
        if (project != null && PHPProjectPreferences.getElementSettingsForProject(project)) {
            IScopeContext projectScope = PHPProjectPreferences.getProjectScope(project);
            enableCLIDebug = projectScope.getNode(PHPProjectPreferences.getPreferenceNodeQualifier()).getBoolean(PHPDebugCorePreferenceNames.ENABLE_CLI_DEBUG, enableCLIDebug);
        }
        return enableCLIDebug;
    }

    public static String getDefaultBasePath(IProject project) {
        String basePath = null;
        if (project != null && PHPProjectPreferences.getElementSettingsForProject(project)) {
            IScopeContext projectScope = PHPProjectPreferences.getProjectScope(project);
            basePath = projectScope.getNode(PHPProjectPreferences.getPreferenceNodeQualifier()).get("DefaultProjectBasePath", basePath);
        }
        if (project != null && basePath == null) {
            return "/" + project.getName();
        }
        return basePath;
    }

    public static void setDefaultBasePath(IProject project, String value) {
        Preferences prefs = PHPProjectPreferences.getModelPreferences();
        prefs.setValue("DefaultProjectBasePath", value);
        if (project != null && PHPProjectPreferences.getElementSettingsForProject(project)) {
            IScopeContext projectScope = PHPProjectPreferences.getProjectScope(project);
            projectScope.getNode(PHPProjectPreferences.getPreferenceNodeQualifier()).put("DefaultProjectBasePath", value);
        }
    }

    public static String getDefaultServerName(IProject project) {
        Preferences prefs = PHPProjectPreferences.getModelPreferences();
        String serverName = prefs.getString("defaultPHPServer");
        if (project != null && PHPProjectPreferences.getElementSettingsForProject(project)) {
            IScopeContext projectScope = PHPProjectPreferences.getProjectScope(project);
            serverName = projectScope.getNode(PHPProjectPreferences.getPreferenceNodeQualifier()).get("defaultPHPServer", serverName);
        }
        return serverName;
    }

    public static String getDefaultDebuggerID(IProject project) {
        Preferences prefs = PHPProjectPreferences.getModelPreferences();
        String debuggerID = prefs.getString(PHPDebugCorePreferenceNames.PHP_DEBUGGER_ID);
        if (project != null && PHPProjectPreferences.getElementSettingsForProject(project)) {
            IScopeContext projectScope = PHPProjectPreferences.getProjectScope(project);
            debuggerID = projectScope.getNode(PHPProjectPreferences.getPreferenceNodeQualifier()).get(PHPDebugCorePreferenceNames.PHP_DEBUGGER_ID, debuggerID);
        }
        return debuggerID;
    }

    public static String getTransferEncoding(IProject project) {
        Preferences prefs = PHPProjectPreferences.getModelPreferences();
        String encoding = prefs.getString(PHPDebugCorePreferenceNames.TRANSFER_ENCODING);
        if (project != null && PHPProjectPreferences.getElementSettingsForProject(project)) {
            IScopeContext projectScope = PHPProjectPreferences.getProjectScope(project);
            encoding = projectScope.getNode(PHPProjectPreferences.getPreferenceNodeQualifier()).get(PHPDebugCorePreferenceNames.TRANSFER_ENCODING, encoding);
        }
        return encoding;
    }

    public static String getOutputEncoding(IProject project) {
        Preferences prefs = PHPProjectPreferences.getModelPreferences();
        String encoding = prefs.getString(PHPDebugCorePreferenceNames.OUTPUT_ENCODING);
        if (project != null && PHPProjectPreferences.getElementSettingsForProject(project)) {
            IScopeContext projectScope = PHPProjectPreferences.getProjectScope(project);
            encoding = projectScope.getNode(PHPProjectPreferences.getPreferenceNodeQualifier()).get(PHPDebugCorePreferenceNames.OUTPUT_ENCODING, encoding);
        }
        return encoding;
    }
}

