/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.preferences;

import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;
import org.eclipse.php.internal.debug.core.preferences.PHPDebugCorePreferenceNames;
import org.eclipse.php.internal.debug.core.preferences.PHPDebuggersRegistry;
import org.eclipse.php.internal.debug.core.preferences.PHPProjectPreferences;
import org.eclipse.php.internal.debug.core.preferences.PHPexeItem;
import org.eclipse.php.internal.debug.core.preferences.PHPexes;
import org.eclipse.php.internal.debug.ui.Logger;
import org.eclipse.php.internal.debug.ui.PHPDebugUIMessages;
import org.eclipse.php.internal.debug.ui.preferences.BasePathValidator;
import org.eclipse.php.internal.debug.ui.preferences.ControlValidationException;
import org.eclipse.php.internal.debug.ui.preferences.IPageValidator;
import org.eclipse.php.internal.server.core.Server;
import org.eclipse.php.internal.server.core.manager.ServersManager;
import org.eclipse.php.internal.ui.preferences.AbstractPHPPreferencePageBlock;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.ide.IDEEncoding;
import org.osgi.service.prefs.BackingStoreException;

public class PHPDebugPreferencesBlock
extends AbstractPHPPreferencePageBlock {
    private static final String UNRESOLVED_PHP_VERSION = "Unresolved PHP Version";
    private static final String DEBUGGERS_PAGE_ID = "org.eclipse.php.debug.ui.installedDebuggersPage";
    private static final String SERVERS_PAGE_ID = "org.eclipse.php.server.internal.ui.PHPServersPreferencePage";
    private static final String PHP_EXE_PAGE_ID = "org.eclipse.php.debug.ui.preferencesphps.PHPsPreferencePage";
    private Button fStopAtFirstLine;
    private Combo fDefaultDebugger;
    private Combo fDefaultServer;
    private Combo fDefaultPHPExe;
    private Collection<String> debuggersIds;
    private Combo fDebugEncodingSettings;
    private Combo fOutputEncodingSettings;
    private PreferencePage propertyPage;
    private URL autoGeneratedURL;
    private Text fAutoGeneratedURLText;
    private Text fDefaultBasePath;
    private final boolean isPropertyPage;
    private String defaultBasePath;
    private IPageValidator pageValidator = null;

    public boolean isPropertyPage() {
        return this.isPropertyPage;
    }

    public PHPDebugPreferencesBlock(boolean isPropertyPage) {
        this.isPropertyPage = !isPropertyPage;
    }

    public void setCompositeAddon(Composite parent) {
        Composite composite = this.addPageContents(parent);
        this.addProjectPreferenceSubsection(composite);
    }

    public void initializeValues(PreferencePage propertyPage) {
        IEclipsePreferences node;
        this.propertyPage = propertyPage;
        Preferences prefs = PHPProjectPreferences.getModelPreferences();
        IScopeContext[] preferenceScopes = this.createPreferenceScopes(propertyPage);
        boolean stopAtFirstLine = prefs.getBoolean(PHPDebugCorePreferenceNames.STOP_AT_FIRST_LINE);
        String debuggerName = PHPDebuggersRegistry.getDebuggerName((String)prefs.getString(PHPDebugCorePreferenceNames.PHP_DEBUGGER_ID));
        String serverName = ServersManager.getDefaultServer(null).getName();
        PHPexes exes = PHPexes.getInstance();
        String phpExeName = PHPDebugUIMessages.PhpDebugPreferencePage_noExeDefined;
        IProject project = this.getProject(propertyPage);
        PHPexeItem item = PHPDebugPlugin.getPHPexeItem((IProject)project);
        if (item != null && item.getName() != null) {
            phpExeName = item.getName();
        }
        String transferEncoding = prefs.getString(PHPDebugCorePreferenceNames.TRANSFER_ENCODING);
        String outputEncoding = prefs.getString(PHPDebugCorePreferenceNames.OUTPUT_ENCODING);
        this.loadDebuggers(this.fDefaultDebugger);
        this.loadServers(this.fDefaultServer);
        boolean exeLoaded = false;
        if (preferenceScopes[0] instanceof ProjectScope && (node = preferenceScopes[0].getNode(this.getPreferenceNodeQualifier())) != null && project != null) {
            String projectServerName;
            if (this.getBasePathValue(project) == null || this.getBasePathValue(project) == "") {
                this.setBasePathValue(project, project.getName());
            }
            if (!(projectServerName = ServersManager.getDefaultServer((IProject)project).getName()).equals("")) {
                String debuggerId = item != null ? item.getDebuggerID() : PHPDebugPlugin.getCurrentDebuggerId();
                debuggerName = PHPDebuggersRegistry.getDebuggerName((String)debuggerId);
                serverName = projectServerName;
                stopAtFirstLine = node.getBoolean(PHPDebugCorePreferenceNames.STOP_AT_FIRST_LINE, stopAtFirstLine);
                transferEncoding = node.get(PHPDebugCorePreferenceNames.TRANSFER_ENCODING, transferEncoding);
                outputEncoding = node.get(PHPDebugCorePreferenceNames.OUTPUT_ENCODING, outputEncoding);
                if (PHPDebugUIMessages.PhpDebugPreferencePage_noExeDefined.equals(phpExeName) && exes.hasItems(debuggerId)) {
                    phpExeName = exes.getDefaultItem(debuggerId).getName();
                    node.put(PHPDebugCorePreferenceNames.DEFAULT_PHP, phpExeName);
                    try {
                        node.flush();
                    }
                    catch (BackingStoreException backingStoreException) {}
                }
                this.loadPHPExes(this.fDefaultPHPExe, exes.getItems(node.get(PHPDebugCorePreferenceNames.PHP_DEBUGGER_ID, debuggerId)));
                exeLoaded = true;
            }
        }
        if (!exeLoaded) {
            this.loadPHPExes(this.fDefaultPHPExe, exes.getItems(PHPDebugPlugin.getCurrentDebuggerId()));
        }
        this.fStopAtFirstLine.setSelection(stopAtFirstLine);
        this.fDefaultDebugger.select(this.fDefaultDebugger.indexOf(debuggerName));
        this.fDefaultServer.select(this.fDefaultServer.indexOf(serverName));
        this.fDefaultPHPExe.select(this.fDefaultPHPExe.indexOf(phpExeName));
        this.fDebugEncodingSettings.setText(transferEncoding);
        this.fOutputEncodingSettings.setText(outputEncoding);
        if (this.isPropertyPage()) {
            this.defaultBasePath = this.getBasePathValue(project);
            this.initAutoGenerateListener();
            this.fDefaultBasePath.setText(this.defaultBasePath);
        }
    }

    private String getBasePathValue(IProject project) {
        String basepath = PHPProjectPreferences.getDefaultBasePath((IProject)project);
        return basepath;
    }

    private void setBasePathValue(IProject project, String value) {
        PHPProjectPreferences.setDefaultBasePath((IProject)project, (String)value);
    }

    public void initAutoGenerateListener() {
        this.fDefaultBasePath.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                try {
                    try {
                        if (PHPDebugPreferencesBlock.this.pageValidator != null) {
                            PHPDebugPreferencesBlock.this.pageValidator.validate(new BasePathValidator(PHPDebugPreferencesBlock.this.fDefaultBasePath));
                        }
                        PHPDebugPreferencesBlock.this.refreshAutoGeneratedBaseURLDisplay();
                    }
                    catch (ControlValidationException e1) {
                        e1.printStackTrace();
                    }
                }
                catch (MalformedURLException e1) {
                    e1.printStackTrace();
                }
            }
        });
    }

    private String getSelectedServerName() {
        return this.fDefaultServer.getText();
    }

    private void dispalyAutoGeneratedURL(URL url) {
        this.fAutoGeneratedURLText.setText(url.toString());
    }

    public boolean performOK(boolean isProjectSpecific) {
        this.savePreferences(isProjectSpecific);
        return true;
    }

    public void performApply(boolean isProjectSpecific) {
        this.performOK(isProjectSpecific);
    }

    public boolean performCancel() {
        return true;
    }

    public void performDefaults() {
        Preferences prefs = PHPProjectPreferences.getModelPreferences();
        this.fStopAtFirstLine.setSelection(prefs.getDefaultBoolean(PHPDebugCorePreferenceNames.STOP_AT_FIRST_LINE));
        this.loadDebuggers(this.fDefaultDebugger);
        this.loadServers(this.fDefaultServer);
        this.loadPHPExes(this.fDefaultPHPExe, PHPexes.getInstance().getItems("org.eclipse.php.debug.core.zendDebugger"));
        this.fDebugEncodingSettings.setText(prefs.getDefaultString(PHPDebugCorePreferenceNames.TRANSFER_ENCODING));
        this.fOutputEncodingSettings.setText(prefs.getDefaultString(PHPDebugCorePreferenceNames.OUTPUT_ENCODING));
    }

    protected String getPreferenceNodeQualifier() {
        return PHPProjectPreferences.getPreferenceNodeQualifier();
    }

    private void addProjectPreferenceSubsection(Composite composite) {
        Group defultPrefsGroup = new Group(composite, 0);
        defultPrefsGroup.setText(PHPDebugUIMessages.PHPDebugPreferencesBlock_0);
        defultPrefsGroup.setFont(composite.getFont());
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.verticalSpacing = 10;
        defultPrefsGroup.setLayout((Layout)layout);
        defultPrefsGroup.setLayoutData((Object)new GridData(1808));
        this.addLabelControl((Composite)defultPrefsGroup, PHPDebugUIMessages.PhpDebugPreferencePage_phpDebugger, PHPDebugCorePreferenceNames.PHP_DEBUGGER_ID);
        this.fDefaultDebugger = this.addCombo((Composite)defultPrefsGroup, 2);
        this.addLink((Composite)defultPrefsGroup, PHPDebugUIMessages.PHPDebugPreferencesBlock_1, DEBUGGERS_PAGE_ID);
        this.addLabelControl((Composite)defultPrefsGroup, PHPDebugUIMessages.PhpDebugPreferencePage_9, "defaultPHPServer");
        this.fDefaultServer = this.addCombo((Composite)defultPrefsGroup, 2);
        this.addLink((Composite)defultPrefsGroup, PHPDebugUIMessages.PhpDebugPreferencePage_serversLink, SERVERS_PAGE_ID);
        this.addLabelControl((Composite)defultPrefsGroup, PHPDebugUIMessages.PhpDebugPreferencePage_12, PHPDebugCorePreferenceNames.DEFAULT_PHP);
        this.fDefaultPHPExe = this.addCombo((Composite)defultPrefsGroup, 2);
        this.addLink((Composite)defultPrefsGroup, PHPDebugUIMessages.PhpDebugPreferencePage_installedPHPsLink, PHP_EXE_PAGE_ID);
        new Label(composite, 0);
        Group encodingGroup = new Group(composite, 0);
        encodingGroup.setText(PHPDebugUIMessages.PHPDebugPreferencesBlock_2);
        encodingGroup.setLayout((Layout)new GridLayout(2, false));
        encodingGroup.setLayoutData((Object)new GridData(1808));
        this.addLabelControl((Composite)encodingGroup, PHPDebugUIMessages.PHPDebugPreferencesAddon_debugTransferEncoding, PHPDebugCorePreferenceNames.TRANSFER_ENCODING);
        this.fDebugEncodingSettings = this.addEncodingSettings((Composite)encodingGroup);
        this.addLabelControl((Composite)encodingGroup, PHPDebugUIMessages.PHPDebugPreferencesAddon_debugOutputEncoding, PHPDebugCorePreferenceNames.OUTPUT_ENCODING);
        this.fOutputEncodingSettings = this.addEncodingSettings((Composite)encodingGroup);
        ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                boolean isValid = PHPDebugPreferencesBlock.this.isValidEncoding(((Combo)e.getSource()).getText());
                if (isValid) {
                    PHPDebugPreferencesBlock.this.propertyPage.setErrorMessage(null);
                } else {
                    PHPDebugPreferencesBlock.this.propertyPage.setErrorMessage(PHPDebugUIMessages.PHPDebugPreferencesAddon_unsupportedEncoding);
                }
                PHPDebugPreferencesBlock.this.propertyPage.setValid(isValid);
            }
        };
        this.fDebugEncodingSettings.addModifyListener(modifyListener);
        this.fOutputEncodingSettings.addModifyListener(modifyListener);
        new Label(composite, 0);
        if (this.isPropertyPage()) {
            this.createBaseURLGroup(composite);
        }
        new Label(composite, 0);
        this.fStopAtFirstLine = this.addCheckBox(composite, PHPDebugUIMessages.PhpDebugPreferencePage_1, PHPDebugCorePreferenceNames.STOP_AT_FIRST_LINE, 0);
        this.fDefaultDebugger.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String selectedDebugger = PHPDebugPreferencesBlock.this.getSelectedDebuggerId();
                PHPexeItem[] items = PHPexes.getInstance().getItems(selectedDebugger);
                PHPDebugPreferencesBlock.this.loadPHPExes(PHPDebugPreferencesBlock.this.fDefaultPHPExe, items);
            }
        });
        this.fDefaultServer.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    PHPDebugPreferencesBlock.this.refreshAutoGeneratedBaseURLDisplay();
                }
                catch (MalformedURLException malformedURLException) {}
            }
        });
    }

    private void createBaseURLGroup(Composite composite) {
        Group baseURLGroup = this.createGroup(composite, "Default Base URL");
        this.addBasePathLabelAndText(baseURLGroup);
        this.addBaseURLLabelAndText(baseURLGroup);
    }

    private void addBaseURLLabelAndText(Group baseURLGroup) {
        this.addLabelControl((Composite)baseURLGroup, "Auto-generated Base URL", PHPDebugCorePreferenceNames.TRANSFER_ENCODING);
        this.addBaseURLText((Composite)baseURLGroup);
    }

    private URL generateBaseURL(Server server, IPath basePath) throws MalformedURLException {
        Path path = new Path(server.getRootURL().toString());
        URL generatedBaseURL = new URL(path.append(basePath).toString());
        return generatedBaseURL;
    }

    private Text addBaseURLText(Composite parent) {
        this.fAutoGeneratedURLText = this.addText(parent, 2, 24);
        return this.fAutoGeneratedURLText;
    }

    private void addBasePathLabelAndText(Group baseURLGroup) {
        this.addLabelControl((Composite)baseURLGroup, "Base Path: ", PHPDebugCorePreferenceNames.TRANSFER_ENCODING);
        this.addBasePathText((Composite)baseURLGroup);
    }

    private Text addBasePathText(Composite parent) {
        this.fDefaultBasePath = this.addText(parent, 2, 2064);
        return this.fDefaultBasePath;
    }

    private IPath getDefaultBasePath() {
        if (this.fDefaultBasePath != null) {
            return new Path(this.fDefaultBasePath.getText());
        }
        return null;
    }

    private Server getDefaultServer() {
        return ServersManager.getServer((String)this.fDefaultServer.getText());
    }

    private void displayDefaultBaseURL(URL generatedBaseURL) {
        this.fAutoGeneratedURLText.setText(generatedBaseURL.toString());
    }

    private Group createGroup(Composite composite, String groupName) {
        Group newGroup = new Group(composite, 0);
        newGroup.setText(groupName);
        newGroup.setLayout((Layout)new GridLayout(2, false));
        newGroup.setLayoutData((Object)new GridData(1808));
        return newGroup;
    }

    private void loadPHPExes(Combo combo, PHPexeItem[] items) {
        combo.removeAll();
        if (items == null || items.length == 0) {
            combo.add(PHPDebugUIMessages.PhpDebugPreferencePage_noExeDefined);
            combo.select(0);
            return;
        }
        PHPexeItem[] pHPexeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            PHPexeItem element = pHPexeItemArray[n2];
            String name = element.getName();
            if (name == null) {
                name = UNRESOLVED_PHP_VERSION;
            }
            combo.add(name);
            ++n2;
        }
        if (this.fDefaultDebugger.getItemCount() > 0) {
            int index;
            String defaultItemName;
            PHPexeItem defaultItem = PHPexes.getInstance().getDefaultItem(this.getSelectedDebuggerId());
            if (defaultItem != null) {
                defaultItemName = defaultItem.getName();
                if (defaultItemName == null) {
                    defaultItemName = UNRESOLVED_PHP_VERSION;
                }
            } else {
                defaultItemName = PHPDebugUIMessages.PHPDebuggersTable_notDefined;
                if (combo.indexOf(defaultItemName) == -1) {
                    combo.add(defaultItemName, 0);
                    combo.select(0);
                }
            }
            if ((index = combo.indexOf(defaultItemName)) > -1) {
                combo.select(index);
            } else if (combo.getItemCount() > 0) {
                combo.select(0);
            }
        }
    }

    private void loadServers(Combo combo) {
        combo.removeAll();
        Server[] servers = ServersManager.getServers();
        if (servers != null) {
            Server[] serverArray = servers;
            int n = servers.length;
            int n2 = 0;
            while (n2 < n) {
                Server element = serverArray[n2];
                combo.add(element.getName());
                ++n2;
            }
            if (combo.getItemCount() > 0) {
                combo.select(0);
            }
        }
    }

    private void loadDebuggers(Combo combo) {
        this.debuggersIds = PHPDebuggersRegistry.getDebuggersIds();
        String defaultDebuggerID = "org.eclipse.php.debug.core.zendDebugger";
        combo.removeAll();
        Iterator<String> debuggers = this.debuggersIds.iterator();
        int defaultIndex = 0;
        int index = 0;
        while (debuggers.hasNext()) {
            String id = debuggers.next();
            if (defaultDebuggerID.equals(id)) {
                defaultIndex = index;
            } else {
                ++index;
            }
            String debuggerName = PHPDebuggersRegistry.getDebuggerName((String)id);
            combo.add(debuggerName);
        }
        if (combo.getItemCount() > 0) {
            combo.select(defaultIndex);
        }
    }

    private void addLink(Composite parent, String label, final String propertyPageID) {
        Link link = new Link(parent, 0);
        link.setFont(parent.getFont());
        link.setLayoutData((Object)new GridData(0x1000008, 1, true, false));
        link.setText(label);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn((Shell)PHPDebugPreferencesBlock.this.propertyPage.getShell(), (String)propertyPageID, null, null);
                dialog.setBlockOnOpen(true);
                dialog.addPageChangedListener(new IPageChangedListener(){

                    public void pageChanged(PageChangedEvent event) {
                        Display.getDefault().asyncExec(new Runnable(){

                            public void run() {
                                String selectedDebugger = PHPDebugPreferencesBlock.this.fDefaultDebugger.getText();
                                String selectedServer = PHPDebugPreferencesBlock.this.fDefaultServer.getText();
                                String selectedPHP = PHPDebugPreferencesBlock.this.fDefaultPHPExe.getText();
                                PHPDebugPreferencesBlock.this.loadDebuggers(PHPDebugPreferencesBlock.this.fDefaultDebugger);
                                PHPDebugPreferencesBlock.this.loadServers(PHPDebugPreferencesBlock.this.fDefaultServer);
                                PHPDebugPreferencesBlock.this.loadPHPExes(PHPDebugPreferencesBlock.this.fDefaultPHPExe, PHPexes.getInstance().getItems(PHPDebugPreferencesBlock.this.getSelectedDebuggerId()));
                                PHPDebugPreferencesBlock.this.selectComboItem(PHPDebugPreferencesBlock.this.fDefaultDebugger, PHPDebugPreferencesBlock.this.fDefaultDebugger.indexOf(selectedDebugger));
                                PHPDebugPreferencesBlock.this.selectComboItem(PHPDebugPreferencesBlock.this.fDefaultServer, PHPDebugPreferencesBlock.this.fDefaultServer.indexOf(selectedServer));
                                PHPDebugPreferencesBlock.this.selectComboItem(PHPDebugPreferencesBlock.this.fDefaultPHPExe, PHPDebugPreferencesBlock.this.fDefaultPHPExe.indexOf(selectedPHP));
                            }
                        });
                    }
                });
                dialog.open();
            }
        });
    }

    private void selectComboItem(Combo combo, int itemIndex) {
        if (itemIndex < 0) {
            if (combo.getItemCount() > 0) {
                combo.select(0);
            }
        } else {
            combo.select(itemIndex);
        }
    }

    private Combo addEncodingSettings(Composite parent) {
        Combo encodingCombo = new Combo(parent, 0);
        GridData data = new GridData();
        encodingCombo.setLayoutData((Object)data);
        List encodings = IDEEncoding.getIDEEncodings();
        String[] encodingStrings = new String[encodings.size()];
        encodings.toArray(encodingStrings);
        encodingCombo.setItems(encodingStrings);
        return encodingCombo;
    }

    private Combo addCombo(Composite parent, int horizontalIndent) {
        Combo combo = new Combo(parent, 2060);
        GridData gd = new GridData(768);
        gd.horizontalIndent = horizontalIndent;
        combo.setLayoutData((Object)gd);
        return combo;
    }

    private Text addText(Composite parent, int horizontalIndent, int style) {
        Text text = new Text(parent, style);
        GridData gd = new GridData(768);
        gd.horizontalIndent = horizontalIndent;
        text.setLayoutData((Object)gd);
        return text;
    }

    private void savePreferences(boolean isProjectSpecific) {
        String phpExe = this.fDefaultPHPExe.getText();
        PHPexes exes = PHPexes.getInstance();
        if (exes.getItem(this.getSelectedDebuggerId(), phpExe) == null) {
            PHPexeItem item = exes.getDefaultItem(this.getSelectedDebuggerId());
            phpExe = item != null ? item.getName() : "";
        }
        Preferences prefs = PHPProjectPreferences.getModelPreferences();
        IScopeContext[] preferenceScopes = this.createPreferenceScopes(this.propertyPage);
        IEclipsePreferences debugUINode = preferenceScopes[0].getNode(this.getPreferenceNodeQualifier());
        IProject project = this.getProject(this.propertyPage);
        if (isProjectSpecific && debugUINode != null && preferenceScopes[0] instanceof ProjectScope && project != null) {
            debugUINode.putBoolean(PHPDebugCorePreferenceNames.STOP_AT_FIRST_LINE, this.fStopAtFirstLine.getSelection());
            debugUINode.put(PHPDebugCorePreferenceNames.DEFAULT_PHP, phpExe);
            debugUINode.put(PHPDebugCorePreferenceNames.TRANSFER_ENCODING, this.fDebugEncodingSettings.getText());
            debugUINode.put(PHPDebugCorePreferenceNames.OUTPUT_ENCODING, this.fOutputEncodingSettings.getText());
            debugUINode.put(PHPDebugCorePreferenceNames.PHP_DEBUGGER_ID, this.getSelectedDebuggerId());
            ServersManager.setDefaultServer((IProject)project, (String)this.fDefaultServer.getText());
            ServersManager.getServer((String)this.fDefaultServer.getText());
            this.setBasePathValue(project, this.fDefaultBasePath.getText());
        } else if (project == null) {
            prefs.setValue(PHPDebugCorePreferenceNames.STOP_AT_FIRST_LINE, this.fStopAtFirstLine.getSelection());
            prefs.setValue(PHPDebugCorePreferenceNames.TRANSFER_ENCODING, this.fDebugEncodingSettings.getText());
            prefs.setValue(PHPDebugCorePreferenceNames.OUTPUT_ENCODING, this.fOutputEncodingSettings.getText());
            prefs.setValue(PHPDebugCorePreferenceNames.PHP_DEBUGGER_ID, this.getSelectedDebuggerId());
            exes.setDefaultItem(this.getSelectedDebuggerId(), phpExe);
        } else if (debugUINode != null) {
            debugUINode.remove(PHPDebugCorePreferenceNames.STOP_AT_FIRST_LINE);
            debugUINode.remove(PHPDebugCorePreferenceNames.DEFAULT_PHP);
            ServersManager.setDefaultServer((IProject)project, null);
            debugUINode.remove(PHPDebugCorePreferenceNames.TRANSFER_ENCODING);
            debugUINode.remove(PHPDebugCorePreferenceNames.OUTPUT_ENCODING);
            debugUINode.remove(PHPDebugCorePreferenceNames.PHP_DEBUGGER_ID);
            prefs.setValue("DefaultProjectBasePath", this.defaultBasePath);
        }
        try {
            debugUINode.flush();
            exes.save();
            PHPDebugPlugin.getDefault().savePluginPreferences();
        }
        catch (BackingStoreException e) {
            Logger.logException(e);
        }
    }

    private String getSelectedDebuggerId() {
        int selectedIndex = this.fDefaultDebugger.getSelectionIndex();
        String debuggerId = "org.eclipse.php.debug.core.zendDebugger";
        if (selectedIndex > -1 && this.debuggersIds.size() > selectedIndex) {
            debuggerId = this.debuggersIds.toArray()[selectedIndex].toString();
        }
        return debuggerId;
    }

    private boolean isValidEncoding(String enc) {
        try {
            return Charset.isSupported(enc);
        }
        catch (IllegalCharsetNameException illegalCharsetNameException) {
            return false;
        }
    }

    private void resolveAndSetBaseURL() throws MalformedURLException {
        Server server = this.getDefaultServer();
        IPath basePath = this.getDefaultBasePath();
        if (basePath != null) {
            URL baseURL = this.generateBaseURL(server, basePath);
            this.displayDefaultBaseURL(baseURL);
        }
    }

    private void refreshAutoGeneratedBaseURLDisplay() throws MalformedURLException {
        Path path = new Path(this.fDefaultBasePath.getText());
        this.defaultBasePath = this.fDefaultBasePath.getText();
        Server server = ServersManager.getServer((String)this.getSelectedServerName());
        this.autoGeneratedURL = this.generateBaseURL(server, (IPath)path);
        this.dispalyAutoGeneratedURL(this.autoGeneratedURL);
    }

    public void setValidator(IPageValidator pageValidator) {
        this.pageValidator = pageValidator;
    }
}

