/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.hovers;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.dltk.internal.ui.text.hover.AbstractScriptEditorTextHover;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.php.internal.core.Logger;
import org.eclipse.php.internal.core.documentModel.parser.regions.IPhpScriptRegion;
import org.eclipse.php.internal.debug.core.zend.debugger.DefaultExpressionsManager;
import org.eclipse.php.internal.debug.core.zend.debugger.Expression;
import org.eclipse.php.internal.debug.core.zend.model.PHPDebugTarget;
import org.eclipse.php.internal.debug.core.zend.model.PHPStackFrame;
import org.eclipse.php.internal.ui.editor.PHPStructuredTextViewer;
import org.eclipse.php.ui.editor.hover.IHoverMessageDecorator;
import org.eclipse.php.ui.editor.hover.IPHPTextHover;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionContainer;

public class PHPDebugTextHover
extends AbstractScriptEditorTextHover
implements IPHPTextHover {
    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        PHPDebugTarget debugTarget;
        if (textViewer == null || textViewer.getDocument() == null) {
            return null;
        }
        if (textViewer instanceof PHPStructuredTextViewer) {
            this.setEditor((IEditorPart)((PHPStructuredTextViewer)textViewer).getTextEditor());
        }
        if ((debugTarget = this.getDebugTarget()) == null) {
            return null;
        }
        int offset = hoverRegion.getOffset();
        IStructuredDocumentRegion flatNode = ((IStructuredDocument)textViewer.getDocument()).getRegionAtCharacterOffset(offset);
        ITextRegion region = null;
        if (flatNode != null) {
            region = flatNode.getRegionAtCharacterOffset(offset);
        }
        IStructuredDocumentRegion container = flatNode;
        if (region instanceof ITextRegionContainer) {
            container = (ITextRegionContainer)region;
            region = container.getRegionAtCharacterOffset(offset);
        }
        IPhpScriptRegion phpScriptRegion = null;
        if (region.getType() == "PHP_CONTENT") {
            phpScriptRegion = (IPhpScriptRegion)region;
            try {
                region = phpScriptRegion.getPhpToken(offset - container.getStartOffset() - region.getStart());
            }
            catch (BadLocationException badLocationException) {
                region = null;
            }
            if (region != null) {
                int varOffset = 0;
                int varLength = 0;
                String regionType = region.getType();
                if (regionType == "PHP_VARIABLE") {
                    IDocument doc = textViewer.getDocument();
                    varOffset = hoverRegion.getOffset();
                    varLength = hoverRegion.getLength();
                    try {
                        ITextRegion prevPhpToken;
                        if (doc.getChar(varOffset - 1) == ':' && doc.getChar(varOffset - 2) == ':' && phpScriptRegion != null && (prevPhpToken = phpScriptRegion.getPhpToken(varOffset - 2)) != null) {
                            varOffset = prevPhpToken.getStart() - 1;
                            varLength += prevPhpToken.getLength() + 1;
                        }
                    }
                    catch (BadLocationException e) {
                        Logger.logException((String)"Error retrieving the value\n", (Throwable)e);
                    }
                } else if (regionType == "PHP_STRING") {
                    try {
                        String nextTokenString;
                        ITextRegion nextRegion = phpScriptRegion.getPhpToken(region.getEnd());
                        ITextRegion prevRegion = phpScriptRegion.getPhpToken(region.getStart() - 1);
                        if (prevRegion.getType() == "PHP_OBJECT_OPERATOR" && (prevRegion = phpScriptRegion.getPhpToken(prevRegion.getStart() - 1)).getType() == "PHP_VARIABLE" && !"(".equals(nextTokenString = textViewer.getDocument().get(phpScriptRegion.getStart() + nextRegion.getStart(), nextRegion.getLength()))) {
                            varOffset = phpScriptRegion.getStart() + prevRegion.getStart();
                            varLength = region.getEnd() - prevRegion.getStart();
                        }
                    }
                    catch (BadLocationException e) {
                        Logger.logException((String)"Error retrieving the value\n", (Throwable)e);
                    }
                }
                if (varLength > 0) {
                    String variable = null;
                    try {
                        int[] variableRange = this.getVariableRange(textViewer, varOffset, varLength);
                        variable = textViewer.getDocument().get(variableRange[0], variableRange[1]);
                        variable = "<B>" + variable + " = </B>" + this.getValue(debugTarget, variable);
                    }
                    catch (BadLocationException e) {
                        Logger.logException((String)"Error retrieving the value\n", (Throwable)e);
                    }
                    return variable;
                }
            }
        }
        return null;
    }

    protected int[] getVariableRange(final ITextViewer textViewer, final int offset, final int length) {
        final int[] variableRange = new int[]{offset, length};
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                TextSelection selection = (TextSelection)textViewer.getSelectionProvider().getSelection();
                if (selection.isEmpty()) {
                    return;
                }
                int selectionStart = selection.getOffset();
                int selectionEnd = selectionStart + selection.getLength();
                int hoverRegionEnd = offset + length;
                if (offset >= selectionStart && offset < selectionEnd && hoverRegionEnd <= selectionEnd) {
                    variableRange[0] = selection.getOffset();
                    variableRange[1] = selection.getLength();
                }
            }
        });
        return variableRange;
    }

    protected String getValue(PHPDebugTarget debugTarget, String variable) {
        DefaultExpressionsManager expressionManager = debugTarget.getExpressionManager();
        Expression expression = expressionManager.buildExpression(variable);
        debugTarget.getExpressionManager().getExpressionValue(expression, 1);
        expressionManager.update(expression, 1);
        String value = expression.getValue().getValueAsString();
        if (value != null && value.length() == 0) {
            value = "Empty";
            return value;
        }
        if (value != null) {
            value = value.replaceAll("\t", "    ").replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;");
        }
        return value;
    }

    protected PHPDebugTarget getDebugTarget() {
        IAdaptable adaptable = DebugUITools.getDebugContext();
        if (adaptable instanceof PHPStackFrame) {
            PHPStackFrame stackFrame = (PHPStackFrame)adaptable;
            IEditorInput ei = this.getEditor().getEditorInput();
            if (ei instanceof FileEditorInput) {
                FileEditorInput fi = (FileEditorInput)ei;
                String fileInDebug = stackFrame.getSourceName();
                String fileInProject = fi.getFile().getProjectRelativePath().toString();
                if (fileInDebug != null && fileInDebug.endsWith(String.valueOf('/') + fileInProject) || fileInDebug.equals(fileInProject)) {
                    PHPDebugTarget debugTarget = (PHPDebugTarget)stackFrame.getDebugTarget();
                    return debugTarget;
                }
            } else {
                PHPDebugTarget debugTarget = (PHPDebugTarget)stackFrame.getDebugTarget();
                return debugTarget;
            }
        }
        return null;
    }

    public IHoverMessageDecorator getMessageDecorator() {
        return null;
    }
}

