/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.server.ui;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.php.internal.server.PHPServerUIMessages;
import org.eclipse.php.internal.server.core.Server;
import org.eclipse.php.internal.server.core.manager.ServersManager;
import org.eclipse.php.internal.server.ui.Logger;
import org.eclipse.php.internal.server.ui.ServersPluginImages;
import org.eclipse.php.internal.ui.wizards.CompositeFragment;
import org.eclipse.php.internal.ui.wizards.IControlHandler;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ServerCompositeFragment
extends CompositeFragment {
    protected Text name;
    protected Text url;
    protected Combo combo;
    private ValuesCache originalValuesCache = new ValuesCache();
    private ValuesCache modifiedValuesCache;

    public ServerCompositeFragment(Composite parent, IControlHandler handler, boolean isForEditing) {
        super(parent, handler, isForEditing);
        this.setDescription(PHPServerUIMessages.getString("ServerCompositeFragment.specifyInformation"));
        this.controlHandler.setDescription(this.getDescription());
        this.controlHandler.setImageDescriptor(ServersPluginImages.DESC_WIZ_SERVER);
        this.setDisplayName(PHPServerUIMessages.getString("ServerCompositeFragment.server"));
        this.createControl();
    }

    public void setData(Object server) throws IllegalArgumentException {
        if (server != null && !(server instanceof Server)) {
            throw new IllegalArgumentException("The given object is not a Server");
        }
        super.setData(server);
        this.init();
        this.validate();
    }

    public Server getServer() {
        return (Server)this.getData();
    }

    protected void createControl() {
        GridLayout layout = new GridLayout(1, true);
        this.setLayout((Layout)layout);
        this.setLayoutData(new GridData(1808));
        Composite nameGroup = new Composite((Composite)this, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        nameGroup.setLayout((Layout)layout);
        nameGroup.setLayoutData((Object)new GridData(768));
        Label label = new Label(nameGroup, 0);
        label.setText(PHPServerUIMessages.getString("ServerCompositeFragment.nameLabel"));
        GridData data = new GridData();
        label.setLayoutData((Object)data);
        this.name = new Text(nameGroup, 2048);
        data = new GridData(768);
        this.name.setLayoutData((Object)data);
        this.name.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ServerCompositeFragment.this.getServer() != null) {
                    ((ServerCompositeFragment)ServerCompositeFragment.this).modifiedValuesCache.serverName = ServerCompositeFragment.this.name.getText();
                }
                ServerCompositeFragment.this.validate();
            }
        });
        this.createURLGroup((Composite)this);
        this.init();
        this.validate();
        Dialog.applyDialogFont((Control)this);
        this.name.forceFocus();
    }

    protected void init() {
        String baseURL;
        Server server = this.getServer();
        if (this.name == null || server == null) {
            return;
        }
        this.originalValuesCache.url = server.getBaseURL();
        this.originalValuesCache.serverName = server.getName();
        this.originalValuesCache.host = server.getHost();
        this.modifiedValuesCache = new ValuesCache(this.originalValuesCache);
        if (this.originalValuesCache.serverName != null) {
            String serverName;
            boolean nameSet = false;
            String orgName = serverName = this.originalValuesCache.serverName;
            if (!this.isForEditing()) {
                int i = 0;
                while (i < 10) {
                    boolean ok = this.checkServerName(serverName);
                    if (ok) {
                        this.name.setText(serverName);
                        this.modifiedValuesCache.serverName = serverName;
                        nameSet = true;
                        break;
                    }
                    serverName = String.valueOf(orgName) + " (" + Integer.toString(i + 2) + ")";
                    ++i;
                }
                if (!nameSet) {
                    this.name.setText("");
                    this.modifiedValuesCache.serverName = "";
                }
            } else {
                this.name.setText(serverName);
            }
        } else {
            this.name.setText("");
        }
        if (!(baseURL = this.originalValuesCache.url).equals("")) {
            this.url.setText(baseURL);
            try {
                int port;
                URL originalURL = new URL(baseURL);
                this.originalValuesCache.port = port = originalURL.getPort();
                this.modifiedValuesCache.port = port;
            }
            catch (Exception exception) {
                this.setMessage(PHPServerUIMessages.getString("ServerCompositeFragment.enterValidURL"), 3);
            }
        } else {
            baseURL = "http://" + server.getHost();
            this.url.setText(baseURL);
            this.modifiedValuesCache.url = baseURL;
            try {
                int port;
                URL createdURL = new URL(baseURL);
                this.modifiedValuesCache.port = port = createdURL.getPort();
            }
            catch (Exception exception) {
                this.setMessage(PHPServerUIMessages.getString("ServerCompositeFragment.enterValidURL"), 3);
            }
        }
        if (this.originalValuesCache.serverName != null && this.originalValuesCache.serverName.length() > 0) {
            this.setTitle(String.valueOf(PHPServerUIMessages.getString("ServerCompositeFragment.editServer")) + " [" + this.originalValuesCache.serverName + ']');
        } else {
            this.setTitle(PHPServerUIMessages.getString("ServerCompositeFragment.configureServer"));
        }
        this.controlHandler.setTitle(this.getTitle());
    }

    protected void validate() {
        if (this.getServer() == null) {
            this.setMessage("", 3);
            return;
        }
        this.setMessage(this.getDescription(), 0);
        String serverName = this.modifiedValuesCache.serverName;
        if (serverName == null || serverName.trim().equals("")) {
            this.setMessage(PHPServerUIMessages.getString("ServerCompositeFragment.missingServerName"), 3);
        } else {
            boolean ok = this.checkServerName(serverName);
            if (!ok) {
                this.setMessage(PHPServerUIMessages.getString("ServerCompositeFragment.duplicateServerName"), 3);
            }
        }
        String urlStr = this.url.getText();
        try {
            URL url = new URL(urlStr);
            if (url.getPath() != null && url.getPath().length() != 0) {
                urlStr = null;
            }
        }
        catch (MalformedURLException malformedURLException) {
            urlStr = null;
        }
        if (urlStr == null || urlStr.equals("")) {
            this.setMessage(PHPServerUIMessages.getString("ServerCompositeFragment.enterValidURL"), 3);
            return;
        }
        try {
            URL baseURL = new URL(urlStr);
            String host = baseURL.getHost();
            int port = baseURL.getPort();
            this.modifiedValuesCache.host = host;
            this.modifiedValuesCache.port = port;
        }
        catch (Exception exception) {
            this.setMessage(PHPServerUIMessages.getString("ServerCompositeFragment.enterValidURL"), 3);
            return;
        }
        this.controlHandler.update();
    }

    protected void setMessage(String message, int type) {
        this.controlHandler.setMessage(message, type);
        this.setComplete(type != 3);
        this.controlHandler.update();
    }

    protected void createURLGroup(Composite parent) {
        Font font = parent.getFont();
        Group urlGroup = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        urlGroup.setLayout((Layout)layout);
        urlGroup.setLayoutData((Object)new GridData(768));
        urlGroup.setFont(font);
        urlGroup.setText(PHPServerUIMessages.getString("ServerCompositeFragment.enterDocumentRootURL"));
        this.url = new Text((Composite)urlGroup, 2048);
        GridData data = new GridData(768);
        this.url.setLayoutData((Object)data);
        this.url.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ServerCompositeFragment.this.getServer() != null) {
                    String urlStr;
                    ((ServerCompositeFragment)ServerCompositeFragment.this).modifiedValuesCache.url = urlStr = ServerCompositeFragment.this.url.getText();
                }
                ServerCompositeFragment.this.validate();
            }
        });
    }

    private boolean checkServerName(String name) {
        if ((name = name.trim()).equals(this.originalValuesCache.serverName)) {
            return true;
        }
        Server[] allServers = ServersManager.getServers();
        if (allServers != null) {
            int size = allServers.length;
            int i = 0;
            while (i < size) {
                Server server = allServers[i];
                if (name.equals(server.getName())) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public boolean performOk() {
        try {
            Server defaultServer = ServersManager.getDefaultServer(null);
            boolean isDefault = false;
            isDefault = defaultServer != null && defaultServer.getName().equals(this.originalValuesCache.serverName);
            Server server = this.getServer();
            if (server != null) {
                server.setPort(String.valueOf(this.modifiedValuesCache.port));
                server.setBaseURL(this.modifiedValuesCache.url);
            }
            server.setHost(this.modifiedValuesCache.host);
            server.setName(this.modifiedValuesCache.serverName);
            if (this.originalValuesCache.serverName != null && !this.originalValuesCache.serverName.equals("") && !this.originalValuesCache.serverName.equals(this.modifiedValuesCache.serverName)) {
                ServersManager.removeServer((String)this.originalValuesCache.serverName);
                ServersManager.addServer((Server)server);
                if (isDefault) {
                    ServersManager.setDefaultServer(null, (Server)server);
                }
            }
        }
        catch (Throwable e) {
            Logger.logException("Error while saving the server settings", e);
            return false;
        }
        return true;
    }

    public boolean performCancel() {
        try {
            Server server = this.getServer();
            if (server != null) {
                server.setPort(String.valueOf(this.originalValuesCache.port));
                server.setBaseURL(this.originalValuesCache.url);
            }
            server.setHost(this.originalValuesCache.host);
            server.setName(this.originalValuesCache.serverName);
        }
        catch (Throwable e) {
            Logger.logException("Error while reverting the server settings", e);
            return false;
        }
        return super.performCancel();
    }

    private class ValuesCache {
        String serverName;
        String url;
        String host;
        int port;

        public ValuesCache() {
        }

        public ValuesCache(ValuesCache cache) {
            this.serverName = cache.serverName;
            this.url = cache.url;
            this.port = cache.port;
            this.host = cache.host;
        }
    }
}

