/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.autoEdit;

import java.io.BufferedReader;
import java.io.StringReader;
import java.util.ArrayList;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultIndentLineAutoEditStrategy;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.php.internal.core.documentModel.parser.PhpSourceParser;
import org.eclipse.php.internal.core.format.DefaultIndentationStrategy;
import org.eclipse.php.internal.core.format.PhpFormatter;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.wst.sse.core.internal.ltk.parser.RegionParser;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.text.JobSafeStructuredDocument;

public class PHPAutoIndentStrategy
extends DefaultIndentLineAutoEditStrategy {
    public void customizeDocumentCommand(IDocument d, DocumentCommand c) {
        if (c.text != null && c.text.length() > 1 && c.text.trim().length() > 1 && !PHPAutoIndentStrategy.getPreferenceStore().getBoolean("smartPaste")) {
            this.smartPaste(d, c);
        }
    }

    private static IPreferenceStore getPreferenceStore() {
        return PHPUiPlugin.getDefault().getPreferenceStore();
    }

    protected void smartPaste(IDocument document, DocumentCommand command) {
        StringBuffer helpBuffer;
        block11: {
            if (command.offset == -1 || document.getLength() == 0) {
                return;
            }
            helpBuffer = new StringBuffer();
            try {
                if (!(document instanceof IStructuredDocument)) break block11;
                DefaultIndentationStrategy.placeMatchingBlanksForStructuredDocument((IStructuredDocument)((IStructuredDocument)document), (StringBuffer)helpBuffer, (int)document.getLineOfOffset(command.offset), (int)command.offset);
                IRegion region = document.getLineInformation(document.getLineOfOffset(command.offset));
                if (document.get(region.getOffset(), region.getLength()).trim().length() == 0) {
                    if (command.offset != region.getOffset()) {
                        document.replace(region.getOffset(), region.getLength(), "");
                        command.offset = region.getOffset();
                    }
                    break block11;
                }
                return;
            }
            catch (BadLocationException badLocationException) {}
        }
        JobSafeStructuredDocument newdocument = new JobSafeStructuredDocument((RegionParser)new PhpSourceParser());
        String start = "<?php";
        newdocument.set(String.valueOf(start) + command.text);
        PhpFormatter formatter = new PhpFormatter(0, newdocument.getLength());
        formatter.format(newdocument.getFirstStructuredDocumentRegion());
        StringReader reader = new StringReader(newdocument.get());
        new BufferedReader(reader);
        ArrayList<String> list = new ArrayList<String>();
        try {
            int lineNumber = newdocument.getNumberOfLines();
            int i = 0;
            while (i < lineNumber) {
                IRegion region = newdocument.getLineInformation(i);
                String line = newdocument.get(region.getOffset(), region.getLength());
                if (list.isEmpty()) {
                    line = line.substring(start.length()).trim();
                }
                list.add(line);
                ++i;
            }
        }
        catch (BadLocationException badLocationException) {}
        String newline = newdocument.getLineDelimiter();
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < list.size()) {
            sb.append(helpBuffer.toString()).append((String)list.get(i));
            if (i != list.size() - 1) {
                sb.append(newline);
            }
            ++i;
        }
        command.text = sb.toString();
    }
}

