/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor.contentassist;

import org.eclipse.dltk.core.CompletionProposal;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.ui.ScriptElementImageDescriptor;
import org.eclipse.dltk.ui.ScriptElementImageProvider;
import org.eclipse.dltk.ui.text.completion.AbstractScriptCompletionProposal;
import org.eclipse.dltk.ui.text.completion.IScriptCompletionProposal;
import org.eclipse.dltk.ui.text.completion.MethodProposalInfo;
import org.eclipse.dltk.ui.text.completion.ProposalInfo;
import org.eclipse.dltk.ui.text.completion.ScriptCompletionProposal;
import org.eclipse.dltk.ui.text.completion.ScriptCompletionProposalCollector;
import org.eclipse.dltk.ui.text.completion.TypeProposalInfo;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.php.internal.core.codeassist.AliasType;
import org.eclipse.php.internal.core.codeassist.IPHPCompletionRequestor;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;
import org.eclipse.php.internal.ui.editor.contentassist.PHPCompletionProposal;
import org.eclipse.php.internal.ui.editor.contentassist.PHPCompletionProposalLabelProvider;
import org.eclipse.php.internal.ui.editor.contentassist.PHPOverrideCompletionProposal;
import org.eclipse.php.internal.ui.editor.contentassist.ParameterGuessingProposal;
import org.eclipse.php.internal.ui.util.PHPPluginImages;
import org.eclipse.swt.graphics.Image;

public class PHPCompletionProposalCollector
extends ScriptCompletionProposalCollector
implements IPHPCompletionRequestor {
    private static final String DOUBLE_COLON = "::";
    private static final String EMPTY_STRING = "";
    private IDocument document;
    private boolean explicit;
    private int offset;

    public PHPCompletionProposalCollector(IDocument document, ISourceModule cu, boolean explicit) {
        super(cu);
        this.document = document;
        this.explicit = explicit;
    }

    protected ScriptCompletionProposal createOverrideCompletionProposal(IScriptProject scriptProject, ISourceModule compilationUnit, String name, String[] paramTypes, int start, int length, String label, String string) {
        return new PHPOverrideCompletionProposal(scriptProject, compilationUnit, name, paramTypes, start, length, label, string);
    }

    protected ScriptCompletionProposal createScriptCompletionProposal(String completion, int replaceStart, int length, Image image, String displayString, int i) {
        return new PHPCompletionProposal(completion, replaceStart, length, image, displayString, i);
    }

    protected ScriptCompletionProposal createScriptCompletionProposal(String completion, int replaceStart, int length, Image image, String displayString, int i, boolean isInDoc) {
        return new PHPCompletionProposal(completion, replaceStart, length, image, displayString, i, isInDoc);
    }

    protected IScriptCompletionProposal createPackageProposal(CompletionProposal proposal) {
        AbstractScriptCompletionProposal scriptProposal = (AbstractScriptCompletionProposal)super.createPackageProposal(proposal);
        IModelElement modelElement = proposal.getModelElement();
        if (modelElement != null) {
            scriptProposal.setProposalInfo(new ProposalInfo(modelElement.getScriptProject(), new String(proposal.getName())));
        }
        return scriptProposal;
    }

    protected IScriptCompletionProposal createKeywordProposal(CompletionProposal proposal) {
        AbstractScriptCompletionProposal scriptProposal = (AbstractScriptCompletionProposal)super.createKeywordProposal(proposal);
        IModelElement modelElement = proposal.getModelElement();
        if (modelElement != null && modelElement.getElementType() == 5) {
            scriptProposal.setImage(PHPPluginImages.get("org.eclipse.php.ui.phpfile.gif"));
        }
        return scriptProposal;
    }

    protected IScriptCompletionProposal createScriptCompletionProposal(CompletionProposal proposal) {
        ScriptCompletionProposal completionProposal;
        block4: {
            completionProposal = proposal.getKind() == 6 ? this.createMethodDeclarationProposal(proposal) : (proposal.getKind() == 7 ? (ScriptCompletionProposal)this.createTypeProposal(proposal) : (ScriptCompletionProposal)super.createScriptCompletionProposal(proposal));
            if (proposal.getKind() == 6) {
                IMethod method = (IMethod)proposal.getModelElement();
                try {
                    if (method.isConstructor()) {
                        int flags = proposal.getFlags();
                        ImageDescriptor typeImageDescriptor = ScriptElementImageProvider.getTypeImageDescriptor((int)flags, (boolean)false);
                        int adornmentFlags = ScriptElementImageProvider.computeAdornmentFlags((IModelElement)method.getDeclaringType(), (int)3);
                        ScriptElementImageDescriptor descriptor = new ScriptElementImageDescriptor(typeImageDescriptor, adornmentFlags, ScriptElementImageProvider.SMALL_SIZE);
                        completionProposal.setImage(this.getImage((ImageDescriptor)descriptor));
                    }
                }
                catch (ModelException e) {
                    if (!DLTKCore.DEBUG_COMPLETION) break block4;
                    e.printStackTrace();
                }
            }
        }
        return completionProposal;
    }

    protected char[] getVarTrigger() {
        return null;
    }

    public IDocument getDocument() {
        return this.document;
    }

    public boolean isExplicit() {
        return this.explicit;
    }

    private ScriptCompletionProposal createMethodDeclarationProposal(CompletionProposal proposal) {
        if (this.getSourceModule() == null || this.getSourceModule().getScriptProject() == null) {
            return null;
        }
        String name = String.valueOf(proposal.getName());
        String[] paramTypes = new String[]{};
        int start = proposal.getReplaceStart();
        int length = this.getLength(proposal);
        String label = ((PHPCompletionProposalLabelProvider)this.getLabelProvider()).createOverrideMethodProposalLabel(proposal);
        ScriptCompletionProposal scriptProposal = this.createParameterGuessingProposal(proposal, this.getSourceModule().getScriptProject(), this.getSourceModule(), name, paramTypes, start, length, label, String.valueOf(proposal.getCompletion()), proposal.getExtraInfo());
        scriptProposal.setImage(this.getImage(this.getLabelProvider().createMethodImageDescriptor(proposal)));
        MethodProposalInfo info = new MethodProposalInfo(this.getSourceModule().getScriptProject(), proposal);
        scriptProposal.setProposalInfo((ProposalInfo)info);
        scriptProposal.setRelevance(this.computeRelevance(proposal));
        return scriptProposal;
    }

    private ScriptCompletionProposal createParameterGuessingProposal(CompletionProposal proposal, IScriptProject scriptProject, ISourceModule sourceModule, String name, String[] paramTypes, int start, int length, String label, String string, Object extraInfo) {
        return new ParameterGuessingProposal(proposal, scriptProject, sourceModule, name, paramTypes, start, length, label, string, false, extraInfo);
    }

    private IScriptCompletionProposal createTypeProposal(final CompletionProposal typeProposal) {
        String completion = new String(typeProposal.getCompletion());
        int replaceStart = typeProposal.getReplaceStart();
        int length = this.getLength(typeProposal);
        Image image = this.getImage(((PHPCompletionProposalLabelProvider)this.getLabelProvider()).createTypeImageDescriptor(typeProposal));
        String displayString = ((PHPCompletionProposalLabelProvider)this.getLabelProvider()).createTypeProposalLabel(typeProposal);
        PHPCompletionProposal scriptProposal = new PHPCompletionProposal(completion, replaceStart, length, image, displayString, 0){
            private boolean fReplacementStringComputed;
            {
                super($anonymous0, $anonymous1, $anonymous2, $anonymous3, $anonymous4, $anonymous5);
                this.fReplacementStringComputed = false;
            }

            public String getReplacementString() {
                if (!this.fReplacementStringComputed) {
                    this.setReplacementString(this.computeReplacementString());
                }
                return super.getReplacementString();
            }

            private String computeReplacementString() {
                this.fReplacementStringComputed = true;
                IType type = (IType)typeProposal.getModelElement();
                String suffix = this.getSuffix(type);
                String replacementString = null;
                replacementString = typeProposal.getModelElement() instanceof AliasType ? ((AliasType)typeProposal.getModelElement()).getAlias() : super.getReplacementString();
                return String.valueOf(replacementString) + suffix;
            }

            public String getSuffix(IType type) {
                String defaultResult = PHPCompletionProposalCollector.EMPTY_STRING;
                boolean cfr_ignored_0 = type instanceof AliasType;
                if ("TYPE_ONLY".equals(typeProposal.getExtraInfo()) || !PHPModelUtils.hasStaticOrConstMember((IType)type)) {
                    return defaultResult;
                }
                String nextWord = null;
                try {
                    nextWord = PHPCompletionProposalCollector.this.document.get(PHPCompletionProposalCollector.this.offset, 2);
                }
                catch (BadLocationException badLocationException) {}
                return PHPCompletionProposalCollector.DOUBLE_COLON.equals(nextWord) ? defaultResult : PHPCompletionProposalCollector.DOUBLE_COLON;
            }
        };
        scriptProposal.setRelevance(this.computeRelevance(typeProposal));
        scriptProposal.setProposalInfo((ProposalInfo)new TypeProposalInfo(this.getSourceModule().getScriptProject(), typeProposal));
        return scriptProposal;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    protected String getNatureId() {
        return "org.eclipse.php.core.PHPNature";
    }

    protected int computeRelevance(CompletionProposal proposal) {
        if ("STUB".equals(proposal.getExtraInfo())) {
            return Integer.MAX_VALUE;
        }
        if ("MAGIC_METHOD".equals(proposal.getExtraInfo())) {
            return -1;
        }
        return super.computeRelevance(proposal);
    }
}

