/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.explorer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IOpenable;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptModel;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.index2.search.ISearchEngine;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.dltk.internal.core.ArchiveFolder;
import org.eclipse.dltk.internal.core.ArchiveProjectFragment;
import org.eclipse.dltk.internal.core.BuildpathEntry;
import org.eclipse.dltk.internal.core.ExternalProjectFragment;
import org.eclipse.dltk.internal.core.ExternalScriptFolder;
import org.eclipse.dltk.internal.core.ScriptProject;
import org.eclipse.dltk.internal.ui.StandardModelElementContentProvider;
import org.eclipse.dltk.internal.ui.navigator.ScriptExplorerContentProvider;
import org.eclipse.dltk.internal.ui.scriptview.BuildPathContainer;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.core.includepath.IIncludepathListener;
import org.eclipse.php.internal.core.includepath.IncludePath;
import org.eclipse.php.internal.core.includepath.IncludePathManager;
import org.eclipse.php.internal.core.language.LanguageModelInitializer;
import org.eclipse.php.internal.core.model.PhpModelAccess;
import org.eclipse.php.internal.core.project.ProjectOptions;
import org.eclipse.php.internal.core.typeinference.GlobalNamespace;
import org.eclipse.php.internal.ui.Logger;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.util.NamespaceNode;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.internal.ui.packageview.PackageFragmentRootContainer;
import org.eclipse.wst.jsdt.ui.ProjectLibraryRoot;
import org.eclipse.wst.jsdt.ui.StandardJavaScriptElementContentProvider;
import org.eclipse.wst.jsdt.ui.project.JsNature;

public class PHPExplorerContentProvider
extends ScriptExplorerContentProvider
implements IIncludepathListener {
    public static final ArrayList EMPTY_LIST = new ArrayList();
    StandardJavaScriptElementContentProvider jsContentProvider;

    public PHPExplorerContentProvider(boolean provideMembers) {
        super(provideMembers);
        IncludePathManager.getInstance().registerIncludepathListener((IIncludepathListener)this);
        this.setIsFlatLayout(false);
        this.jsContentProvider = new StandardJavaScriptElementContentProvider(true);
    }

    public void setIsFlatLayout(boolean state) {
        super.setIsFlatLayout(false);
    }

    public void dispose() {
        super.dispose();
        IncludePathManager.getInstance().unregisterIncludepathListener((IIncludepathListener)this);
    }

    private Object[] getNonPhpProjects(IScriptModel model) throws ModelException {
        return model.getForeignResources();
    }

    public Object[] getChildren(Object parentElement) {
        int entryKind;
        Object entry;
        IResource[] scriptProject2;
        if (parentElement instanceof IPath) {
            IProject project;
            IScriptProject sp;
            IPath path = (IPath)parentElement;
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IResource iesource = workspace.getRoot().findMember(path);
            if (iesource instanceof IProject && (sp = DLTKCore.create((IProject)(project = (IProject)iesource))) instanceof ScriptProject) {
                scriptProject2 = (IResource[])sp;
                try {
                    return scriptProject2.getAllProjectFragments();
                }
                catch (ModelException e) {
                    Logger.logException(e);
                }
            }
        }
        if (parentElement instanceof IncludePath && (entry = ((IncludePath)parentElement).getEntry()) instanceof IBuildpathEntry && ((entryKind = ((IBuildpathEntry)entry).getEntryKind()) == 5 || entryKind == 1)) {
            return this.getBuildPathEntryChildren(parentElement, entry);
        }
        if (parentElement instanceof ProjectLibraryRoot) {
            return ((ProjectLibraryRoot)parentElement).getChildren();
        }
        if (parentElement instanceof PackageFragmentRootContainer) {
            return this.getContainerPackageFragmentRoots((PackageFragmentRootContainer)parentElement, true);
        }
        if (parentElement instanceof IJavaScriptElement) {
            return this.jsContentProvider.getChildren(parentElement);
        }
        try {
            ArrayList<Object> returnChlidren;
            if (parentElement instanceof IMethod) {
                return NO_CHILDREN;
            }
            if (parentElement instanceof IScriptModel) {
                return StandardModelElementContentProvider.concatenate((Object[])this.getScriptProjects((IScriptModel)parentElement), (Object[])this.getNonPhpProjects((IScriptModel)parentElement));
            }
            if (parentElement instanceof ISourceModule || !(parentElement instanceof IOpenable) || parentElement instanceof ExternalProjectFragment) {
                if (parentElement instanceof IFolder) {
                    IResource[] members = ((IFolder)parentElement).members();
                    returnChlidren = new ArrayList<Object>();
                    scriptProject2 = members;
                    int sp = members.length;
                    int project = 0;
                    while (project < sp) {
                        IResource resource2 = scriptProject2[project];
                        IModelElement modelElement2 = DLTKCore.create((IResource)resource2);
                        if (modelElement2 != null && this.isSourceFolder(modelElement2)) {
                            returnChlidren.add(modelElement2);
                        } else {
                            returnChlidren.add(resource2);
                        }
                        ++project;
                    }
                    return returnChlidren.toArray(new Object[returnChlidren.size()]);
                }
                return super.getChildren(parentElement);
            }
            if (parentElement instanceof IOpenable) {
                if (parentElement instanceof ExternalScriptFolder) {
                    return super.getChildren(parentElement);
                }
                IResource resource = ((IOpenable)parentElement).getResource();
                if (resource instanceof IContainer) {
                    Object modelElement;
                    if (!resource.isAccessible()) {
                        return NO_CHILDREN;
                    }
                    returnChlidren = new ArrayList();
                    boolean groupByNamespace = PHPUiPlugin.getDefault().getPreferenceStore().getBoolean("PHPExplorerPart.groupByNamespaces");
                    if (groupByNamespace && parentElement instanceof IScriptProject && this.supportsNamespaces((IScriptProject)parentElement)) {
                        returnChlidren.add(new GlobalNamespace((IScriptProject)parentElement));
                        returnChlidren.addAll(Arrays.asList(this.getAllNamespaces((IScriptProject)parentElement)));
                    } else {
                        IResource[] resChildren;
                        IResource[] iResourceArray = resChildren = ((IContainer)resource).members();
                        int modelElement2 = resChildren.length;
                        int scriptProject2 = 0;
                        while (scriptProject2 < modelElement2) {
                            IResource resource2 = iResourceArray[scriptProject2];
                            modelElement = DLTKCore.create((IResource)resource2);
                            if (modelElement != null && this.isInSourceFolder((IModelElement)modelElement)) {
                                returnChlidren.add(modelElement);
                            } else {
                                returnChlidren.add(resource2);
                            }
                            ++scriptProject2;
                        }
                    }
                    if (parentElement instanceof IScriptProject) {
                        Object[] projectChildren;
                        IScriptProject scriptProject3 = (IScriptProject)parentElement;
                        IProject project = scriptProject3.getProject();
                        IncludePath[] includePaths = IncludePathManager.getInstance().getIncludePaths(project);
                        IncludePathContainer incPathContainer = new IncludePathContainer(scriptProject3, includePaths);
                        returnChlidren.add((Object)incPathContainer);
                        Object[] objectArray = projectChildren = this.getProjectFragments(scriptProject3);
                        int n = projectChildren.length;
                        int n2 = 0;
                        while (n2 < n) {
                            modelElement = objectArray[n2];
                            if (modelElement instanceof BuildPathContainer && ((BuildPathContainer)modelElement).getBuildpathEntry().getPath().equals((Object)LanguageModelInitializer.LANGUAGE_CONTAINER_PATH)) {
                                returnChlidren.add(modelElement);
                            }
                            ++n2;
                        }
                        boolean hasJsNature = JsNature.hasNature((IProject)project);
                        if (hasJsNature) {
                            ProjectLibraryRoot projectLibs = new ProjectLibraryRoot(JavaScriptCore.create((IProject)project));
                            returnChlidren.add(projectLibs);
                        }
                    }
                    return returnChlidren.toArray();
                }
            }
        }
        catch (CoreException e) {
            Logger.logException(e);
        }
        if (parentElement instanceof ArchiveProjectFragment || parentElement instanceof ArchiveFolder) {
            return super.getChildren(parentElement);
        }
        return NO_CHILDREN;
    }

    private boolean isSourceFolder(IModelElement modelElement) {
        ScriptProject project = (ScriptProject)modelElement.getScriptProject();
        IBuildpathEntry[] buildpath = null;
        try {
            buildpath = project.getResolvedBuildpath();
        }
        catch (ModelException modelException) {}
        if (buildpath == null) {
            return false;
        }
        int j = 0;
        int buildpathLength = buildpath.length;
        while (j < buildpathLength) {
            IBuildpathEntry entry = buildpath[j];
            IPath path = entry.getPath();
            if (path != null && path.equals((Object)modelElement.getResource().getFullPath())) {
                return true;
            }
            ++j;
        }
        return false;
    }

    private boolean isInSourceFolder(IModelElement modelElement) {
        ScriptProject project = (ScriptProject)modelElement.getScriptProject();
        IBuildpathEntry[] buildpath = null;
        try {
            buildpath = project.getResolvedBuildpath();
        }
        catch (ModelException modelException) {}
        if (buildpath == null) {
            return false;
        }
        int j = 0;
        int buildpathLength = buildpath.length;
        while (j < buildpathLength) {
            IBuildpathEntry entry = buildpath[j];
            IPath path = entry.getPath();
            if (this.isInPath(path, modelElement.getResource())) {
                return true;
            }
            ++j;
        }
        return false;
    }

    private boolean isInPath(IPath parentPath, IResource resouce) {
        IPath path = resouce.getFullPath();
        while (path != null && path.segmentCount() > 0) {
            if (path.equals((Object)parentPath)) {
                return true;
            }
            path = path.removeLastSegments(1);
        }
        return false;
    }

    protected boolean supportsNamespaces(IScriptProject project) {
        PHPVersion version = ProjectOptions.getPhpVersion((IProject)project.getProject());
        return version.isGreaterThan(PHPVersion.PHP5);
    }

    protected Object[] getAllNamespaces(IScriptProject project) throws ModelException {
        IDLTKSearchScope scope = SearchEngine.createSearchScope((IModelElement)project, (int)1);
        IType[] namespaces = PhpModelAccess.getDefault().findTypes(null, ISearchEngine.MatchRule.PREFIX, 2048, 0, scope, null);
        HashMap<String, LinkedList<IType>> aggregated = new HashMap<String, LinkedList<IType>>();
        IType[] iTypeArray = namespaces;
        int n = namespaces.length;
        int n2 = 0;
        while (n2 < n) {
            IType ns = iTypeArray[n2];
            String elementName = ns.getElementName();
            LinkedList<IType> l = (LinkedList<IType>)aggregated.get(elementName);
            if (l == null) {
                l = new LinkedList<IType>();
                aggregated.put(elementName, l);
            }
            l.add(ns);
            ++n2;
        }
        LinkedList<NamespaceNode> result = new LinkedList<NamespaceNode>();
        for (String namespaceName : aggregated.keySet()) {
            List list = (List)aggregated.get(namespaceName);
            result.add(new NamespaceNode(project, namespaceName, list.toArray(new IType[list.size()])));
        }
        return result.toArray();
    }

    private Object[] getContainerPackageFragmentRoots(PackageFragmentRootContainer container, boolean createFolder) {
        IAdaptable[] children = container.getChildren();
        if (children == null) {
            return new Object[0];
        }
        ArrayList<IJavaScriptElement> allChildren = new ArrayList<IJavaScriptElement>();
        ArrayList<Object> expanded = new ArrayList<Object>();
        expanded.addAll(Arrays.asList(children));
        if (expanded == null || expanded.size() < 1) {
            return new Object[0];
        }
        Object next = expanded.remove(0);
        while (next != null) {
            try {
                List<IJavaScriptElement> newChildren;
                if (next instanceof IPackageFragment) {
                    expanded.addAll(Arrays.asList(((IPackageFragment)next).getChildren()));
                } else if (next instanceof IPackageFragmentRoot) {
                    expanded.addAll(Arrays.asList(((IPackageFragmentRoot)next).getChildren()));
                } else if (next instanceof IClassFile) {
                    newChildren = Arrays.asList(((IClassFile)next).getChildren());
                    allChildren.removeAll(newChildren);
                    allChildren.addAll(newChildren);
                } else if (next instanceof IJavaScriptUnit) {
                    newChildren = Arrays.asList(((IJavaScriptUnit)next).getChildren());
                    allChildren.removeAll(newChildren);
                    allChildren.addAll(newChildren);
                }
            }
            catch (JavaScriptModelException ex) {
                Logger.logException(ex);
            }
            next = expanded.size() > 0 ? expanded.remove(0) : null;
        }
        return allChildren.toArray();
    }

    private Object[] getBuildPathEntryChildren(Object parentElement, Object entry) {
        IProjectFragment[] findProjectFragments;
        IScriptProject scriptProject = DLTKCore.create((IProject)((IncludePath)parentElement).getProject());
        IProjectFragment[] iProjectFragmentArray = findProjectFragments = scriptProject.findProjectFragments((IBuildpathEntry)entry);
        if (findProjectFragments.length != 0) {
            IProjectFragment projectFragment = iProjectFragmentArray[0];
            return this.getChildren(projectFragment);
        }
        return this.getChildren(((BuildpathEntry)entry).getPath());
    }

    public void refresh(IProject project) {
        ArrayList runnables = new ArrayList();
        ArrayList<IScriptProject> resources = new ArrayList<IScriptProject>(1);
        resources.add(DLTKCore.create((IProject)project));
        this.postRefresh(resources, true, runnables);
        this.executeRunnables(runnables);
    }

    public class IncludePathContainer
    extends BuildPathContainer {
        private IncludePath[] fIncludePath;

        public IncludePathContainer(IScriptProject parent, IncludePath[] entries) {
            super(parent, DLTKCore.newContainerEntry((IPath)parent.getPath()));
            this.fIncludePath = entries;
        }

        public String getLabel() {
            return PHPUIMessages.IncludePathExplorerNode_label;
        }

        public IAdaptable[] getChildren() {
            return this.fIncludePath;
        }

        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + ((Object)((Object)this.getOuterType())).hashCode();
            result = 31 * result + Arrays.hashCode(this.fIncludePath);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            IncludePathContainer other = (IncludePathContainer)((Object)obj);
            if (!((Object)((Object)this.getOuterType())).equals((Object)other.getOuterType())) {
                return false;
            }
            return Arrays.equals(this.fIncludePath, other.fIncludePath);
        }

        private PHPExplorerContentProvider getOuterType() {
            return PHPExplorerContentProvider.this;
        }
    }
}

