/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.compare;

import java.util.ResourceBundle;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareViewerPane;
import org.eclipse.compare.ICompareContainer;
import org.eclipse.compare.ICompareInputLabelProvider;
import org.eclipse.compare.IPropertyChangeNotifier;
import org.eclipse.compare.contentmergeviewer.IFlushable;
import org.eclipse.compare.contentmergeviewer.IMergeViewerContentProvider;
import org.eclipse.compare.internal.ChangePropertyAction;
import org.eclipse.compare.internal.CompareHandlerService;
import org.eclipse.compare.internal.ICompareUIConstants;
import org.eclipse.compare.internal.MergeViewerAction;
import org.eclipse.compare.internal.MergeViewerContentProvider;
import org.eclipse.compare.internal.Utilities;
import org.eclipse.compare.internal.ViewerSwitchingCancelled;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.compare.structuremergeviewer.ICompareInputChangeListener;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.window.Window;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.Shell;

public abstract class ContentMergeViewer
extends ContentViewer
implements IPropertyChangeNotifier,
IFlushable {
    static final int HORIZONTAL = 1;
    static final int VERTICAL = 2;
    static final double HSPLIT = 0.5;
    static final double VSPLIT = 0.3;
    private int fStyles;
    private ResourceBundle fBundle;
    private final CompareConfiguration fCompareConfiguration;
    private IPropertyChangeListener fPropertyChangeListener;
    private ICompareInputChangeListener fCompareInputChangeListener;
    private ListenerList fListenerList;
    boolean fConfirmSave = true;
    private double fHSplit = -1.0;
    private double fVSplit = 0.3;
    private boolean fIsThreeWay;
    private boolean fAncestorVisible;
    private ActionContributionItem fAncestorItem;
    private Action fCopyLeftToRightAction;
    private Action fCopyRightToLeftAction;
    MergeViewerAction fLeftSaveAction;
    MergeViewerAction fRightSaveAction;
    private CompareHandlerService fHandlerService;
    Composite fComposite;
    private CLabel fAncestorLabel;
    private CLabel fLeftLabel;
    private CLabel fRightLabel;
    CLabel fDirectionLabel;
    Control fCenter;
    private Image fRightArrow;
    private Image fLeftArrow;
    private Image fBothArrow;
    Cursor fNormalCursor;
    private Cursor fHSashCursor;
    private Cursor fVSashCursor;
    private Cursor fHVSashCursor;
    private ILabelProviderListener labelChangeListener = new ILabelProviderListener(){

        public void labelProviderChanged(LabelProviderChangedEvent event) {
            Object[] elements = event.getElements();
            int i = 0;
            while (i < elements.length) {
                Object object = elements[i];
                if (object == ContentMergeViewer.this.getInput()) {
                    ContentMergeViewer.this.updateHeader();
                }
                ++i;
            }
        }
    };

    protected ContentMergeViewer(int style, ResourceBundle bundle, CompareConfiguration cc) {
        this.fStyles = style & 0xF9FFFFFF;
        this.fBundle = bundle;
        this.fAncestorVisible = Utilities.getBoolean((CompareConfiguration)cc, (String)ICompareUIConstants.PROP_ANCESTOR_VISIBLE, (boolean)this.fAncestorVisible);
        this.fConfirmSave = Utilities.getBoolean((CompareConfiguration)cc, (String)"org.eclipse.compare.internal.CONFIRM_SAVE_PROPERTY", (boolean)this.fConfirmSave);
        this.setContentProvider((IContentProvider)new MergeViewerContentProvider(cc));
        this.fCompareInputChangeListener = new ICompareInputChangeListener(){

            public void compareInputChanged(ICompareInput input) {
                if (input == ContentMergeViewer.this.getInput()) {
                    ContentMergeViewer.this.handleCompareInputChange();
                }
            }
        };
        this.fCompareConfiguration = cc == null ? new CompareConfiguration() : cc;
        this.fPropertyChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                ContentMergeViewer.this.handlePropertyChangeEvent(event);
            }
        };
        this.fCompareConfiguration.addPropertyChangeListener(this.fPropertyChangeListener);
        this.fLeftSaveAction = new SaveAction(true);
        this.fLeftSaveAction.setEnabled(false);
        this.fRightSaveAction = new SaveAction(false);
        this.fRightSaveAction.setEnabled(false);
    }

    public String getTitle() {
        return Utilities.getString((ResourceBundle)this.getResourceBundle(), (String)"title");
    }

    protected abstract void createControls(Composite var1);

    protected abstract void handleResizeAncestor(int var1, int var2, int var3, int var4);

    protected abstract void handleResizeLeftRight(int var1, int var2, int var3, int var4, int var5, int var6);

    protected void createToolItems(ToolBarManager toolBarManager) {
    }

    protected abstract void updateContent(Object var1, Object var2, Object var3);

    protected abstract void copy(boolean var1);

    protected abstract byte[] getContents(boolean var1);

    protected ResourceBundle getResourceBundle() {
        return this.fBundle;
    }

    protected CompareConfiguration getCompareConfiguration() {
        return this.fCompareConfiguration;
    }

    public void setContentProvider(IContentProvider contentProvider) {
        Assert.isTrue((boolean)(contentProvider instanceof IMergeViewerContentProvider));
        super.setContentProvider(contentProvider);
    }

    IMergeViewerContentProvider getMergeContentProvider() {
        return (IMergeViewerContentProvider)this.getContentProvider();
    }

    public ISelection getSelection() {
        return new ISelection(){

            public boolean isEmpty() {
                return true;
            }
        };
    }

    public void setSelection(ISelection selection, boolean reveal) {
    }

    protected void handlePropertyChangeEvent(PropertyChangeEvent event) {
        String key = event.getProperty();
        if (key.equals(ICompareUIConstants.PROP_ANCESTOR_VISIBLE)) {
            this.fAncestorVisible = Utilities.getBoolean((CompareConfiguration)this.getCompareConfiguration(), (String)ICompareUIConstants.PROP_ANCESTOR_VISIBLE, (boolean)this.fAncestorVisible);
            this.fComposite.layout(true);
            this.updateCursor((Control)this.fLeftLabel, 2);
            this.updateCursor((Control)this.fDirectionLabel, 3);
            this.updateCursor((Control)this.fRightLabel, 2);
            return;
        }
        if (key.equals(ICompareUIConstants.PROP_IGNORE_ANCESTOR)) {
            this.setAncestorVisibility(false, !Utilities.getBoolean((CompareConfiguration)this.getCompareConfiguration(), (String)ICompareUIConstants.PROP_IGNORE_ANCESTOR, (boolean)false));
            return;
        }
    }

    void updateCursor(Control c, int dir) {
        if (!(c instanceof Sash)) {
            Cursor cursor = null;
            switch (dir) {
                case 2: {
                    if (this.fAncestorVisible) {
                        if (this.fVSashCursor == null) {
                            this.fVSashCursor = new Cursor((Device)c.getDisplay(), 7);
                        }
                        cursor = this.fVSashCursor;
                        break;
                    }
                    if (this.fNormalCursor == null) {
                        this.fNormalCursor = new Cursor((Device)c.getDisplay(), 0);
                    }
                    cursor = this.fNormalCursor;
                    break;
                }
                case 1: {
                    if (this.fHSashCursor == null) {
                        this.fHSashCursor = new Cursor((Device)c.getDisplay(), 9);
                    }
                    cursor = this.fHSashCursor;
                    break;
                }
                case 3: {
                    if (this.fAncestorVisible) {
                        if (this.fHVSashCursor == null) {
                            this.fHVSashCursor = new Cursor((Device)c.getDisplay(), 5);
                        }
                        cursor = this.fHVSashCursor;
                        break;
                    }
                    if (this.fHSashCursor == null) {
                        this.fHSashCursor = new Cursor((Device)c.getDisplay(), 9);
                    }
                    cursor = this.fHSashCursor;
                }
            }
            if (cursor != null) {
                c.setCursor(cursor);
            }
        }
    }

    private void setAncestorVisibility(boolean visible, boolean enabled) {
        Action action;
        if (this.fAncestorItem != null && (action = (Action)this.fAncestorItem.getAction()) != null) {
            action.setChecked(visible);
            action.setEnabled(enabled);
        }
        this.getCompareConfiguration().setProperty(ICompareUIConstants.PROP_ANCESTOR_VISIBLE, (Object)new Boolean(visible));
    }

    protected boolean isThreeWay() {
        return this.fIsThreeWay;
    }

    protected final void inputChanged(Object input, Object oldInput) {
        ICompareInputLabelProvider lp;
        ICompareInputLabelProvider lp2;
        if (input != oldInput && oldInput != null && (lp2 = this.getCompareConfiguration().getLabelProvider()) != null) {
            lp2.removeListener(this.labelChangeListener);
        }
        if (input != oldInput && oldInput instanceof ICompareInput) {
            ICompareContainer container = this.getCompareConfiguration().getContainer();
            container.removeCompareInputChangeListener((ICompareInput)oldInput, this.fCompareInputChangeListener);
        }
        boolean success = this.doSave(input, oldInput);
        if (input != oldInput && input instanceof ICompareInput) {
            ICompareContainer container = this.getCompareConfiguration().getContainer();
            container.addCompareInputChangeListener((ICompareInput)input, this.fCompareInputChangeListener);
        }
        if (input != oldInput && input != null && (lp = this.getCompareConfiguration().getLabelProvider()) != null) {
            lp.addListener(this.labelChangeListener);
        }
        if (success) {
            this.setLeftDirty(false);
            this.setRightDirty(false);
        }
        if (input != oldInput) {
            this.internalRefresh(input);
        }
    }

    protected boolean doSave(Object newInput, Object oldInput) {
        if (this.isLeftDirty() || this.isRightDirty()) {
            if (Utilities.RUNNING_TESTS) {
                if (Utilities.TESTING_FLUSH_ON_COMPARE_INPUT_CHANGE) {
                    this.flushContent(oldInput, null);
                }
            } else if (this.fConfirmSave) {
                Shell shell = this.fComposite.getShell();
                MessageDialog dialog = new MessageDialog(shell, Utilities.getString((ResourceBundle)this.getResourceBundle(), (String)"saveDialog.title"), null, Utilities.getString((ResourceBundle)this.getResourceBundle(), (String)"saveDialog.message"), 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0);
                switch (dialog.open()) {
                    case 0: {
                        this.flushContent(oldInput, null);
                        break;
                    }
                    case 1: {
                        this.setLeftDirty(false);
                        this.setRightDirty(false);
                        break;
                    }
                    case 2: {
                        throw new ViewerSwitchingCancelled();
                    }
                }
            } else {
                this.flushContent(oldInput, null);
            }
            return true;
        }
        return false;
    }

    public void setConfirmSave(boolean enable) {
        this.fConfirmSave = enable;
    }

    public void refresh() {
        this.internalRefresh(this.getInput());
    }

    private void internalRefresh(Object input) {
        IMergeViewerContentProvider content = this.getMergeContentProvider();
        if (content != null) {
            Object ancestor = content.getAncestorContent(input);
            boolean oldFlag = this.fIsThreeWay;
            if (Utilities.isHunk((Object)input)) {
                this.fIsThreeWay = true;
            } else if (input instanceof ICompareInput) {
                this.fIsThreeWay = (((ICompareInput)input).getKind() & 0xC) != 0;
            } else {
                boolean bl = this.fIsThreeWay = ancestor != null;
            }
            if (this.fAncestorItem != null) {
                this.fAncestorItem.setVisible(this.fIsThreeWay);
            }
            if (this.fAncestorVisible && oldFlag != this.fIsThreeWay) {
                this.fComposite.layout(true);
            }
            Object left = content.getLeftContent(input);
            Object right = content.getRightContent(input);
            this.updateContent(ancestor, left, right);
            this.updateHeader();
            ToolBarManager tbm = CompareViewerPane.getToolBarManager((Composite)this.fComposite.getParent());
            if (tbm != null) {
                this.updateToolItems();
                tbm.update(true);
                tbm.getControl().getParent().layout(true);
            }
        }
    }

    protected final Control buildControl(Composite parent) {
        this.fComposite = new Composite(parent, this.fStyles | 0x2000000){

            public boolean setFocus() {
                return ContentMergeViewer.this.handleSetFocus();
            }
        };
        this.fComposite.setData("org.eclipse.compare.CompareUI.CompareViewerTitle", (Object)this.getTitle());
        this.hookControl((Control)this.fComposite);
        this.fComposite.setLayout((Layout)new ContentMergeViewerLayout());
        int style = 8;
        this.fAncestorLabel = new CLabel(this.fComposite, style | Window.getDefaultOrientation());
        this.fLeftLabel = new CLabel(this.fComposite, style | Window.getDefaultOrientation());
        new Resizer((Control)this.fLeftLabel, 2);
        this.fDirectionLabel = new CLabel(this.fComposite, style);
        this.fDirectionLabel.setAlignment(0x1000000);
        new Resizer((Control)this.fDirectionLabel, 3);
        this.fRightLabel = new CLabel(this.fComposite, style | Window.getDefaultOrientation());
        new Resizer((Control)this.fRightLabel, 2);
        if (this.fCenter == null || this.fCenter.isDisposed()) {
            this.fCenter = this.createCenterControl(this.fComposite);
        }
        this.createControls(this.fComposite);
        this.fHandlerService = CompareHandlerService.createFor((ICompareContainer)this.getCompareConfiguration().getContainer(), (Shell)this.fComposite.getShell());
        this.initializeToolbars(parent);
        return this.fComposite;
    }

    private void initializeToolbars(Composite parent) {
        ToolBarManager tbm = CompareViewerPane.getToolBarManager((Composite)parent);
        if (tbm != null) {
            tbm.removeAll();
            tbm.add((IContributionItem)new Separator("modes"));
            tbm.add((IContributionItem)new Separator("merge"));
            tbm.add((IContributionItem)new Separator("navigation"));
            CompareConfiguration cc = this.getCompareConfiguration();
            if (cc.isRightEditable()) {
                this.fCopyLeftToRightAction = new Action(){

                    public void run() {
                        ContentMergeViewer.this.copy(true);
                    }
                };
                Utilities.initAction((IAction)this.fCopyLeftToRightAction, (ResourceBundle)this.getResourceBundle(), (String)"action.CopyLeftToRight.");
                tbm.appendToGroup("merge", (IAction)this.fCopyLeftToRightAction);
                this.fHandlerService.registerAction((IAction)this.fCopyLeftToRightAction, "org.eclipse.compare.copyAllLeftToRight");
            }
            if (cc.isLeftEditable()) {
                this.fCopyRightToLeftAction = new Action(){

                    public void run() {
                        ContentMergeViewer.this.copy(false);
                    }
                };
                Utilities.initAction((IAction)this.fCopyRightToLeftAction, (ResourceBundle)this.getResourceBundle(), (String)"action.CopyRightToLeft.");
                tbm.appendToGroup("merge", (IAction)this.fCopyRightToLeftAction);
                this.fHandlerService.registerAction((IAction)this.fCopyRightToLeftAction, "org.eclipse.compare.copyAllRightToLeft");
            }
            ChangePropertyAction a = new ChangePropertyAction(this.fBundle, this.getCompareConfiguration(), "action.EnableAncestor.", ICompareUIConstants.PROP_ANCESTOR_VISIBLE);
            a.setChecked(this.fAncestorVisible);
            this.fAncestorItem = new ActionContributionItem((IAction)a);
            this.fAncestorItem.setVisible(false);
            tbm.appendToGroup("modes", (IContributionItem)this.fAncestorItem);
            tbm.getControl().addDisposeListener((DisposeListener)a);
            this.createToolItems(tbm);
            this.updateToolItems();
            tbm.update(true);
        }
    }

    protected boolean handleSetFocus() {
        return false;
    }

    protected int getCenterWidth() {
        return 3;
    }

    protected boolean isAncestorVisible() {
        return this.fAncestorVisible;
    }

    protected Control createCenterControl(Composite parent) {
        Sash sash = new Sash(parent, 512);
        new Resizer((Control)sash, 1);
        return sash;
    }

    protected Control getCenterControl() {
        return this.fCenter;
    }

    public Control getControl() {
        return this.fComposite;
    }

    protected void handleDispose(DisposeEvent event) {
        ICompareInputLabelProvider lp;
        Object input;
        if (this.fHandlerService != null) {
            this.fHandlerService.dispose();
        }
        if ((input = this.getInput()) instanceof ICompareInput) {
            ICompareContainer container = this.getCompareConfiguration().getContainer();
            container.removeCompareInputChangeListener((ICompareInput)input, this.fCompareInputChangeListener);
        }
        if (input != null && (lp = this.getCompareConfiguration().getLabelProvider()) != null) {
            lp.removeListener(this.labelChangeListener);
        }
        if (this.fPropertyChangeListener != null) {
            this.fCompareConfiguration.removePropertyChangeListener(this.fPropertyChangeListener);
            this.fPropertyChangeListener = null;
        }
        this.fAncestorLabel = null;
        this.fLeftLabel = null;
        this.fDirectionLabel = null;
        this.fRightLabel = null;
        this.fCenter = null;
        if (this.fRightArrow != null) {
            this.fRightArrow.dispose();
            this.fRightArrow = null;
        }
        if (this.fLeftArrow != null) {
            this.fLeftArrow.dispose();
            this.fLeftArrow = null;
        }
        if (this.fBothArrow != null) {
            this.fBothArrow.dispose();
            this.fBothArrow = null;
        }
        if (this.fNormalCursor != null) {
            this.fNormalCursor.dispose();
            this.fNormalCursor = null;
        }
        if (this.fHSashCursor != null) {
            this.fHSashCursor.dispose();
            this.fHSashCursor = null;
        }
        if (this.fVSashCursor != null) {
            this.fVSashCursor.dispose();
            this.fVSashCursor = null;
        }
        if (this.fHVSashCursor != null) {
            this.fHVSashCursor.dispose();
            this.fHVSashCursor = null;
        }
        super.handleDispose(event);
    }

    protected void updateToolItems() {
        boolean enable;
        IMergeViewerContentProvider content = this.getMergeContentProvider();
        Object input = this.getInput();
        if (this.fCopyLeftToRightAction != null) {
            enable = content.isRightEditable(input);
            this.fCopyLeftToRightAction.setEnabled(enable);
        }
        if (this.fCopyRightToLeftAction != null) {
            enable = content.isLeftEditable(input);
            this.fCopyRightToLeftAction.setEnabled(enable);
        }
    }

    protected void updateHeader() {
        IMergeViewerContentProvider content = this.getMergeContentProvider();
        Object input = this.getInput();
        if (this.fAncestorLabel != null) {
            String ancestorLabel;
            Image ancestorImage = content.getAncestorImage(input);
            if (ancestorImage != null) {
                this.fAncestorLabel.setImage(ancestorImage);
            }
            if ((ancestorLabel = content.getAncestorLabel(input)) != null) {
                this.fAncestorLabel.setText(TextProcessor.process((String)ancestorLabel));
            }
        }
        if (this.fLeftLabel != null) {
            String leftLabel;
            Image leftImage = content.getLeftImage(input);
            if (leftImage != null) {
                this.fLeftLabel.setImage(leftImage);
            }
            if ((leftLabel = content.getLeftLabel(input)) != null) {
                this.fLeftLabel.setText(TextProcessor.process((String)leftLabel));
            }
        }
        if (this.fRightLabel != null) {
            String rightLabel;
            Image rightImage = content.getRightImage(input);
            if (rightImage != null) {
                this.fRightLabel.setImage(rightImage);
            }
            if ((rightLabel = content.getRightLabel(input)) != null) {
                this.fRightLabel.setText(TextProcessor.process((String)rightLabel));
            }
        }
    }

    int getHeaderHeight() {
        int headerHeight = this.fLeftLabel.computeSize((int)-1, (int)-1, (boolean)true).y;
        headerHeight = Math.max(headerHeight, this.fDirectionLabel.computeSize((int)-1, (int)-1, (boolean)true).y);
        return headerHeight;
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        if (this.fListenerList == null) {
            this.fListenerList = new ListenerList();
        }
        this.fListenerList.add((Object)listener);
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        if (this.fListenerList != null) {
            this.fListenerList.remove((Object)listener);
            if (this.fListenerList.isEmpty()) {
                this.fListenerList = null;
            }
        }
    }

    private void fireDirtyState(boolean state) {
        Utilities.firePropertyChange((ListenerList)this.fListenerList, (Object)((Object)this), (String)"DIRTY_STATE", null, (Object)new Boolean(state));
    }

    protected void setLeftDirty(boolean dirty) {
        if (this.isLeftDirty() != dirty) {
            this.fLeftSaveAction.setEnabled(dirty);
            if (!this.isRightDirty() && !this.isLeftDirty() || !this.isRightDirty() && this.isLeftDirty()) {
                this.fireDirtyState(dirty);
            }
        }
    }

    protected void setRightDirty(boolean dirty) {
        if (this.isRightDirty() != dirty) {
            this.fRightSaveAction.setEnabled(dirty);
            if (!this.isRightDirty() && !this.isLeftDirty() || this.isRightDirty() && !this.isLeftDirty()) {
                this.fireDirtyState(dirty);
            }
        }
    }

    public void save(IProgressMonitor monitor) throws CoreException {
        this.flush(monitor);
    }

    public final void flush(IProgressMonitor monitor) {
        this.flushContent(this.getInput(), monitor);
    }

    protected void flushContent(Object input, IProgressMonitor monitor) {
        byte[] bytes;
        boolean rightEmpty;
        IMergeViewerContentProvider content = (IMergeViewerContentProvider)this.getContentProvider();
        boolean leftEmpty = content.getLeftContent(input) == null;
        boolean bl = rightEmpty = content.getRightContent(input) == null;
        if (this.getCompareConfiguration().isLeftEditable() && this.isLeftDirty()) {
            bytes = this.getContents(true);
            if (rightEmpty && bytes != null && bytes.length == 0) {
                bytes = null;
            }
            this.setLeftDirty(false);
            content.saveLeftContent(input, bytes);
        }
        if (this.getCompareConfiguration().isRightEditable() && this.isRightDirty()) {
            bytes = this.getContents(false);
            if (leftEmpty && bytes != null && bytes.length == 0) {
                bytes = null;
            }
            this.setRightDirty(false);
            content.saveRightContent(input, bytes);
        }
    }

    protected boolean isRightDirty() {
        return this.fRightSaveAction.isEnabled();
    }

    protected boolean isLeftDirty() {
        return this.fLeftSaveAction.isEnabled();
    }

    protected void handleCompareInputChange() {
        Object input = this.getInput();
        if (this.isLeftDirty() || this.isRightDirty()) {
            if (Utilities.RUNNING_TESTS) {
                if (Utilities.TESTING_FLUSH_ON_COMPARE_INPUT_CHANGE) {
                    this.flushContent(input, null);
                }
            } else {
                Shell shell = this.fComposite.getShell();
                MessageDialog dialog = new MessageDialog(shell, "", null, "", 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0);
                switch (dialog.open()) {
                    case 0: {
                        this.flushContent(input, null);
                        break;
                    }
                    case 1: {
                        this.setLeftDirty(false);
                        this.setRightDirty(false);
                    }
                }
            }
        }
        this.refresh();
    }

    private class ContentMergeViewerLayout
    extends Layout {
        private ContentMergeViewerLayout() {
        }

        public Point computeSize(Composite c, int w, int h, boolean force) {
            return new Point(100, 100);
        }

        public void layout(Composite composite, boolean force) {
            int headerHeight = ((ContentMergeViewer)ContentMergeViewer.this).fLeftLabel.computeSize((int)-1, (int)-1, (boolean)true).y;
            Rectangle r = composite.getClientArea();
            int centerWidth = ContentMergeViewer.this.getCenterWidth();
            int width1 = (int)((double)(r.width - centerWidth) * this.getHorizontalSplitRatio());
            int width2 = r.width - width1 - centerWidth;
            int height1 = 0;
            int height2 = 0;
            if (ContentMergeViewer.this.fIsThreeWay && ContentMergeViewer.this.fAncestorVisible) {
                height1 = (int)((double)(r.height - 2 * headerHeight) * ContentMergeViewer.this.fVSplit);
                height2 = r.height - 2 * headerHeight - height1;
            } else {
                height1 = 0;
                height2 = r.height - headerHeight;
            }
            int y = 0;
            if (ContentMergeViewer.this.fIsThreeWay && ContentMergeViewer.this.fAncestorVisible) {
                ContentMergeViewer.this.fAncestorLabel.setBounds(0, y, r.width, headerHeight);
                ContentMergeViewer.this.fAncestorLabel.setVisible(true);
                ContentMergeViewer.this.handleResizeAncestor(0, y += headerHeight, r.width, height1);
                y += height1;
            } else {
                ContentMergeViewer.this.fAncestorLabel.setVisible(false);
                ContentMergeViewer.this.handleResizeAncestor(0, 0, 0, 0);
            }
            ContentMergeViewer.this.fLeftLabel.getSize();
            if (centerWidth > 3) {
                ContentMergeViewer.this.fLeftLabel.setBounds(0, y, width1 + 1, headerHeight);
                ContentMergeViewer.this.fDirectionLabel.setVisible(true);
                ContentMergeViewer.this.fDirectionLabel.setBounds(width1 + 1, y, centerWidth - 1, headerHeight);
                ContentMergeViewer.this.fRightLabel.setBounds(width1 + centerWidth, y, width2, headerHeight);
            } else {
                ContentMergeViewer.this.fLeftLabel.setBounds(0, y, width1, headerHeight);
                ContentMergeViewer.this.fDirectionLabel.setVisible(false);
                ContentMergeViewer.this.fRightLabel.setBounds(width1, y, r.width - width1, headerHeight);
            }
            y += headerHeight;
            if (ContentMergeViewer.this.fCenter != null && !ContentMergeViewer.this.fCenter.isDisposed()) {
                ContentMergeViewer.this.fCenter.setBounds(width1, y, centerWidth, height2);
            }
            ContentMergeViewer.this.handleResizeLeftRight(0, y, width1, centerWidth, width2, height2);
        }

        private double getHorizontalSplitRatio() {
            if (ContentMergeViewer.this.fHSplit < 0.0) {
                Object input = ContentMergeViewer.this.getInput();
                if (input instanceof ICompareInput) {
                    ICompareInput ci = (ICompareInput)input;
                    if (ci.getLeft() == null) {
                        return 0.1;
                    }
                    if (ci.getRight() == null) {
                        return 0.9;
                    }
                }
                return 0.5;
            }
            return ContentMergeViewer.this.fHSplit;
        }
    }

    class Resizer
    extends MouseAdapter
    implements MouseMoveListener {
        Control fControl;
        int fX;
        int fY;
        int fWidth1;
        int fWidth2;
        int fHeight1;
        int fHeight2;
        int fDirection;
        boolean fLiveResize;
        boolean fIsDown;

        public Resizer(Control c, int dir) {
            this.fDirection = dir;
            this.fControl = c;
            this.fLiveResize = !(this.fControl instanceof Sash);
            ContentMergeViewer.this.updateCursor(c, dir);
            this.fControl.addMouseListener((MouseListener)this);
            this.fControl.addMouseMoveListener((MouseMoveListener)this);
            this.fControl.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    Resizer.this.fControl = null;
                }
            });
        }

        public void mouseDoubleClick(MouseEvent e) {
            if ((this.fDirection & 1) != 0) {
                ContentMergeViewer.this.fHSplit = -1.0;
            }
            if ((this.fDirection & 2) != 0) {
                ContentMergeViewer.this.fVSplit = 0.3;
            }
            ContentMergeViewer.this.fComposite.layout(true);
        }

        public void mouseDown(MouseEvent e) {
            Composite parent = this.fControl.getParent();
            Point s = parent.getSize();
            Point as = ContentMergeViewer.this.fAncestorLabel.getSize();
            Point ys = ContentMergeViewer.this.fLeftLabel.getSize();
            Point ms = ContentMergeViewer.this.fRightLabel.getSize();
            this.fWidth1 = ys.x;
            this.fWidth2 = ms.x;
            this.fHeight1 = ((ContentMergeViewer)ContentMergeViewer.this).fLeftLabel.getLocation().y - as.y;
            this.fHeight2 = s.y - (((ContentMergeViewer)ContentMergeViewer.this).fLeftLabel.getLocation().y + ys.y);
            this.fX = e.x;
            this.fY = e.y;
            this.fIsDown = true;
        }

        public void mouseUp(MouseEvent e) {
            this.fIsDown = false;
            if (!this.fLiveResize) {
                this.resize(e);
            }
        }

        public void mouseMove(MouseEvent e) {
            if (this.fIsDown && this.fLiveResize) {
                this.resize(e);
            }
        }

        private void resize(MouseEvent e) {
            int dx = e.x - this.fX;
            int dy = e.y - this.fY;
            int centerWidth = ContentMergeViewer.this.fCenter.getSize().x;
            if (this.fWidth1 + dx > centerWidth && this.fWidth2 - dx > centerWidth) {
                this.fWidth1 += dx;
                this.fWidth2 -= dx;
                if ((this.fDirection & 1) != 0) {
                    ContentMergeViewer.this.fHSplit = (double)this.fWidth1 / (double)(this.fWidth1 + this.fWidth2);
                }
            }
            if (this.fHeight1 + dy > centerWidth && this.fHeight2 - dy > centerWidth) {
                this.fHeight1 += dy;
                this.fHeight2 -= dy;
                if ((this.fDirection & 2) != 0) {
                    ContentMergeViewer.this.fVSplit = (double)this.fHeight1 / (double)(this.fHeight1 + this.fHeight2);
                }
            }
            ContentMergeViewer.this.fComposite.layout(true);
            this.fControl.getDisplay().update();
        }
    }

    class SaveAction
    extends MergeViewerAction {
        SaveAction(boolean left) {
            super(true, false, false);
            this.setText(PHPUIMessages.ContentMergeViewer_0);
            this.setToolTipText(PHPUIMessages.ContentMergeViewer_1);
            this.setDescription(PHPUIMessages.ContentMergeViewer_2);
        }

        public void run() {
            ContentMergeViewer.this.flush(null);
        }
    }
}

