/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor.highlighters;

import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.Expression;
import org.eclipse.php.internal.core.ast.nodes.FieldAccess;
import org.eclipse.php.internal.core.ast.nodes.FunctionInvocation;
import org.eclipse.php.internal.core.ast.nodes.Program;
import org.eclipse.php.internal.core.ast.nodes.SingleFieldDeclaration;
import org.eclipse.php.internal.core.ast.nodes.Variable;
import org.eclipse.php.internal.core.ast.visitor.Visitor;
import org.eclipse.php.internal.ui.editor.highlighter.AbstractSemanticApply;
import org.eclipse.php.internal.ui.editor.highlighter.AbstractSemanticHighlighting;

public class FieldHighlighting
extends AbstractSemanticHighlighting {
    public AbstractSemanticApply getSemanticApply() {
        return new FielApply();
    }

    public void initDefaultPreferences() {
        this.getStyle().setDefaultTextColor(0, 0, 192);
    }

    public String getDisplayName() {
        return "Fields";
    }

    protected class FielApply
    extends AbstractSemanticApply {
        private int visitField = 0;

        protected FielApply() {
        }

        public boolean visit(SingleFieldDeclaration fieldDecl) {
            FieldHighlighting.this.highlight((ASTNode)fieldDecl.getName());
            return true;
        }

        public boolean visit(FunctionInvocation method) {
            boolean visit;
            boolean bl = visit = this.visitField <= 0;
            if (!visit) {
                for (Expression parameter : method.parameters()) {
                    parameter.accept((Visitor)this);
                }
            }
            return visit;
        }

        public boolean visit(FieldAccess fieldAccess) {
            ++this.visitField;
            return true;
        }

        public boolean visit(Variable var) {
            if (this.visitField > 0 && !var.isDollared()) {
                FieldHighlighting.this.highlight((ASTNode)var);
            }
            return true;
        }

        public void endVisit(FieldAccess fieldAccess) {
            --this.visitField;
        }

        public void endVisit(Program program) {
            if (this.visitField < 0) {
                throw new IllegalStateException("visitField is negative: " + this.visitField);
            }
        }
    }
}

