/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor.highlighters;

import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.Identifier;
import org.eclipse.php.internal.core.ast.nodes.MethodDeclaration;
import org.eclipse.php.internal.core.ast.nodes.MethodInvocation;
import org.eclipse.php.internal.core.ast.nodes.Variable;
import org.eclipse.php.internal.ui.editor.highlighter.AbstractSemanticApply;
import org.eclipse.php.internal.ui.editor.highlighter.AbstractSemanticHighlighting;

public class MethodHighlighting
extends AbstractSemanticHighlighting {
    public AbstractSemanticApply getSemanticApply() {
        return new MethodApply();
    }

    public void initDefaultPreferences() {
        this.getStyle().setEnabledByDefault(false);
    }

    public String getDisplayName() {
        return "Methods";
    }

    protected class MethodApply
    extends AbstractSemanticApply {
        protected MethodApply() {
        }

        public boolean visit(MethodDeclaration classMethodDeclaration) {
            Identifier functionName = classMethodDeclaration.getFunction().getFunctionName();
            MethodHighlighting.this.highlight((ASTNode)functionName);
            return true;
        }

        public boolean visit(MethodInvocation methodInvocation) {
            this.checkDispatch((ASTNode)methodInvocation.getMethod().getFunctionName().getName());
            return true;
        }

        private void checkDispatch(ASTNode node) {
            if (node.getType() == 33) {
                MethodHighlighting.this.highlight(node);
            }
            if (node.getType() == 60) {
                Variable id = (Variable)node;
                this.checkDispatch((ASTNode)id.getName());
            }
        }
    }
}

