/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.codeassist.contexts;

import java.util.List;
import java.util.Stack;
import java.util.StringTokenizer;
import org.eclipse.dltk.core.CompletionRequestor;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.php.internal.core.codeassist.contexts.NamespacePHPDocTagContext;
import org.eclipse.php.internal.core.documentModel.parser.regions.IPhpScriptRegion;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;
import org.eclipse.php.internal.core.util.text.PHPTextSequenceUtilities;
import org.eclipse.php.internal.core.util.text.TextSequence;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NamespaceAbstractPHPDocTagStartContext
extends NamespacePHPDocTagContext {
    private IType[] namespaces;
    private boolean isGlobal;

    @Override
    public boolean isValid(ISourceModule sourceModule, int offset, CompletionRequestor requestor) {
        String lastWord;
        if (!super.isValid(sourceModule, offset, requestor)) {
            return false;
        }
        String tagName = this.getTagName();
        if (!this.getTags().contains(tagName)) {
            return false;
        }
        TextSequence statementText = this.getStatementText();
        String statementTextString = statementText.toString();
        StringTokenizer st = new StringTokenizer(statementTextString);
        Stack<String> stack = new Stack<String>();
        while (st.hasMoreElements()) {
            stack.add((String)st.nextElement());
        }
        if (!stack.empty() && (lastWord = (String)stack.pop()).indexOf(92) >= 0 && !stack.empty() && this.isPrefix(lastWord)) {
            block8: {
                if (lastWord.startsWith("\\") && lastWord.lastIndexOf(92) == 0) {
                    this.isGlobal = true;
                } else {
                    String nsName = lastWord;
                    nsName = nsName.substring(0, nsName.lastIndexOf(92) + 1);
                    try {
                        this.namespaces = PHPModelUtils.getNamespaceOf(nsName, sourceModule, offset, null, null);
                    }
                    catch (ModelException e) {
                        if (!DLTKCore.DEBUG) break block8;
                        e.printStackTrace();
                    }
                }
            }
            lastWord = (String)stack.pop();
            return lastWord.endsWith(tagName);
        }
        return false;
    }

    public IType[] getNamespaces() {
        return this.namespaces;
    }

    public boolean isGlobal() {
        return this.isGlobal;
    }

    protected abstract List<String> getTags();

    private boolean isPrefix(String lastWord) {
        return this.getPrefixWithoutProcessing().endsWith(lastWord);
    }

    @Override
    public String getPrefix() throws BadLocationException {
        if (this.hasWhitespaceBeforeCursor()) {
            return "";
        }
        TextSequence statementText = this.getStatementText();
        int statementLength = statementText.length();
        int prefixEnd = PHPTextSequenceUtilities.readBackwardSpaces(statementText, statementLength);
        int prefixStart = PHPTextSequenceUtilities.readIdentifierStartIndex(statementText, prefixEnd, true);
        return statementText.subSequence(prefixStart, prefixEnd).toString();
    }

    @Override
    public int getPrefixEnd() throws BadLocationException {
        ITextRegion phpToken = this.getPHPToken();
        if (phpToken.getType() == "PHP_NS_SEPARATOR") {
            IPhpScriptRegion phpScriptRegion = this.getPhpScriptRegion();
            ITextRegion nextRegion = phpScriptRegion.getPhpToken(phpToken.getEnd());
            return this.getRegionCollection().getStartOffset() + phpScriptRegion.getStart() + nextRegion.getTextEnd();
        }
        return super.getPrefixEnd();
    }
}

