/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.preferences.includepath;

import org.eclipse.core.resources.IResource;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.internal.ui.wizards.buildpath.BPListElement;
import org.eclipse.dltk.internal.ui.wizards.buildpath.BPListLabelProvider;
import org.eclipse.dltk.ui.DLTKPluginImages;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.ScriptElementImageDescriptor;
import org.eclipse.dltk.ui.ScriptElementImageProvider;
import org.eclipse.dltk.ui.viewsupport.ImageDescriptorRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.php.internal.ui.phar.wizard.PharUIUtil;
import org.eclipse.php.internal.ui.preferences.includepath.IncludePathMessages;
import org.eclipse.php.internal.ui.util.LabelProviderUtil;
import org.eclipse.php.internal.ui.util.PHPPluginImages;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

public class PHPIPListLabelProvider
extends BPListLabelProvider {
    private String fInvalidLabel = IncludePathMessages.CPListLabelProvider_invalid;
    private ImageDescriptorRegistry fRegistry = DLTKUIPlugin.getImageDescriptorRegistry();

    protected ImageDescriptor getCPListElementBaseImage(BPListElement cpentry) {
        ImageDescriptor folderBaseImage;
        if (cpentry.getEntryKind() == 1) {
            return DLTKPluginImages.getDescriptor((String)"org.eclipse.dltk.ui.library_obj.gif");
        }
        if (cpentry.getEntryKind() == 3 && (folderBaseImage = PHPIPListLabelProvider.getFolderBaseImage(cpentry.getResource())) != null) {
            return folderBaseImage;
        }
        return super.getCPListElementBaseImage(cpentry);
    }

    public Image getImage(Object element) {
        BPListElement cpentry;
        ImageDescriptor imageDescriptor;
        if (element instanceof BPListElement && (imageDescriptor = this.getCPListElementBaseImage(cpentry = (BPListElement)element)) != null) {
            if (PharUIUtil.isInvalidPharBuildEntry(cpentry)) {
                imageDescriptor = new ScriptElementImageDescriptor(imageDescriptor, 64, ScriptElementImageProvider.SMALL_SIZE);
            }
            return this.fRegistry.get(imageDescriptor);
        }
        return super.getImage(element);
    }

    public String getCPListElementText(BPListElement cpentry) {
        String result = LabelProviderUtil.getVariableName(cpentry.getPath(), cpentry.getEntryKind());
        if (result == null) {
            result = super.getCPListElementText(cpentry);
        }
        if (PharUIUtil.isInvalidPharBuildEntry(cpentry)) {
            result = String.valueOf(result) + this.fInvalidLabel;
        }
        return result;
    }

    private static ImageDescriptor getFolderBaseImage(IResource resource) {
        IModelElement modelElement = DLTKCore.create((IResource)resource);
        if (modelElement != null) {
            if (modelElement instanceof IScriptFolder) {
                return PHPPluginImages.DESC_OBJS_PHPFOLDER_ROOT;
            }
        } else {
            return PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FOLDER");
        }
        return null;
    }
}

