/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.tests.performance.markoccurrence;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.php.core.tests.AbstractPDTTTest;
import org.eclipse.php.core.tests.PHPCoreTests;
import org.eclipse.php.core.tests.PdttFile;
import org.eclipse.php.core.tests.performance.PHPCorePerformanceTests;
import org.eclipse.php.core.tests.performance.PerformanceMonitor;
import org.eclipse.php.core.tests.performance.Util;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.core.ast.locator.PhpElementConciliator;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.Identifier;
import org.eclipse.php.internal.core.ast.nodes.Program;
import org.eclipse.php.internal.core.corext.dom.NodeFinder;
import org.eclipse.php.internal.core.search.IOccurrencesFinder;
import org.eclipse.php.internal.core.search.OccurrencesFinderFactory;
import org.osgi.framework.Bundle;

public class MarkOccurrenceTestsWrapper
extends AbstractPDTTTest {
    protected static final char OFFSET_CHAR = '|';
    protected static final Map<PHPVersion, String[]> TESTS = new LinkedHashMap<PHPVersion, String[]>();
    protected IFile testFile;
    protected IProject project;
    private PerformanceMonitor perfMonitor;

    static {
        TESTS.put(PHPVersion.PHP5, new String[]{"/workspace/project/markoccurrence/php5"});
        TESTS.put(PHPVersion.PHP5_3, new String[]{"/workspace/project/markoccurrence/php53"});
    }

    public MarkOccurrenceTestsWrapper() {
        super("");
    }

    public Test suite(Map map) {
        this.project = ResourcesPlugin.getWorkspace().getRoot().getProject(map.get("project").toString());
        this.perfMonitor = PHPCorePerformanceTests.getPerformanceMonitor();
        TestSuite suite = new TestSuite("Auto Mark Occurrence Tests");
        final PHPVersion phpVersion = (PHPVersion)map.get("phpVersion");
        String[] stringArray = TESTS.get(phpVersion);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String testsDirectory = stringArray[n2];
            testsDirectory = testsDirectory.replaceAll("project", map.get("project").toString());
            String[] stringArray2 = MarkOccurrenceTestsWrapper.getPDTTFiles((String)testsDirectory, (Bundle)PHPCorePerformanceTests.getDefault().getBundle());
            int n3 = stringArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                final String fileName = stringArray2[n4];
                try {
                    final PdttFile pdttFile = new PdttFile(PHPCorePerformanceTests.getDefault().getBundle(), fileName);
                    MarkOccurrenceTests test = new MarkOccurrenceTests(String.valueOf(phpVersion.getAlias()) + " - /" + fileName){

                        protected void setUp() throws Exception {
                            PHPCoreTests.setProjectPhpVersion((IProject)MarkOccurrenceTestsWrapper.this.project, (PHPVersion)phpVersion);
                            pdttFile.applyPreferences();
                        }

                        protected void tearDown() throws Exception {
                            if (MarkOccurrenceTestsWrapper.this.testFile != null) {
                                MarkOccurrenceTestsWrapper.this.testFile.delete(true, null);
                                MarkOccurrenceTestsWrapper.this.testFile = null;
                            }
                        }

                        protected void runTest() throws Throwable {
                            MarkOccurrenceTestsWrapper.this.runMarkOccurrence(pdttFile.getFile(), fileName);
                        }
                    };
                    suite.addTest((Test)test);
                }
                catch (Exception e) {
                    suite.addTest((Test)new TestCase(fileName){

                        protected void runTest() throws Throwable {
                            throw e;
                        }
                    });
                }
                ++n4;
            }
            ++n2;
        }
        return suite;
    }

    protected void runMarkOccurrence(String data, String fileName) throws Exception {
        IOccurrencesFinder finder;
        int type;
        int offset = data.lastIndexOf(124);
        if (offset == -1) {
            throw new IllegalArgumentException("Offset character is not set");
        }
        ArrayList<Integer> starts = new ArrayList<Integer>();
        int startIndex = -1;
        while ((startIndex = data.indexOf(37, startIndex + 1)) >= 0) {
            starts.add(startIndex);
        }
        if (starts.size() % 2 != 0) {
            throw new IllegalArgumentException("% must be paired");
        }
        ArrayList<Integer> newStarts = new ArrayList<Integer>();
        int i = 0;
        while (i < starts.size()) {
            int oldstart = (Integer)starts.get(i) - i;
            if (oldstart > offset) {
                --oldstart;
            }
            newStarts.add(oldstart);
            ++i;
        }
        data = data.replaceAll("%", "");
        offset = data.lastIndexOf(124);
        data = String.valueOf(data.substring(0, offset)) + data.substring(offset + 1);
        this.testFile = this.project.getFile("pdttest/test.php");
        this.testFile.create((InputStream)new ByteArrayInputStream(data.getBytes()), true, null);
        this.project.refreshLocal(1, null);
        this.project.build(10, null);
        PHPCoreTests.waitForIndexer();
        Program astRoot = Util.createProgramFromSource(this.testFile);
        ASTNode selectedNode = NodeFinder.perform((ASTNode)astRoot, (int)offset, (int)0);
        if (selectedNode != null && (selectedNode instanceof Identifier || MarkOccurrenceTestsWrapper.isScalarButNotInString(selectedNode)) && MarkOccurrenceTestsWrapper.markOccurrencesOfType(type = PhpElementConciliator.concile((ASTNode)selectedNode)) && (finder = OccurrencesFinderFactory.getOccurrencesFinder((int)type)) != null && finder.initialize(astRoot, selectedNode) == null) {
            this.perfMonitor.execute("PerformanceTests.testMarkOccurrence_" + fileName, new PerformanceMonitor.Operation(){

                public void run() throws Exception {
                    finder.getOccurrences();
                }
            }, 1, 10);
        }
    }

    public static boolean markOccurrencesOfType(int type) {
        switch (type) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return true;
            }
        }
        return false;
    }

    public static boolean isScalarButNotInString(ASTNode node) {
        return node.getType() == 51 && node.getParent().getType() != 47;
    }

    public class MarkOccurrenceTests
    extends AbstractPDTTTest {
        public MarkOccurrenceTests(String description) {
            super(description);
        }
    }
}

