/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.tests.model_structure;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.LinkedHashMap;
import java.util.Map;
import junit.extensions.TestSetup;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModelElementVisitor;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.php.core.tests.AbstractPDTTTest;
import org.eclipse.php.core.tests.PHPCoreTests;
import org.eclipse.php.core.tests.PdttFile;
import org.eclipse.php.internal.core.PHPVersion;

public class ModelStructureTests
extends AbstractPDTTTest {
    protected static final Map<PHPVersion, String[]> TESTS = new LinkedHashMap<PHPVersion, String[]>();
    protected static IProject project;
    protected static IFile testFile;

    static {
        TESTS.put(PHPVersion.PHP5_3, new String[]{"/workspace/model_structure/php53"});
        TESTS.put(PHPVersion.PHP5_4, new String[]{"/workspace/model_structure/php53"});
    }

    public static void setUpSuite() throws Exception {
        project = ResourcesPlugin.getWorkspace().getRoot().getProject("ModelStructureTests");
        if (project.exists()) {
            return;
        }
        project.create(null);
        project.open(null);
        IProjectDescription desc = project.getDescription();
        desc.setNatureIds(new String[]{"org.eclipse.php.core.PHPNature"});
        project.setDescription(desc, null);
    }

    public static void tearDownSuite() throws Exception {
        project.close(null);
        project.delete(true, true, null);
        project = null;
    }

    public ModelStructureTests(String description) {
        super(description);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("Auto Code Assist Tests");
        for (final PHPVersion phpVersion : TESTS.keySet()) {
            TestSuite phpVerSuite = new TestSuite(phpVersion.getAlias());
            String[] stringArray = TESTS.get(phpVersion);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String testsDirectory = stringArray[n2];
                String[] stringArray2 = ModelStructureTests.getPDTTFiles(testsDirectory);
                int n3 = stringArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    String fileName = stringArray2[n4];
                    try {
                        final PdttFile pdttFile = new PdttFile(fileName);
                        phpVerSuite.addTest((Test)new ModelStructureTests(String.valueOf(phpVersion.getAlias()) + " - /" + fileName){

                            protected void setUp() throws Exception {
                                PHPCoreTests.setProjectPhpVersion(project, phpVersion);
                            }

                            protected void tearDown() throws Exception {
                                if (testFile != null) {
                                    testFile.delete(true, null);
                                    testFile = null;
                                }
                            }

                            protected void runTest() throws Throwable {
                                ISourceModule sourceModule = 1.createFile(pdttFile.getFile());
                                ByteArrayOutputStream stream = new ByteArrayOutputStream();
                                PrintStream printStream = new PrintStream(stream);
                                sourceModule.accept((IModelElementVisitor)new PrintVisitor(printStream));
                                printStream.close();
                                this.assertContents(pdttFile.getExpected(), stream.toString());
                            }
                        });
                    }
                    catch (Exception e) {
                        phpVerSuite.addTest((Test)new TestCase(fileName){

                            protected void runTest() throws Throwable {
                                throw e;
                            }
                        });
                    }
                    ++n4;
                }
                ++n2;
            }
            suite.addTest((Test)phpVerSuite);
        }
        TestSetup setup = new TestSetup((Test)suite){

            protected void setUp() throws Exception {
                ModelStructureTests.setUpSuite();
            }

            protected void tearDown() throws Exception {
                ModelStructureTests.tearDownSuite();
            }
        };
        return setup;
    }

    protected static ISourceModule createFile(String data) throws Exception {
        testFile = project.getFile("test.php");
        testFile.create((InputStream)new ByteArrayInputStream(data.getBytes()), true, null);
        project.refreshLocal(2, null);
        project.build(6, null);
        PHPCoreTests.waitForIndexer();
        PHPCoreTests.waitForAutoBuild();
        return DLTKCore.createSourceModuleFrom((IFile)testFile);
    }

    class PrintVisitor
    implements IModelElementVisitor {
        private PrintStream stream;

        public PrintVisitor(PrintStream stream) {
            this.stream = stream;
        }

        public boolean visit(IModelElement element) {
            try {
                String tabs = this.getTabs(element);
                this.stream.print(tabs);
                if (element.getElementType() == 7) {
                    IType type = (IType)element;
                    int flags = type.getFlags();
                    if ((flags & 8) != 0) {
                        this.stream.print("INTERFACE: ");
                    } else if ((flags & 0x800) != 0) {
                        this.stream.print("NAMESPACE: ");
                    } else {
                        this.stream.print("CLASS: ");
                    }
                } else if (element.getElementType() == 9) {
                    IMethod method = (IMethod)element;
                    IType declaringType = method.getDeclaringType();
                    if (declaringType == null || (declaringType.getFlags() & 0x800) != 0) {
                        this.stream.print("FUNCTION: ");
                    } else {
                        this.stream.print("METHOD: ");
                    }
                } else if (element.getElementType() == 8) {
                    this.stream.print("VARIABLE: ");
                } else if (element.getElementType() == 5) {
                    this.stream.print("FILE: ");
                }
                this.stream.println(element.getElementName());
            }
            catch (ModelException modelException) {}
            return true;
        }

        protected String getTabs(IModelElement e) {
            StringBuilder buf = new StringBuilder();
            while (e.getElementType() != 5) {
                buf.append('\t');
                e = e.getParent();
            }
            return buf.toString();
        }
    }
}

