/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.pathmapper;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IBuildpathContainer;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.environment.EnvironmentManager;
import org.eclipse.dltk.core.environment.EnvironmentPathUtils;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.documentModel.provisional.contenttype.ContentTypeIdForPHP;
import org.eclipse.php.internal.core.includepath.IncludePath;
import org.eclipse.php.internal.core.util.PHPSearchEngine;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;
import org.eclipse.php.internal.debug.core.pathmapper.BestMatchPathComparator;
import org.eclipse.php.internal.debug.core.pathmapper.IPathEntryFilter;
import org.eclipse.php.internal.debug.core.pathmapper.Messages;
import org.eclipse.php.internal.debug.core.pathmapper.PathEntry;
import org.eclipse.php.internal.debug.core.pathmapper.PathMapper;
import org.eclipse.php.internal.debug.core.pathmapper.PathMapperRegistry;
import org.eclipse.php.internal.debug.core.pathmapper.VirtualPath;
import org.eclipse.php.internal.debug.core.zend.model.PHPDebugTarget;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.FileStoreEditorInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DebugSearchEngine {
    private static PHPFilenameFilter PHP_FILTER = new PHPFilenameFilter();
    private static IPathEntryFilter[] filters;

    public static PathEntry find(String remoteFile, IDebugTarget debugTarget) {
        return DebugSearchEngine.find(remoteFile, debugTarget, null, null);
    }

    public static PathEntry find(String remoteFile, IDebugTarget debugTarget, String currentWorkingDir, String currentScriptDir) {
        IResource resource;
        if (remoteFile == null) {
            throw new NullPointerException();
        }
        PathEntry pathEntry = null;
        ILaunchConfiguration launchConfiguration = debugTarget.getLaunch().getLaunchConfiguration();
        IProject project = null;
        if (currentScriptDir != null && (resource = ResourcesPlugin.getWorkspace().getRoot().findMember(currentScriptDir)) != null) {
            project = resource.getProject();
        }
        if (project == null && debugTarget instanceof PHPDebugTarget) {
            project = ((PHPDebugTarget)debugTarget).getProject();
        }
        if (project == null) {
            try {
                String projectName = launchConfiguration.getAttribute("org.eclipse.php.debug.core.PHP_Project", null);
                if (projectName != null) {
                    project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                }
            }
            catch (CoreException e) {
                PHPDebugPlugin.log(e);
            }
        }
        if (!VirtualPath.isAbsolute(remoteFile)) {
            if (project != null && currentWorkingDir != null && currentScriptDir != null) {
                PHPSearchEngine.Result result = PHPSearchEngine.find((String)remoteFile, (String)currentWorkingDir, (String)currentScriptDir, (IProject)project);
                if (result instanceof PHPSearchEngine.ExternalFileResult) {
                    PHPSearchEngine.ExternalFileResult extFileResult = (PHPSearchEngine.ExternalFileResult)result;
                    return new PathEntry(((File)extFileResult.getFile()).getAbsolutePath(), PathEntry.Type.EXTERNAL, extFileResult.getContainer());
                }
                if (result instanceof PHPSearchEngine.IncludedFileResult) {
                    PHPSearchEngine.IncludedFileResult incFileResult = (PHPSearchEngine.IncludedFileResult)result;
                    IBuildpathEntry container = (IBuildpathEntry)incFileResult.getContainer();
                    PathEntry.Type type = container.getEntryKind() == 4 ? PathEntry.Type.INCLUDE_VAR : PathEntry.Type.INCLUDE_FOLDER;
                    return new PathEntry(((File)incFileResult.getFile()).getAbsolutePath(), type, (Object)container);
                }
                if (result != null) {
                    PHPSearchEngine.ResourceResult resResult = (PHPSearchEngine.ResourceResult)result;
                    IResource resource2 = (IResource)resResult.getFile();
                    return new PathEntry(resource2.getFullPath().toString(), PathEntry.Type.WORKSPACE, (Object)resource2.getParent());
                }
            }
            return null;
        }
        PathMapper pathMapper = PathMapperRegistry.getByLaunchConfiguration(launchConfiguration);
        if (pathMapper != null) {
            pathEntry = DebugSearchEngine.find(pathMapper, remoteFile, project, debugTarget);
        }
        return pathEntry;
    }

    public static PathEntry find(final PathMapper pathMapper, final String remoteFile, final IProject currentProject, final IDebugTarget debugTarget) {
        final PathEntry[] localFile = new PathEntry[1];
        Job findJob = new Job(Messages.DebugSearchEngine_0){

            protected IStatus run(IProgressMonitor monitor) {
                File file;
                int n;
                localFile[0] = pathMapper.getLocalFile(remoteFile);
                if (localFile[0] != null) {
                    if (localFile[0].getType() == PathEntry.Type.SERVER) {
                        localFile[0] = null;
                    }
                    return Status.OK_STATUS;
                }
                localFile[0] = pathMapper.getServerFile(remoteFile);
                if (localFile[0] != null) {
                    localFile[0] = null;
                    return Status.OK_STATUS;
                }
                VirtualPath abstractPath = new VirtualPath(remoteFile);
                VirtualPath testPath = abstractPath.clone();
                testPath.removeLastSegment();
                if (pathMapper.getLocalPathMapping(testPath) != null) {
                    return Status.OK_STATUS;
                }
                LinkedList results = new LinkedList();
                IBuildpathEntry[] buildPaths = null;
                LinkedHashSet s = new LinkedHashSet();
                LinkedHashSet<IBuildpathEntry> b = new LinkedHashSet<IBuildpathEntry>();
                IProject[] projects = null;
                projects = currentProject != null && currentProject.isOpen() ? new IProject[]{currentProject} : ResourcesPlugin.getWorkspace().getRoot().getProjects();
                IProject[] iProjectArray = projects;
                int n2 = projects.length;
                int n3 = 0;
                while (n3 < n2) {
                    IProject project = iProjectArray[n3];
                    if (project.isOpen() && project.isAccessible()) {
                        PHPSearchEngine.buildIncludePath((IProject)project, s);
                        IScriptProject scriptProject = DLTKCore.create((IProject)project);
                        if (scriptProject != null && scriptProject.isOpen()) {
                            try {
                                IBuildpathEntry[] rawBuildpath;
                                IBuildpathEntry[] iBuildpathEntryArray = rawBuildpath = scriptProject.getRawBuildpath();
                                int n4 = rawBuildpath.length;
                                n = 0;
                                while (n < n4) {
                                    IBuildpathEntry pathEntry = iBuildpathEntryArray[n];
                                    b.add(pathEntry);
                                    ++n;
                                }
                            }
                            catch (ModelException e) {
                                PHPDebugPlugin.log(e);
                            }
                        }
                    }
                    ++n3;
                }
                IncludePath[] includePaths = s.toArray(new IncludePath[s.size()]);
                buildPaths = b.toArray(new IBuildpathEntry[b.size()]);
                try {
                    IPath path = Path.fromOSString((String)remoteFile);
                    IFile file2 = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(path);
                    if (file2 != null && file2.exists()) {
                        IncludePath[] e = includePaths;
                        int scriptProject = includePaths.length;
                        int n5 = 0;
                        while (n5 < scriptProject) {
                            IContainer container;
                            IncludePath includePath = e[n5];
                            if (includePath.getEntry() instanceof IContainer && (container = (IContainer)includePath.getEntry()).getFullPath().isPrefixOf(file2.getFullPath())) {
                                localFile[0] = new PathEntry(file2.getFullPath().toString(), PathEntry.Type.WORKSPACE, (Object)file2.getParent());
                                pathMapper.addEntry(remoteFile, localFile[0]);
                                PathMapperRegistry.storeToPreferences();
                                return Status.OK_STATUS;
                            }
                            ++n5;
                        }
                    }
                }
                catch (Exception exception) {}
                if ((file = new File(remoteFile)).exists()) {
                    IBuildpathEntry entry;
                    try {
                        IScriptProject scriptProject = DLTKCore.create((IProject)currentProject);
                        if (currentProject != null && scriptProject != null) {
                            IBuildpathEntry[] rawBuildpath = scriptProject.getRawBuildpath();
                            IEnvironment environment = EnvironmentManager.getEnvironment((IProject)currentProject);
                            IPath remoteFilePath = EnvironmentPathUtils.getFullPath((IEnvironment)environment, (IPath)new Path(remoteFile));
                            IBuildpathEntry[] iBuildpathEntryArray = rawBuildpath;
                            n = rawBuildpath.length;
                            int container = 0;
                            while (container < n) {
                                entry = iBuildpathEntryArray[container];
                                IPath entryPath = entry.getPath();
                                if (entry.getEntryKind() == 4) {
                                    entryPath = DLTKCore.getResolvedVariablePath((IPath)entryPath);
                                }
                                if (entryPath != null && (entryPath.isPrefixOf(Path.fromOSString((String)remoteFile)) || entryPath.isPrefixOf(remoteFilePath))) {
                                    PathEntry.Type type = entry.getEntryKind() == 4 ? PathEntry.Type.INCLUDE_VAR : PathEntry.Type.INCLUDE_FOLDER;
                                    localFile[0] = new PathEntry(file.getAbsolutePath(), type, (Object)entry);
                                    return Status.OK_STATUS;
                                }
                                ++container;
                            }
                        }
                    }
                    catch (Exception e) {
                        PHPDebugPlugin.log(e);
                    }
                    IncludePath[] includePathArray = includePaths;
                    int n6 = includePaths.length;
                    int n7 = 0;
                    while (n7 < n6) {
                        IncludePath includePath = includePathArray[n7];
                        if (includePath.getEntry() instanceof IBuildpathEntry) {
                            entry = (IBuildpathEntry)includePath.getEntry();
                            IPath entryPath = entry.getPath();
                            if (entry.getEntryKind() == 4) {
                                entryPath = DLTKCore.getResolvedVariablePath((IPath)entryPath);
                            }
                            if (entryPath != null && entryPath.isPrefixOf(Path.fromOSString((String)remoteFile))) {
                                PathEntry.Type type = entry.getEntryKind() == 4 ? PathEntry.Type.INCLUDE_VAR : PathEntry.Type.INCLUDE_FOLDER;
                                localFile[0] = new PathEntry(file.getAbsolutePath(), type, (Object)entry);
                                pathMapper.addEntry(remoteFile, localFile[0]);
                                PathMapperRegistry.storeToPreferences();
                                return Status.OK_STATUS;
                            }
                        }
                        ++n7;
                    }
                }
                if (buildPaths != null) {
                    IBuildpathEntry[] iBuildpathEntryArray = buildPaths;
                    int n8 = buildPaths.length;
                    int n9 = 0;
                    while (n9 < n8) {
                        IBuildpathEntry entry = iBuildpathEntryArray[n9];
                        IPath entryPath = entry.getPath();
                        if (entry.getEntryKind() == 1) {
                            File entryDir = entryPath.toFile();
                            DebugSearchEngine.find(entryDir, abstractPath, entry, results);
                        } else if (entry.getEntryKind() == 2 || entry.getEntryKind() == 3) {
                            IProject project;
                            IResource res = ResourcesPlugin.getWorkspace().getRoot().findMember(entry.getPath().lastSegment());
                            if (res instanceof IProject && (project = (IProject)res).isOpen() && project.isAccessible()) {
                                try {
                                    DebugSearchEngine.find((IResource)project, abstractPath, results);
                                }
                                catch (InterruptedException e) {
                                    PHPDebugPlugin.log(e);
                                }
                            }
                        } else if (entry.getEntryKind() == 4) {
                            if ((entryPath = DLTKCore.getResolvedVariablePath((IPath)entryPath)) != null) {
                                File entryDir = entryPath.toFile();
                                DebugSearchEngine.find(entryDir, abstractPath, entry, results);
                            }
                        } else if (entry.getEntryKind() == 5) {
                            try {
                                if (projects.length != 0) {
                                    IBuildpathEntry[] buildpathEntries;
                                    IProject currentProject2 = projects[0];
                                    IScriptProject scriptProject = DLTKCore.create((IProject)currentProject2);
                                    IBuildpathContainer container = DLTKCore.getBuildpathContainer((IPath)entry.getPath(), (IScriptProject)scriptProject);
                                    if (container != null && (entryPath = EnvironmentPathUtils.getLocalPath((IPath)(buildpathEntries = container.getBuildpathEntries())[0].getPath())) != null) {
                                        DebugSearchEngine.find(entryPath.toFile(), abstractPath, entry, results);
                                    }
                                }
                            }
                            catch (ModelException e) {
                                PHPCorePlugin.log((Throwable)e);
                            }
                        }
                        ++n9;
                    }
                }
                IncludePath[] includePathArray = includePaths;
                int n10 = includePaths.length;
                int n11 = 0;
                while (n11 < n10) {
                    IncludePath includePath = includePathArray[n11];
                    if (includePath.getEntry() instanceof IContainer) {
                        try {
                            DebugSearchEngine.find((IResource)((IContainer)includePath.getEntry()), abstractPath, results);
                        }
                        catch (InterruptedException e) {
                            PHPDebugPlugin.log(e);
                        }
                    }
                    ++n11;
                }
                boolean foundInWorkspace = results.size() > 0;
                DebugSearchEngine.searchOpenedEditors(results, abstractPath);
                if (!foundInWorkspace && results.size() == 1 && abstractPath.equals(((PathEntry)results.getFirst()).getAbstractPath())) {
                    localFile[0] = (PathEntry)results.getFirst();
                } else if (results.size() > 0) {
                    Collections.sort(results, new BestMatchPathComparator(abstractPath));
                    localFile[0] = DebugSearchEngine.filterItems(abstractPath, results.toArray(new PathEntry[results.size()]), debugTarget);
                    if (localFile[0] != null) {
                        if (localFile[0].getType() == PathEntry.Type.SERVER) {
                            pathMapper.addServerEntry(remoteFile, localFile[0]);
                            PathMapperRegistry.storeToPreferences();
                            localFile[0] = null;
                        } else {
                            pathMapper.addEntry(remoteFile, localFile[0]);
                            PathMapperRegistry.storeToPreferences();
                        }
                    }
                }
                return Status.OK_STATUS;
            }
        };
        findJob.schedule();
        try {
            findJob.join();
        }
        catch (InterruptedException interruptedException) {}
        return localFile[0];
    }

    private static void searchOpenedEditors(LinkedList<PathEntry> results, VirtualPath remotePath) {
        IWorkbenchWindow[] windows;
        ArrayList<IEditorReference> editors = new ArrayList<IEditorReference>(0);
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow[] iWorkbenchWindowArray = windows = workbench.getWorkbenchWindows();
        int n = windows.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchPage[] pages;
            IWorkbenchWindow element = iWorkbenchWindowArray[n2];
            IWorkbenchPage[] iWorkbenchPageArray = pages = element.getPages();
            int n3 = pages.length;
            int n4 = 0;
            while (n4 < n3) {
                IWorkbenchPage element2 = iWorkbenchPageArray[n4];
                IEditorReference[] references = element2.getEditorReferences();
                editors.addAll(Arrays.asList(references));
                ++n4;
            }
            ++n2;
        }
        for (IEditorReference editor : editors) {
            File file;
            IEditorInput editorInput = null;
            try {
                editorInput = editor.getEditorInput();
            }
            catch (PartInitException partInitException) {
                continue;
            }
            if (!(editorInput instanceof FileStoreEditorInput) || !(file = new File(((IURIEditorInput)editorInput).getURI())).exists() || !file.getName().equalsIgnoreCase(remotePath.getLastSegment())) continue;
            results.add(new PathEntry(file.getAbsolutePath(), PathEntry.Type.EXTERNAL, (Object)file.getParentFile()));
        }
    }

    private static PathEntry filterItems(VirtualPath remotePath, PathEntry[] entries, IDebugTarget debugTarget) {
        IPathEntryFilter[] filters = DebugSearchEngine.initializePathEntryFilters();
        int i = 0;
        while (i < filters.length) {
            entries = filters[i].filter(entries, remotePath, debugTarget);
            ++i;
        }
        return entries.length > 0 ? entries[0] : null;
    }

    private static synchronized IPathEntryFilter[] initializePathEntryFilters() {
        if (filters == null) {
            IConfigurationElement[] elements;
            HashMap<String, IPathEntryFilter> filtersMap = new HashMap<String, IPathEntryFilter>();
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IConfigurationElement[] iConfigurationElementArray = elements = registry.getConfigurationElementsFor(PHPDebugPlugin.getID(), "pathEntryFilters");
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                String id;
                IConfigurationElement element = iConfigurationElementArray[n2];
                if ("filter".equals(element.getName()) && !filtersMap.containsKey(id = element.getAttribute("id"))) {
                    String overridesIds = element.getAttribute("overridesId");
                    if (overridesIds != null) {
                        StringTokenizer st = new StringTokenizer(overridesIds, ", ");
                        while (st.hasMoreTokens()) {
                            filtersMap.put(st.nextToken(), null);
                        }
                    }
                    try {
                        filtersMap.put(id, (IPathEntryFilter)element.createExecutableExtension("class"));
                    }
                    catch (CoreException e) {
                        PHPDebugPlugin.log(e);
                    }
                }
                ++n2;
            }
            Collection l = filtersMap.values();
            while (l.remove(null)) {
            }
            filters = l.toArray(new IPathEntryFilter[filtersMap.size()]);
        }
        return filters;
    }

    private static void find(File file, VirtualPath path, IBuildpathEntry container, List<PathEntry> results) {
        if (!file.isDirectory() && file.getName().equals(path.getLastSegment())) {
            PathEntry.Type type = container.getEntryKind() == 4 ? PathEntry.Type.INCLUDE_VAR : PathEntry.Type.INCLUDE_FOLDER;
            PathEntry pathEntry = new PathEntry(file.getAbsolutePath(), type, (Object)container);
            results.add(pathEntry);
            return;
        }
        File[] files = file.listFiles(PHP_FILTER);
        if (files != null) {
            int i = 0;
            while (i < files.length) {
                DebugSearchEngine.find(files[i], path, container, results);
                ++i;
            }
        }
    }

    private static void find(final IResource resource, final VirtualPath path, final List<PathEntry> results) throws InterruptedException {
        if (resource == null || !resource.exists() || !resource.isAccessible()) {
            return;
        }
        WorkspaceJob findJob = new WorkspaceJob(""){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                resource.accept(new IResourceVisitor(){

                    public boolean visit(IResource resource) throws CoreException {
                        if (!resource.isAccessible()) {
                            return false;
                        }
                        if (resource instanceof IFile && resource.getName().equals(path.getLastSegment())) {
                            PathEntry pathEntry = new PathEntry(resource.getFullPath().toString(), PathEntry.Type.WORKSPACE, (Object)resource.getParent());
                            results.add(pathEntry);
                        }
                        return true;
                    }
                });
                return Status.OK_STATUS;
            }
        };
        findJob.schedule();
        findJob.join();
    }

    private static class PHPFilenameFilter
    implements FileFilter,
    IContentTypeManager.IContentTypeChangeListener {
        private Pattern phpFilePattern;

        public PHPFilenameFilter() {
            this.buildPHPFilePattern();
            Platform.getContentTypeManager().addContentTypeChangeListener((IContentTypeManager.IContentTypeChangeListener)this);
        }

        private void buildPHPFilePattern() {
            IContentType type = Platform.getContentTypeManager().getContentType(ContentTypeIdForPHP.ContentTypeID_PHP);
            String[] phpExtensions = type.getFileSpecs(8);
            StringBuilder buf = new StringBuilder();
            buf.append(".*\\.(");
            int i = 0;
            while (i < phpExtensions.length) {
                if (i > 0) {
                    buf.append("|");
                }
                buf.append(phpExtensions[i]);
                ++i;
            }
            buf.append(')');
            this.phpFilePattern = Pattern.compile(buf.toString(), 2);
        }

        public void contentTypeChanged(IContentTypeManager.ContentTypeChangeEvent event) {
            this.buildPHPFilePattern();
        }

        public boolean accept(File pathname) {
            return pathname.isDirectory() || this.phpFilePattern.matcher(pathname.getName()).matches();
        }
    }
}

