/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.formatter.core.tests;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import junit.extensions.TestSetup;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.dltk.compiler.problem.IProblem;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IProblemRequestor;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ScriptModelUtil;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.php.core.tests.PHPCoreTests;
import org.eclipse.php.core.tests.PdttFile;
import org.eclipse.php.formatter.core.tests.Activator;
import org.eclipse.php.formatter.core.tests.FormatterTests;
import org.eclipse.php.formatter.ui.preferences.ProfileManager;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.ui.autoEdit.MainAutoEditStrategy;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.osgi.framework.Bundle;

public class FormatterLinuxAutoEditTests
extends FormatterTests {
    protected static final char OFFSET_CHAR = '|';
    protected static final Map<PHPVersion, String[]> TESTS = new LinkedHashMap<PHPVersion, String[]>();

    static {
        TESTS.put(PHPVersion.PHP5, new String[]{"/workspace/formatter-autoedit/php5"});
    }

    public static void setUpSuite() throws Exception {
        project = ResourcesPlugin.getWorkspace().getRoot().getProject("FormatterLinuxAutoEditTests");
        if (project.exists()) {
            return;
        }
        project.create(null);
        project.open(null);
        IProjectDescription desc = project.getDescription();
        desc.setNatureIds(new String[]{"org.eclipse.php.core.PHPNature"});
        project.setDescription(desc, null);
        for (PdttFile pdttFile : filesMap.keySet()) {
            IFile file = FormatterLinuxAutoEditTests.createFile(pdttFile.getFile().trim());
            filesMap.put(pdttFile, file);
        }
        project.refreshLocal(2, null);
        project.build(6, null);
        PHPCoreTests.waitForIndexer();
        PHPCoreTests.waitForAutoBuild();
        InstanceScope scopeContext = new InstanceScope();
        ProfileManager profileManager = new ProfileManager(new ArrayList(), (IScopeContext)scopeContext);
        profileManager.clearAllSettings((IScopeContext)scopeContext);
        profileManager.commitChanges((IScopeContext)scopeContext);
    }

    public FormatterLinuxAutoEditTests(String description) {
        super(description);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("Formatter Auto Edit Tests For Linux");
        for (final PHPVersion phpVersion : TESTS.keySet()) {
            TestSuite phpVerSuite = new TestSuite(phpVersion.getAlias());
            String[] stringArray = TESTS.get(phpVersion);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String testsDirectory = stringArray[n2];
                String[] stringArray2 = FormatterLinuxAutoEditTests.getPDTTFiles((String)testsDirectory, (Bundle)Activator.getDefault().getBundle());
                int n3 = stringArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    String fileName = stringArray2[n4];
                    try {
                        final PdttFile pdttFile = new PdttFile(Activator.getDefault().getBundle(), fileName);
                        filesMap.put(pdttFile, null);
                        phpVerSuite.addTest((Test)new FormatterLinuxAutoEditTests("Linux - /" + phpVersion.getAlias() + " - /" + fileName){

                            protected void setUp() throws Exception {
                                PHPCoreTests.setProjectPhpVersion((IProject)project, (PHPVersion)phpVersion);
                            }

                            protected void runTest() throws Throwable {
                                IFile file = (IFile)filesMap.get(pdttFile);
                                ISourceModule modelElement = (ISourceModule)DLTKCore.create((IFile)file);
                                if (ScriptModelUtil.isPrimary((ISourceModule)modelElement)) {
                                    modelElement.becomeWorkingCopy(new IProblemRequestor(){

                                        public void acceptProblem(IProblem problem) {
                                        }

                                        public void beginReporting() {
                                        }

                                        public void endReporting() {
                                        }

                                        public boolean isActive() {
                                            return false;
                                        }
                                    }, null);
                                }
                                IStructuredModel modelForEdit = StructuredModelManager.getModelManager().getModelForEdit(file);
                                try {
                                    IStructuredDocument document = modelForEdit.getStructuredDocument();
                                    String beforeFormat = document.get();
                                    String data = document.get();
                                    int offset = data.lastIndexOf(124);
                                    if (offset == -1) {
                                        throw new IllegalArgumentException(String.valueOf(data) + ",offset character is not set");
                                    }
                                    data = String.valueOf(data.substring(0, offset)) + data.substring(offset + 1);
                                    document.set(data);
                                    MainAutoEditStrategy indentLineAutoEditStrategy = new MainAutoEditStrategy();
                                    DocumentCommand cmd = new DocumentCommand(){};
                                    cmd.offset = offset;
                                    cmd.length = 0;
                                    cmd.text = pdttFile.getOther() != null ? pdttFile.getOther().replaceAll("\r\n", "\n") : "\n";
                                    cmd.doit = true;
                                    cmd.shiftsCaret = true;
                                    cmd.caretOffset = -1;
                                    indentLineAutoEditStrategy.customizeDocumentCommand((IDocument)document, cmd);
                                    document.replace(cmd.offset, cmd.length, cmd.text);
                                    this.assertContents(pdttFile.getExpected().replaceAll("\r\n", "\n"), document.get());
                                    document.set(beforeFormat);
                                    modelForEdit.save();
                                }
                                finally {
                                    if (modelForEdit != null) {
                                        modelForEdit.releaseFromEdit();
                                    }
                                }
                            }
                        });
                    }
                    catch (Exception e) {
                        phpVerSuite.addTest((Test)new TestCase(fileName){

                            protected void runTest() throws Throwable {
                                throw e;
                            }
                        });
                    }
                    ++n4;
                }
                ++n2;
            }
            suite.addTest((Test)phpVerSuite);
        }
        TestSetup setup = new TestSetup((Test)suite){

            protected void setUp() throws Exception {
                FormatterLinuxAutoEditTests.setUpSuite();
            }

            protected void tearDown() throws Exception {
                FormatterLinuxAutoEditTests.tearDownSuite();
            }
        };
        return setup;
    }
}

