/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.server.core.tunneling;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.php.internal.server.core.tunneling.SSHTunnel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SSHTunnelFactory {
    private static HashMap<SSHTunnel, SSHTunnel> tunnels = new HashMap();

    public static SSHTunnel getSSHTunnel(String remoteHost, String userName, String password, int localPort, int remotePort, boolean cacheTunnel) {
        SSHTunnel tunnel = SSHTunnelFactory.createSSHTunnel(remoteHost, userName, password, localPort, remotePort);
        if (cacheTunnel) {
            if (tunnels.containsKey(tunnel)) {
                tunnel = tunnels.get(tunnel);
            } else {
                tunnels.put(tunnel, tunnel);
            }
        }
        return tunnel;
    }

    public static SSHTunnel getSSHTunnel(String remoteHost, String userName, String password, int localPort, int remotePort) {
        return SSHTunnelFactory.getSSHTunnel(remoteHost, userName, password, localPort, remotePort, true);
    }

    public static boolean hasSSHTunnel(String remoteHost, String userName, String password, int localPort, int remotePort) {
        SSHTunnel tunnel = SSHTunnelFactory.createSSHTunnel(remoteHost, userName, password, localPort, remotePort);
        return tunnels.containsKey(tunnel);
    }

    private static SSHTunnel createSSHTunnel(String remoteHost, String userName, String password, int localPort, int remotePort) {
        String localHost = "localhost";
        try {
            localHost = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {}
        SSHTunnel tunnel = new SSHTunnel(localHost, remoteHost, userName, password, localPort, remotePort);
        return tunnel;
    }

    public static void closeAllConnections() {
        for (SSHTunnel tunnel : tunnels.values()) {
            tunnel.disconnect();
        }
    }

    public static List<SSHTunnel> getAllTunnels() {
        return Collections.unmodifiableList(Arrays.asList(tunnels.values().toArray(new SSHTunnel[tunnels.size()])));
    }
}

