/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.actions;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.ui.internal.Logger;
import org.eclipse.wst.sse.ui.internal.SSEUIMessages;
import org.eclipse.wst.sse.ui.internal.handlers.AbstractCommentHandler;
import org.eclipse.wst.sse.ui.internal.handlers.ToggleLineCommentHandler;

public class PHPToggleLineCommentHandler
extends AbstractCommentHandler {
    static final String SINGLE_LINE_COMMENT = "//";
    static final String OPEN_COMMENT = "/*";
    private static final String BLANK = " ";
    private static final String SHORT_TAG = "<?";
    private static final String SHORT_TAG_WITH_BLANK = "<? ";
    private static final String PHP = "<?php";
    private static final String PHP_WITH_BLANK = "<?php ";
    private static final int TOGGLE_LINES_MAX_NO_BUSY_INDICATOR = 10;
    private static final ToggleLineCommentHandler toggleLineCommentHandler = new ToggleLineCommentHandler();

    /*
     * Exception decompiling
     */
    protected void processAction(ITextEditor textEditor, IStructuredDocument document, ITextSelection textSelection) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static boolean isCommentLine(IDocument document, int line, boolean isSingleLine) {
        boolean isComment = false;
        try {
            IRegion region = document.getLineInformation(line);
            String string = document.get(region.getOffset(), region.getLength()).trim();
            boolean phpStrat = false;
            if (string.startsWith(PHP)) {
                string = string.substring(PHP.length()).trim();
                phpStrat = true;
            } else if (string.startsWith(SHORT_TAG)) {
                string = string.substring(SHORT_TAG.length()).trim();
                phpStrat = true;
            }
            isComment = !phpStrat && string.trim().length() == 0 || string.length() >= OPEN_COMMENT.length() && string.startsWith(OPEN_COMMENT) || string.length() >= SINGLE_LINE_COMMENT.length() && string.startsWith(SINGLE_LINE_COMMENT);
        }
        catch (BadLocationException e) {
            Logger.log((int)202, (String)e.getMessage(), (Throwable)e);
        }
        return isComment;
    }

    private static class ToggleLinesRunnable
    implements IRunnableWithProgress {
        private String fContentType;
        private IStructuredDocument fDocument;
        private int fSelectionStartLine;
        private int fSelectionEndLine;
        private Display fDisplay;
        private boolean isSingleLine;

        protected ToggleLinesRunnable(String contentTypeIdentifier, IStructuredDocument document, int selectionStartLine, int selectionEndLine, Display display, boolean isSingleLine) {
            this.fContentType = contentTypeIdentifier;
            this.fDocument = document;
            this.fSelectionStartLine = selectionStartLine;
            this.fSelectionEndLine = selectionEndLine;
            this.fDisplay = display;
            this.isSingleLine = isSingleLine;
        }

        public void run(IProgressMonitor monitor) {
            monitor.beginTask(SSEUIMessages.ToggleComment_progress, this.fSelectionEndLine - this.fSelectionStartLine);
            try {
                boolean allLinesCommented = true;
                int i = this.fSelectionStartLine;
                while (i <= this.fSelectionEndLine) {
                    try {
                        if (this.fDocument.getLineLength(i) > 0 && !PHPToggleLineCommentHandler.isCommentLine((IDocument)this.fDocument, i, this.isSingleLine)) {
                            allLinesCommented = false;
                            break;
                        }
                    }
                    catch (BadLocationException e) {
                        Logger.log((int)202, (String)e.getMessage(), (Throwable)e);
                    }
                    ++i;
                }
                int line = this.fSelectionStartLine;
                while (line <= this.fSelectionEndLine && !monitor.isCanceled()) {
                    this.readAndDispatch(this.fDisplay);
                    IRegion lineRegion = this.fDocument.getLineInformation(line);
                    String content = this.fDocument.get(lineRegion.getOffset(), lineRegion.getLength());
                    if (content.trim().length() > 0) {
                        if (allLinesCommented) {
                            this.remove(this.fDocument, lineRegion.getOffset(), lineRegion.getLength(), true);
                        } else {
                            int offset = 0;
                            String string = content.trim();
                            String commentStr = PHPToggleLineCommentHandler.SINGLE_LINE_COMMENT;
                            if (string.startsWith(PHPToggleLineCommentHandler.PHP_WITH_BLANK)) {
                                offset = content.indexOf(PHPToggleLineCommentHandler.PHP_WITH_BLANK) + PHPToggleLineCommentHandler.PHP_WITH_BLANK.length();
                                commentStr = PHPToggleLineCommentHandler.SINGLE_LINE_COMMENT;
                            } else if (string.startsWith(PHPToggleLineCommentHandler.PHP)) {
                                offset = content.indexOf(PHPToggleLineCommentHandler.PHP) + PHPToggleLineCommentHandler.PHP.length();
                                commentStr = " //";
                            } else if (string.startsWith(PHPToggleLineCommentHandler.SHORT_TAG_WITH_BLANK)) {
                                offset = content.indexOf(PHPToggleLineCommentHandler.SHORT_TAG_WITH_BLANK) + PHPToggleLineCommentHandler.SHORT_TAG_WITH_BLANK.length();
                                commentStr = PHPToggleLineCommentHandler.SINGLE_LINE_COMMENT;
                            } else if (string.startsWith(PHPToggleLineCommentHandler.SHORT_TAG)) {
                                offset = content.indexOf(PHPToggleLineCommentHandler.SHORT_TAG) + PHPToggleLineCommentHandler.SHORT_TAG.length();
                                commentStr = " //";
                            } else {
                                commentStr = PHPToggleLineCommentHandler.SINGLE_LINE_COMMENT;
                            }
                            this.fDocument.replace(lineRegion.getOffset() + offset, 0, String.valueOf(commentStr) + PHPToggleLineCommentHandler.BLANK);
                        }
                    }
                    monitor.worked(1);
                    ++line;
                }
            }
            catch (BadLocationException e) {
                Logger.logException((String)"Bad location while toggling comments.", (Throwable)e);
            }
            monitor.done();
        }

        public void apply(IStructuredDocument document, int offset, int length) throws BadLocationException {
            document.replace(offset, 0, "// ");
        }

        public void remove(IStructuredDocument document, int offset, int length, boolean removeEnclosing) throws BadLocationException {
            String content = document.get(offset, length);
            int innerOffset = content.indexOf(PHPToggleLineCommentHandler.SINGLE_LINE_COMMENT);
            if (innerOffset > 0) {
                offset += innerOffset;
            }
            ToggleLinesRunnable.uncomment((IDocument)document, offset, PHPToggleLineCommentHandler.SINGLE_LINE_COMMENT, -1, null);
        }

        protected static void uncomment(IDocument document, int commentPrefixOffset, String commentPrefix, int commentSuffixOffset, String commentSuffix) {
            try {
                int commentPrefixLength = commentPrefix.length();
                String postCommentPrefixChar = document.get(commentPrefixOffset + commentPrefix.length(), 1);
                if (postCommentPrefixChar.equals(PHPToggleLineCommentHandler.BLANK)) {
                    ++commentPrefixLength;
                }
                document.replace(commentPrefixOffset, commentPrefixLength, "");
                if (commentSuffix != null) {
                    int commentSuffixLength = commentSuffix.length();
                    String preCommentSuffixChar = document.get((commentSuffixOffset -= commentPrefixLength) - 1, 1);
                    if (preCommentSuffixChar.equals(PHPToggleLineCommentHandler.BLANK)) {
                        ++commentSuffixLength;
                        --commentSuffixOffset;
                    }
                    document.replace(commentSuffixOffset, commentSuffixLength, "");
                }
            }
            catch (BadLocationException e) {
                Logger.log((int)202, (String)e.getMessage(), (Throwable)e);
            }
        }

        private void readAndDispatch(Display display) {
            try {
                display.readAndDispatch();
            }
            catch (Exception e) {
                Logger.log((int)2, (String)"Exception caused by readAndDispatch, not caused by or fatal to caller", (Throwable)e);
            }
            catch (LinkageError e) {
                Logger.log((int)2, (String)"LinkageError caused by readAndDispatch, not caused by or fatal to caller", (Throwable)e);
            }
            catch (VirtualMachineError e) {
                throw e;
            }
            catch (ThreadDeath e) {
                throw e;
            }
            catch (Error e) {
                Logger.log((int)2, (String)"Error caused by readAndDispatch, not caused by or fatal to caller", (Throwable)e);
            }
        }
    }
}

