/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.corext.fix;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.ScriptElementLabels;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.php.internal.core.ast.nodes.IBinding;
import org.eclipse.php.internal.core.ast.nodes.ITypeBinding;
import org.eclipse.php.internal.core.ast.rewrite.ITrackedNodePosition;
import org.eclipse.php.internal.ui.viewsupport.BindingLabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class LinkedProposalPositionGroup {
    private final String fGroupId;
    private final List fPositions;
    private final List fProposals;

    public static PositionInformation createPositionInformation(ITrackedNodePosition pos, boolean isFirst) {
        return new TrackedNodePosition(pos, isFirst);
    }

    public LinkedProposalPositionGroup(String groupID) {
        this.fGroupId = groupID;
        this.fPositions = new ArrayList();
        this.fProposals = new ArrayList();
    }

    public void addPosition(PositionInformation position) {
        this.fPositions.add(position);
    }

    public void addProposal(Proposal proposal) {
        this.fProposals.add(proposal);
    }

    public void addPosition(ITrackedNodePosition position, boolean isFirst) {
        this.addPosition(LinkedProposalPositionGroup.createPositionInformation(position, isFirst));
    }

    public void addProposal(String displayString, Image image, int relevance) {
        this.addProposal(new Proposal(displayString, image, relevance));
    }

    public void addProposal(ITypeBinding type, ISourceModule cu, int relevance) {
        this.addProposal(new JavaLinkedModeProposal(cu, type, relevance));
    }

    public String getGroupId() {
        return this.fGroupId;
    }

    public PositionInformation[] getPositions() {
        return this.fPositions.toArray(new PositionInformation[this.fPositions.size()]);
    }

    public Proposal[] getProposals() {
        return this.fProposals.toArray(new Proposal[this.fProposals.size()]);
    }

    private static final class JavaLinkedModeProposal
    extends Proposal {
        private final ITypeBinding fTypeProposal;
        private final ISourceModule fCompilationUnit;

        public JavaLinkedModeProposal(ISourceModule unit, ITypeBinding typeProposal, int relevance) {
            super(BindingLabelProvider.getBindingLabel((IBinding)typeProposal, ScriptElementLabels.ALL_DEFAULT | ScriptElementLabels.ALL_POST_QUALIFIED), null, relevance);
            this.fTypeProposal = typeProposal;
            this.fCompilationUnit = unit;
            ImageDescriptor desc = BindingLabelProvider.getBindingImageDescriptor((IBinding)this.fTypeProposal, 1);
            if (desc != null) {
                this.setImage(DLTKUIPlugin.getImageDescriptorRegistry().get(desc));
            }
        }

        public TextEdit computeEdits(int offset, LinkedPosition position, char trigger, int stateMask, LinkedModeModel model) throws CoreException {
            MultiTextEdit composedEdit = new MultiTextEdit();
            return composedEdit;
        }
    }

    public static abstract class PositionInformation {
        public abstract int getOffset();

        public abstract int getLength();

        public abstract int getSequenceRank();
    }

    public static class Proposal {
        private String fDisplayString;
        private Image fImage;
        private int fRelevance;

        public Proposal(String displayString, Image image, int relevance) {
            this.fDisplayString = displayString;
            this.fImage = image;
            this.fRelevance = relevance;
        }

        public String getDisplayString() {
            return this.fDisplayString;
        }

        public Image getImage() {
            return this.fImage;
        }

        public int getRelevance() {
            return this.fRelevance;
        }

        public void setImage(Image image) {
            this.fImage = image;
        }

        public String getAdditionalProposalInfo() {
            return null;
        }

        public TextEdit computeEdits(int offset, LinkedPosition position, char trigger, int stateMask, LinkedModeModel model) throws CoreException {
            return new ReplaceEdit(position.getOffset(), position.getLength(), this.fDisplayString);
        }
    }

    private static class TrackedNodePosition
    extends PositionInformation {
        private final ITrackedNodePosition fPos;
        private final boolean fIsFirst;

        public TrackedNodePosition(ITrackedNodePosition pos, boolean isFirst) {
            this.fPos = pos;
            this.fIsFirst = isFirst;
        }

        public int getOffset() {
            return this.fPos.getStartPosition();
        }

        public int getLength() {
            return this.fPos.getLength();
        }

        public int getSequenceRank() {
            return this.fIsFirst ? 0 : 1;
        }
    }
}

