/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.WorkspaceRunnableAdapter;
import org.eclipse.php.internal.ui.wizards.FragmentedWizardPage;
import org.eclipse.php.internal.ui.wizards.WizardFragment;
import org.eclipse.php.internal.ui.wizards.WizardModel;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class FragmentedWizard
implements IWizard {
    private static final byte FINISH = 2;
    private static final byte CANCEL = 3;
    private List pages;
    private boolean addingPages;
    private Map fragmentData = new HashMap();
    protected WizardModel wizardModel;
    private IWizardContainer container = null;
    private boolean needsProgressMonitor = false;
    private boolean forcePreviousAndNextButtons = false;
    private boolean isHelpAvailable = false;
    private Image defaultImage = null;
    private RGB titleBarColor = null;
    private String windowTitle = null;
    private IDialogSettings dialogSettings = null;
    private WizardFragment rootFragment;
    private WizardFragment currentFragment;

    public FragmentedWizard(String title, WizardFragment rootFragment) {
        this(title, rootFragment, null);
        this.setWindowTitle(title);
    }

    public FragmentedWizard(String title, WizardFragment rootFragment, WizardModel taskModel) {
        if (title != null) {
            this.setWindowTitle(title);
        }
        this.rootFragment = rootFragment;
        this.wizardModel = taskModel;
        if (taskModel == null) {
            this.wizardModel = new WizardModel();
        }
        this.setNeedsProgressMonitor(true);
        this.setForcePreviousAndNextButtons(true);
    }

    public void setWizardModel(WizardModel taskModel) {
        this.wizardModel = taskModel;
    }

    public WizardModel getWizardModel() {
        return this.wizardModel;
    }

    public void setRootFragment(WizardFragment rootFragment) {
        this.rootFragment = rootFragment;
    }

    public WizardFragment getRootFragment() {
        return this.rootFragment;
    }

    public boolean performCancel() {
        final List list = this.getAllWizardFragments();
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        FragmentedWizard.this.executeTask((WizardFragment)iterator.next(), (byte)3, monitor);
                    }
                }
                catch (CoreException ce) {
                    throw new InvocationTargetException(ce);
                }
            }
        };
        Throwable t = null;
        try {
            if (this.getContainer() != null) {
                this.getContainer().run(true, true, runnable);
            } else {
                runnable.run((IProgressMonitor)new NullProgressMonitor());
            }
            return true;
        }
        catch (InvocationTargetException te) {
            t = te.getCause();
        }
        catch (Exception e) {
            t = e;
        }
        PHPUiPlugin.log((IStatus)new Status(4, "org.eclipse.php.ui", 0, "Error cancelling task wizard", t));
        if (t instanceof CoreException) {
            FragmentedWizard.openError(t.getLocalizedMessage(), ((CoreException)t).getStatus());
        } else {
            FragmentedWizard.openError(t.getLocalizedMessage());
        }
        return false;
    }

    private static void openError(final String message) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                Shell shell = Display.getDefault().getActiveShell();
                MessageDialog.openError((Shell)shell, (String)PHPUIMessages.FragmentedWizard_0, (String)message);
            }
        });
    }

    private static void openError(final String message, final IStatus status) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                Shell shell = Display.getDefault().getActiveShell();
                ErrorDialog.openError((Shell)shell, (String)PHPUIMessages.FragmentedWizard_1, (String)message, (IStatus)status);
            }
        });
    }

    public boolean performFinish() {
        if (this.currentFragment != null) {
            this.currentFragment.exit();
        }
        final WizardFragment cFragment = this.currentFragment;
        final List list = this.getAllWizardFragments();
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                int index = list.indexOf(cFragment);
                while (index > 0 && index < list.size() - 1) {
                    final WizardFragment fragment = (WizardFragment)list.get(++index);
                    try {
                        Display.getDefault().syncExec(new Runnable(){

                            public void run() {
                                fragment.enter();
                                fragment.exit();
                            }
                        });
                    }
                    catch (Exception e) {
                        PHPUiPlugin.log((IStatus)new Status(4, "org.eclipse.php.ui", 0, "Could not enter/exit page", (Throwable)e));
                    }
                }
                if (FragmentedWizard.this.useJob()) {
                    class FinishWizardJob
                    extends Job {
                        private final /* synthetic */ List val$list;

                        public FinishWizardJob(List list) {
                            this.val$list = list;
                            super(FragmentedWizard.this.getJobTitle());
                        }

                        public boolean belongsTo(Object family) {
                            return "org.eclipse.wst.server.ui.family".equals(family);
                        }

                        public IStatus run(IProgressMonitor monitor2) {
                            try {
                                Iterator iterator = this.val$list.iterator();
                                while (iterator.hasNext()) {
                                    FragmentedWizard.this.executeTask((WizardFragment)iterator.next(), (byte)2, monitor2);
                                }
                            }
                            catch (CoreException ce) {
                                Status status = new Status(4, "org.eclipse.php.ui", 0, ce.getLocalizedMessage(), null);
                                PHPUiPlugin.log((IStatus)status);
                                return status;
                            }
                            return Status.OK_STATUS;
                        }
                    }
                    FinishWizardJob job = new FinishWizardJob(list);
                    job.setUser(true);
                    job.schedule();
                } else {
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        FragmentedWizard.this.executeTask((WizardFragment)iterator.next(), (byte)2, monitor);
                    }
                }
            }
        };
        Throwable t = null;
        try {
            if (this.getContainer() != null) {
                this.getContainer().run(true, true, (IRunnableWithProgress)new WorkspaceRunnableAdapter(runnable));
            } else {
                runnable.run((IProgressMonitor)new NullProgressMonitor());
            }
            return true;
        }
        catch (InvocationTargetException te) {
            PHPUiPlugin.log((IStatus)new Status(4, "org.eclipse.php.ui", 0, "Error finishing task wizard", (Throwable)te));
            t = te.getCause();
        }
        catch (Exception e) {
            PHPUiPlugin.log((IStatus)new Status(4, "org.eclipse.php.ui", 0, "Error finishing task wizard 2", (Throwable)e));
            t = e;
        }
        if (t instanceof CoreException) {
            FragmentedWizard.openError(t.getLocalizedMessage(), ((CoreException)t).getStatus());
        } else if (t instanceof NullPointerException) {
            FragmentedWizard.openError(PHPUIMessages.FragmentedWizard_7);
        } else {
            FragmentedWizard.openError(t.getLocalizedMessage());
        }
        return false;
    }

    public void addPage(IWizardPage page) {
        this.pages.add(page);
        page.setWizard((IWizard)this);
    }

    protected void executeTask(WizardFragment fragment, byte type, IProgressMonitor monitor) throws CoreException {
        if (fragment == null) {
            return;
        }
        if (type == 2) {
            fragment.performFinish(monitor);
        } else if (type == 3) {
            fragment.performCancel(monitor);
        }
    }

    protected WizardFragment getCurrentWizardFragment() {
        return this.currentFragment;
    }

    protected void switchWizardFragment(WizardFragment newFragment) {
        int newIndex;
        List list = this.getAllWizardFragments();
        int oldIndex = list.indexOf(this.currentFragment);
        if (oldIndex == (newIndex = list.indexOf(newFragment))) {
            return;
        }
        if (this.currentFragment != null) {
            this.currentFragment.exit();
        }
        oldIndex = oldIndex < newIndex ? ++oldIndex : --oldIndex;
        while (oldIndex != newIndex) {
            WizardFragment fragment = (WizardFragment)list.get(oldIndex);
            fragment.enter();
            fragment.exit();
            if (oldIndex < newIndex) {
                ++oldIndex;
                continue;
            }
            --oldIndex;
        }
        this.currentFragment = newFragment;
        this.currentFragment.enter();
    }

    private List getAllWizardFragments() {
        ArrayList<WizardFragment> list = new ArrayList<WizardFragment>();
        list.add(this.rootFragment);
        this.addSubWizardFragments(this.rootFragment, list);
        for (WizardFragment fragment : list) {
            if (this.wizardModel.equals(fragment.getWizardModel())) continue;
            fragment.setWizardModel(this.wizardModel);
        }
        return list;
    }

    private void addSubWizardFragments(WizardFragment fragment, List list) {
        for (WizardFragment child : fragment.getChildFragments()) {
            list.add(child);
            this.addSubWizardFragments(child, list);
        }
    }

    public void addPages() {
        if (this.addingPages) {
            return;
        }
        try {
            try {
                this.addingPages = true;
                this.pages = new ArrayList();
                for (WizardFragment fragment : this.getAllWizardFragments()) {
                    FragmentedWizardPage page = this.getFragmentData(fragment);
                    if (!fragment.hasComposite()) continue;
                    if (page != null) {
                        this.addPage((IWizardPage)page);
                        continue;
                    }
                    FragmentedWizardPage page2 = new FragmentedWizardPage(fragment);
                    this.fragmentData.put(fragment, page2);
                    this.addPage((IWizardPage)page2);
                }
            }
            catch (Exception e) {
                PHPUiPlugin.log((IStatus)new Status(4, "org.eclipse.php.ui", 0, "Error adding fragments to wizard", (Throwable)e));
                this.addingPages = false;
            }
        }
        finally {
            this.addingPages = false;
        }
    }

    private FragmentedWizardPage getFragmentData(WizardFragment fragment) {
        try {
            FragmentedWizardPage page = (FragmentedWizardPage)this.fragmentData.get(fragment);
            if (page != null) {
                return page;
            }
        }
        catch (Exception e) {
            PHPUiPlugin.log((IStatus)new Status(4, "org.eclipse.php.ui", 0, "Error getting fragment data", (Throwable)e));
        }
        return null;
    }

    protected void updatePages() {
        this.addPages();
    }

    public boolean canFinish() {
        int i = 0;
        while (i < this.pages.size()) {
            if (!((IWizardPage)this.pages.get(i)).isPageComplete()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void createPageControls(Composite pageContainer) {
        int i = 0;
        while (i < this.pages.size()) {
            IWizardPage page = (IWizardPage)this.pages.get(i);
            page.createControl(pageContainer);
            ++i;
        }
    }

    public void dispose() {
        int i = 0;
        while (i < this.pages.size()) {
            ((IWizardPage)this.pages.get(i)).dispose();
            ++i;
        }
        if (this.defaultImage != null) {
            this.defaultImage.dispose();
            this.defaultImage = null;
        }
    }

    public IWizardContainer getContainer() {
        return this.container;
    }

    public Image getDefaultPageImage() {
        return this.defaultImage;
    }

    public IDialogSettings getDialogSettings() {
        return this.dialogSettings;
    }

    public IWizardPage getNextPage(IWizardPage page) {
        int index = this.pages.indexOf(page);
        if (index == this.pages.size() - 1 || index == -1) {
            return null;
        }
        return (IWizardPage)this.pages.get(index + 1);
    }

    public IWizardPage getPage(String name) {
        int i = 0;
        while (i < this.pages.size()) {
            IWizardPage page = (IWizardPage)this.pages.get(i);
            String pageName = page.getName();
            if (pageName.equals(name)) {
                return page;
            }
            ++i;
        }
        return null;
    }

    public int getPageCount() {
        return this.pages.size();
    }

    public IWizardPage[] getPages() {
        return this.pages.toArray(new IWizardPage[this.pages.size()]);
    }

    public IWizardPage getPreviousPage(IWizardPage page) {
        int index = this.pages.indexOf(page);
        if (index == 0 || index == -1) {
            return null;
        }
        return (IWizardPage)this.pages.get(index - 1);
    }

    public IWizardPage getStartingPage() {
        if (this.pages.size() == 0) {
            return null;
        }
        return (IWizardPage)this.pages.get(0);
    }

    public RGB getTitleBarColor() {
        return this.titleBarColor;
    }

    public String getWindowTitle() {
        return this.windowTitle;
    }

    public boolean isHelpAvailable() {
        return this.isHelpAvailable;
    }

    public boolean needsPreviousAndNextButtons() {
        return this.forcePreviousAndNextButtons || this.pages.size() > 1;
    }

    public boolean needsProgressMonitor() {
        return this.needsProgressMonitor;
    }

    public void setContainer(IWizardContainer wizardContainer) {
        this.container = wizardContainer;
    }

    public void setDialogSettings(IDialogSettings settings) {
        this.dialogSettings = settings;
    }

    public void setNeedsProgressMonitor(boolean b) {
        this.needsProgressMonitor = b;
    }

    public void setForcePreviousAndNextButtons(boolean b) {
        this.forcePreviousAndNextButtons = b;
    }

    public void setWindowTitle(String title) {
        this.windowTitle = title;
    }

    protected boolean useJob() {
        return false;
    }

    protected String getJobTitle() {
        return this.getWindowTitle();
    }
}

