/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.tests.compiler_ast.parser;

import java.io.ByteArrayInputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.LinkedHashMap;
import java.util.Map;
import junit.extensions.TestSetup;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.php.core.tests.AbstractPDTTTest;
import org.eclipse.php.core.tests.PdttFile;
import org.eclipse.php.core.tests.compiler_ast.parser.CompilerParserTests;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.core.compiler.ast.nodes.UseStatement;
import org.eclipse.php.internal.core.compiler.ast.parser.ASTUtils;
import org.eclipse.php.internal.core.compiler.ast.parser.AbstractPHPSourceParser;
import org.eclipse.php.internal.core.compiler.ast.parser.PHPSourceParserFactory;
import org.eclipse.php.internal.core.project.ProjectOptions;

public class GetUseStatementsByTests
extends AbstractPDTTTest {
    protected static final Map<PHPVersion, String[]> TESTS = new LinkedHashMap<PHPVersion, String[]>();

    static {
        TESTS.put(PHPVersion.PHP5_3, new String[]{"/workspace/astutils/get_use_statements/php53"});
    }

    public GetUseStatementsByTests(String description) {
        super(description);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("Get Use Statements Tests");
        for (PHPVersion phpVersion : TESTS.keySet()) {
            TestSuite phpVerSuite = new TestSuite(phpVersion.getAlias());
            final AbstractPHPSourceParser parser = PHPSourceParserFactory.createParser((PHPVersion)phpVersion);
            String[] stringArray = TESTS.get(phpVersion);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String testsDirectory = stringArray[n2];
                String[] stringArray2 = GetUseStatementsByTests.getPDTTFiles(testsDirectory);
                int n3 = stringArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    String fileName = stringArray2[n4];
                    try {
                        final PdttFile pdttFile = new PdttFile(fileName);
                        phpVerSuite.addTest((Test)new CompilerParserTests(String.valueOf(phpVersion.getAlias()) + " - /" + fileName){

                            protected void runTest() throws Throwable {
                                ByteArrayInputStream inputStream = new ByteArrayInputStream(pdttFile.getFile().trim().getBytes());
                                ModuleDeclaration moduleDeclaration = (ModuleDeclaration)parser.parse((Reader)new InputStreamReader(inputStream), null, ProjectOptions.useShortTags(null));
                                int offset = Integer.parseInt(pdttFile.getConfig().get("offset"));
                                UseStatement[] useStatements = ASTUtils.getUseStatements((ModuleDeclaration)moduleDeclaration, (int)offset);
                                StringBuilder builder = new StringBuilder();
                                UseStatement[] useStatementArray = useStatements;
                                int n = useStatements.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    UseStatement s = useStatementArray[n2];
                                    builder.append(s);
                                    ++n2;
                                }
                                String actual = builder.toString();
                                this.assertContents(pdttFile.getExpected(), actual);
                            }
                        });
                    }
                    catch (Exception e) {
                        phpVerSuite.addTest((Test)new TestCase(fileName){

                            protected void runTest() throws Throwable {
                                throw e;
                            }
                        });
                    }
                    ++n4;
                }
                ++n2;
            }
            suite.addTest((Test)phpVerSuite);
        }
        TestSetup setup = new TestSetup((Test)suite){

            protected void setUp() throws Exception {
            }

            protected void tearDown() throws Exception {
            }
        };
        return setup;
    }
}

