/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.tests.compiler_ast.phpdoc;

import java.io.ByteArrayInputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import junit.extensions.TestSetup;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.php.core.tests.AbstractPDTTTest;
import org.eclipse.php.core.tests.PdttFile;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPDocBlock;
import org.eclipse.php.internal.core.compiler.ast.parser.DocumentorLexer;
import org.eclipse.php.internal.core.compiler.ast.visitor.ASTPrintVisitor;

public class PHPDocParserTests
extends AbstractPDTTTest {
    protected static final String[] TEST_DIRS = new String[]{"/workspace/phpdoc_parser"};

    public static void setUpSuite() throws Exception {
    }

    public static void tearDownSuite() throws Exception {
    }

    public PHPDocParserTests(String description) {
        super(description);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("PHPDoc Parser Tests");
        String[] stringArray = TEST_DIRS;
        int n = TEST_DIRS.length;
        int n2 = 0;
        while (n2 < n) {
            String testsDirectory = stringArray[n2];
            String[] stringArray2 = PHPDocParserTests.getPDTTFiles(testsDirectory);
            int n3 = stringArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                String fileName = stringArray2[n4];
                try {
                    final PdttFile pdttFile = new PdttFile(fileName);
                    suite.addTest((Test)new PHPDocParserTests("/" + fileName){

                        protected void runTest() throws Throwable {
                            byte[] code = pdttFile.getFile().trim().getBytes();
                            InputStreamReader reader = new InputStreamReader(new ByteArrayInputStream(code));
                            DocumentorLexer lexer = new DocumentorLexer((Reader)reader);
                            PHPDocBlock phpDocBlock = lexer.parse();
                            this.assertContents(pdttFile.getExpected(), ASTPrintVisitor.toXMLString((ASTNode)phpDocBlock));
                        }
                    });
                }
                catch (Exception e) {
                    suite.addTest((Test)new TestCase(fileName){

                        protected void runTest() throws Throwable {
                            throw e;
                        }
                    });
                }
                ++n4;
            }
            ++n2;
        }
        TestSetup setup = new TestSetup((Test)suite){

            protected void setUp() throws Exception {
                PHPDocParserTests.setUpSuite();
            }

            protected void tearDown() throws Exception {
                PHPDocParserTests.tearDownSuite();
            }
        };
        return setup;
    }
}

