/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.tests.document.lexer;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import junit.extensions.TestSetup;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.php.core.tests.AbstractPDTTTest;
import org.eclipse.php.core.tests.PdttFile;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.core.documentModel.parser.AbstractPhpLexer;
import org.eclipse.php.internal.core.documentModel.parser.PhpLexerFactory;

public class DocumentLexerTests
extends AbstractPDTTTest {
    protected static final Map<PHPVersion, String[]> TESTS = new LinkedHashMap<PHPVersion, String[]>();

    static {
        TESTS.put(PHPVersion.PHP4, new String[]{"/workspace/document_lexer/php4"});
        TESTS.put(PHPVersion.PHP5, new String[]{"/workspace/document_lexer/php5"});
        TESTS.put(PHPVersion.PHP5_3, new String[]{"/workspace/document_lexer/php53"});
        TESTS.put(PHPVersion.PHP5_4, new String[]{"/workspace/document_lexer/php53", "/workspace/document_lexer/php54"});
        TESTS.put(PHPVersion.PHP5_5, new String[]{"/workspace/document_lexer/php53", "/workspace/document_lexer/php54", "/workspace/document_lexer/php55"});
    }

    public static void setUpSuite() throws Exception {
    }

    public static void tearDownSuite() throws Exception {
    }

    public DocumentLexerTests(String description) {
        super(description);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("Document Lexer Tests");
        for (final PHPVersion phpVersion : TESTS.keySet()) {
            TestSuite phpVerSuite = new TestSuite(phpVersion.getAlias());
            String[] stringArray = TESTS.get(phpVersion);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String testsDirectory = stringArray[n2];
                String[] stringArray2 = DocumentLexerTests.getPDTTFiles(testsDirectory);
                int n3 = stringArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    String fileName = stringArray2[n4];
                    try {
                        final PdttFile pdttFile = new PdttFile(fileName);
                        phpVerSuite.addTest((Test)new DocumentLexerTests(String.valueOf(phpVersion.getAlias()) + " - /" + fileName){

                            protected void runTest() throws Throwable {
                                AbstractPhpLexer lexer = PhpLexerFactory.createLexer((InputStream)new ByteArrayInputStream(pdttFile.getFile().trim().getBytes()), (PHPVersion)phpVersion);
                                int inScriptingState = lexer.getClass().getField("ST_PHP_IN_SCRIPTING").getInt(lexer);
                                lexer.initialize(inScriptingState);
                                StringBuilder actualBuf = new StringBuilder();
                                String tokenType = lexer.yylex();
                                while (tokenType != null) {
                                    actualBuf.append(tokenType).append('|').append(lexer.yytext()).append('|').append(lexer.yystate()).append('\n');
                                    tokenType = lexer.yylex();
                                }
                                this.assertContents(pdttFile.getExpected(), actualBuf.toString());
                            }
                        });
                    }
                    catch (Exception e) {
                        phpVerSuite.addTest((Test)new TestCase(fileName){

                            protected void runTest() throws Throwable {
                                throw e;
                            }
                        });
                    }
                    ++n4;
                }
                ++n2;
            }
            suite.addTest((Test)phpVerSuite);
        }
        TestSetup setup = new TestSetup((Test)suite){

            protected void setUp() throws Exception {
                DocumentLexerTests.setUpSuite();
            }

            protected void tearDown() throws Exception {
                DocumentLexerTests.tearDownSuite();
            }
        };
        return setup;
    }
}

