/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.tests.formatter;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import junit.extensions.TestSetup;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.dltk.compiler.problem.IProblem;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IBuffer;
import org.eclipse.dltk.core.IOpenable;
import org.eclipse.dltk.core.IProblemRequestor;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ScriptModelUtil;
import org.eclipse.dltk.core.WorkingCopyOwner;
import org.eclipse.jface.text.IDocument;
import org.eclipse.php.core.tests.AbstractPDTTTest;
import org.eclipse.php.core.tests.PHPCoreTests;
import org.eclipse.php.core.tests.PdttFile;
import org.eclipse.php.core.tests.formatter.DocumentAdapter;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.core.format.PhpFormatProcessorImpl;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;

public class FormatterTests
extends AbstractPDTTTest {
    protected static final Map<PHPVersion, String[]> TESTS = new LinkedHashMap<PHPVersion, String[]>();
    protected static Map<PdttFile, IFile> filesMap;
    protected static IProject project;
    protected static int count;

    static {
        TESTS.put(PHPVersion.PHP5, new String[]{"/workspace/formatter/php5"});
        TESTS.put(PHPVersion.PHP5_4, new String[]{"/workspace/formatter/php5", "/workspace/formatter/php54"});
        TESTS.put(PHPVersion.PHP5_5, new String[]{"/workspace/formatter/php5", "/workspace/formatter/php54", "/workspace/formatter/php55"});
        filesMap = new LinkedHashMap<PdttFile, IFile>();
    }

    public static void setUpSuite() throws Exception {
        project = ResourcesPlugin.getWorkspace().getRoot().getProject("FormatterTests");
        if (project.exists()) {
            return;
        }
        project.create(null);
        project.open(null);
        IProjectDescription desc = project.getDescription();
        desc.setNatureIds(new String[]{"org.eclipse.php.core.PHPNature"});
        project.setDescription(desc, null);
        WorkingCopyOwner.setPrimaryBufferProvider((WorkingCopyOwner)new WorkingCopyOwner(){

            public IBuffer createBuffer(ISourceModule workingCopy) {
                ISourceModule original = workingCopy.getPrimary();
                IResource resource = original.getResource();
                if (resource != null && resource instanceof IFile) {
                    return new DocumentAdapter((IOpenable)workingCopy, (IFile)resource);
                }
                return DocumentAdapter.NULL;
            }
        });
        for (PdttFile pdttFile : filesMap.keySet()) {
            IFile file = FormatterTests.createFile(pdttFile.getFile().trim());
            filesMap.put(pdttFile, file);
        }
        project.refreshLocal(2, null);
        project.build(6, null);
        PHPCoreTests.waitForIndexer();
        PHPCoreTests.waitForAutoBuild();
    }

    public static void tearDownSuite() throws Exception {
        project.close(null);
        project.delete(true, true, null);
        project = null;
    }

    public FormatterTests(String description) {
        super(description);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("Formatter Tests");
        for (final PHPVersion phpVersion : TESTS.keySet()) {
            TestSuite phpVerSuite = new TestSuite(phpVersion.getAlias());
            String[] stringArray = TESTS.get(phpVersion);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String testsDirectory = stringArray[n2];
                String[] stringArray2 = FormatterTests.getPDTTFiles(testsDirectory);
                int n3 = stringArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    String fileName = stringArray2[n4];
                    try {
                        final PdttFile pdttFile = new PdttFile(fileName);
                        filesMap.put(pdttFile, null);
                        phpVerSuite.addTest((Test)new FormatterTests(String.valueOf(phpVersion.getAlias()) + " - /" + fileName){

                            protected void setUp() throws Exception {
                                PHPCoreTests.setProjectPhpVersion(project, phpVersion);
                            }

                            protected void runTest() throws Throwable {
                                IFile file = (IFile)filesMap.get(pdttFile);
                                ISourceModule modelElement = (ISourceModule)DLTKCore.create((IFile)file);
                                if (ScriptModelUtil.isPrimary((ISourceModule)modelElement)) {
                                    modelElement.becomeWorkingCopy(new IProblemRequestor(){

                                        public void acceptProblem(IProblem problem) {
                                        }

                                        public void beginReporting() {
                                        }

                                        public void endReporting() {
                                        }

                                        public boolean isActive() {
                                            return false;
                                        }
                                    }, null);
                                }
                                IStructuredModel modelForEdit = StructuredModelManager.getModelManager().getModelForEdit(file);
                                try {
                                    IStructuredDocument document = modelForEdit.getStructuredDocument();
                                    String beforeFormat = document.get();
                                    PhpFormatProcessorImpl formatter = new PhpFormatProcessorImpl();
                                    formatter.formatDocument((IDocument)document, 0, document.getLength());
                                    this.assertContents(pdttFile.getExpected(), document.get());
                                    document.set(beforeFormat);
                                    modelForEdit.save();
                                }
                                finally {
                                    if (modelForEdit != null) {
                                        modelForEdit.releaseFromEdit();
                                    }
                                }
                            }
                        });
                    }
                    catch (Exception e) {
                        phpVerSuite.addTest((Test)new TestCase(fileName){

                            protected void runTest() throws Throwable {
                                throw e;
                            }
                        });
                    }
                    ++n4;
                }
                ++n2;
            }
            suite.addTest((Test)phpVerSuite);
        }
        TestSetup setup = new TestSetup((Test)suite){

            protected void setUp() throws Exception {
                FormatterTests.setUpSuite();
            }

            protected void tearDown() throws Exception {
                FormatterTests.tearDownSuite();
            }
        };
        return setup;
    }

    protected static IFile createFile(String data) throws Exception {
        IFile testFile = project.getFile("test" + ++count + ".php");
        testFile.create((InputStream)new ByteArrayInputStream(data.getBytes()), true, null);
        return testFile;
    }
}

