/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.codeassist.contexts;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.dltk.core.CompletionRequestor;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.php.internal.core.codeassist.contexts.PHPDocContext;
import org.eclipse.php.internal.core.preferences.TaskPatternsProvider;
import org.eclipse.php.internal.core.util.text.PHPTextSequenceUtilities;
import org.eclipse.php.internal.core.util.text.TextSequence;

public abstract class PHPDocTagContext
extends PHPDocContext {
    private String tagName;
    private Pattern[] todos;
    protected int tagStart;

    public void setPatterns(IProject project) {
        this.todos = project != null ? TaskPatternsProvider.getInstance().getPatternsForProject(project) : TaskPatternsProvider.getInstance().getPetternsForWorkspace();
    }

    private ArrayList<Matcher> createMatcherList(String content) {
        ArrayList<Matcher> list = new ArrayList<Matcher>(this.todos.length);
        int i = 0;
        while (i < this.todos.length) {
            list.add(i, this.todos[i].matcher(content));
            ++i;
        }
        return list;
    }

    private Matcher getMinimalMatcher(ArrayList<Matcher> matchers, int startPosition) {
        Matcher minimal = null;
        int size = matchers.size();
        int i = 0;
        while (i < size) {
            Matcher tmp = matchers.get(i);
            if (tmp.find(startPosition)) {
                if (minimal == null || tmp.start() < minimal.start()) {
                    minimal = tmp;
                }
                ++i;
                continue;
            }
            matchers.remove(i);
            --size;
        }
        return minimal;
    }

    private boolean isPHPTag(String tagName) {
        ArrayList<Matcher> matchers = this.createMatcherList(tagName);
        Matcher matcher = this.getMinimalMatcher(matchers, 0);
        return matcher != null;
    }

    @Override
    public boolean isValid(ISourceModule sourceModule, int offset, CompletionRequestor requestor) {
        if (!super.isValid(sourceModule, offset, requestor)) {
            return false;
        }
        this.setPatterns(sourceModule.getScriptProject().getProject());
        TextSequence statementText = this.getStatementText();
        int tagEnd = statementText.length();
        boolean found = false;
        do {
            tagEnd = PHPTextSequenceUtilities.readBackwardSpaces(statementText, tagEnd);
            this.tagStart = PHPTextSequenceUtilities.readIdentifierStartIndex(this.getPhpVersion(), this.getStatementText(), tagEnd, true);
            this.tagName = statementText.subSequence(this.tagStart, tagEnd).toString();
            if (this.tagStart > 0 && statementText.charAt(this.tagStart - 1) == '@') {
                found = true;
            } else if (this.isPHPTag(this.tagName)) {
                found = true;
            }
            tagEnd = this.tagStart - 1;
        } while (!found && this.tagStart > 0);
        return found;
    }

    @Override
    public String getPrefix() throws BadLocationException {
        String prefix = super.getPrefix();
        if (prefix.length() > 0 && prefix.charAt(0) == '\\') {
            return prefix.substring(1);
        }
        return prefix;
    }

    public String getTagName() {
        return this.tagName;
    }
}

