/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.codeassist.strategies;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.dltk.internal.core.SourceRange;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.php.core.codeassist.ICompletionContext;
import org.eclipse.php.core.codeassist.IElementFilter;
import org.eclipse.php.internal.core.codeassist.ICompletionReporter;
import org.eclipse.php.internal.core.codeassist.contexts.GotoStatementContext;
import org.eclipse.php.internal.core.codeassist.strategies.GlobalElementStrategy;
import org.eclipse.php.internal.core.compiler.ast.nodes.GotoLabel;
import org.eclipse.php.internal.core.compiler.ast.visitor.PHPASTVisitor;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;

public class GotoStatementStrategy
extends GlobalElementStrategy {
    public GotoStatementStrategy(ICompletionContext context, IElementFilter elementFilter) {
        super(context, elementFilter);
    }

    public GotoStatementStrategy(ICompletionContext context) {
        super(context);
    }

    @Override
    public void apply(ICompletionReporter reporter) throws BadLocationException {
        ICompletionContext context = this.getContext();
        GotoStatementContext gotoStatementContext = (GotoStatementContext)context;
        String prefix = gotoStatementContext.getPrefix();
        if (prefix.startsWith("$")) {
            return;
        }
        try {
            ModuleDeclaration rootNode = SourceParserUtil.getModuleDeclaration((ISourceModule)gotoStatementContext.getSourceModule());
            Object node = gotoStatementContext.getCurrentElement() != null ? PHPModelUtils.getNodeByElement(rootNode, gotoStatementContext.getCurrentElement()) : rootNode;
            GotoStatementVisitor vistor = new GotoStatementVisitor((ASTNode)node, prefix);
            node.traverse((ASTVisitor)vistor);
            List<String> getoLabels = vistor.getGotoLabels();
            SourceRange range = this.getReplacementRange(context);
            for (String label : getoLabels) {
                reporter.reportKeyword(label, "", range);
            }
        }
        catch (Exception exception) {}
    }

    private class GotoStatementVisitor
    extends PHPASTVisitor {
        private List<String> getoLabels = new ArrayList<String>();
        private ASTNode node;
        private String prefix;

        public GotoStatementVisitor(ASTNode node, String prefix) {
            this.node = node;
            this.prefix = prefix.toLowerCase();
        }

        @Override
        public boolean visit(GotoLabel s) throws Exception {
            if (s.getLabel().toLowerCase().startsWith(this.prefix)) {
                this.getoLabels.add(s.getLabel());
            }
            return false;
        }

        @Override
        public boolean visit(TypeDeclaration s) throws Exception {
            return this.node == s;
        }

        @Override
        public boolean visit(MethodDeclaration s) throws Exception {
            return this.node == s;
        }

        public List<String> getGotoLabels() {
            return this.getoLabels;
        }
    }
}

