/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.codeassist.strategies;

import java.util.LinkedList;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.core.ModelElement;
import org.eclipse.dltk.internal.core.SourceRange;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.php.core.codeassist.ICompletionContext;
import org.eclipse.php.core.codeassist.IElementFilter;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.codeassist.AliasType;
import org.eclipse.php.internal.core.codeassist.CodeAssistUtils;
import org.eclipse.php.internal.core.codeassist.ICompletionReporter;
import org.eclipse.php.internal.core.codeassist.contexts.NamespacePHPDocVarStartContext;
import org.eclipse.php.internal.core.codeassist.strategies.AbstractCompletionStrategy;

public class NamespaceDocTypesStrategy
extends AbstractCompletionStrategy {
    public NamespaceDocTypesStrategy(ICompletionContext context, IElementFilter elementFilter) {
        super(context, elementFilter);
    }

    public NamespaceDocTypesStrategy(ICompletionContext context) {
        super(context);
    }

    @Override
    public void apply(ICompletionReporter reporter) throws BadLocationException {
        ICompletionContext context = this.getContext();
        if (!(context instanceof NamespacePHPDocVarStartContext)) {
            return;
        }
        NamespacePHPDocVarStartContext concreteContext = (NamespacePHPDocVarStartContext)context;
        String suffix = "";
        SourceRange replaceRange = this.getReplacementRange(concreteContext);
        IType[] iTypeArray = this.getTypes(concreteContext);
        int n = iTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IType type = iTypeArray[n2];
            reporter.reportType(type, suffix, replaceRange, this.getExtraInfo());
            ++n2;
        }
    }

    public IType[] getTypes(NamespacePHPDocVarStartContext context) throws BadLocationException {
        IType ns;
        String prefix = context.getPrefix();
        LinkedList<Object> result = new LinkedList<Object>();
        IType[] iTypeArray = context.getNamespaces();
        int n = iTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ns = iTypeArray[n2];
            try {
                IType[] iTypeArray2 = ns.getTypes();
                int n3 = iTypeArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    IType type = iTypeArray2[n4];
                    if (CodeAssistUtils.startsWithIgnoreCase(type.getElementName(), prefix)) {
                        result.add(type);
                    }
                    ++n4;
                }
            }
            catch (ModelException e) {
                PHPCorePlugin.log(e);
            }
            ++n2;
        }
        iTypeArray = context.getPossibleNamespaces();
        n = iTypeArray.length;
        n2 = 0;
        while (n2 < n) {
            ns = iTypeArray[n2];
            if (context.getNsPrefix() == null) {
                result.add(ns);
            } else {
                String fullName = ns.getElementName();
                String alias = this.getAlias(ns, context.getNsPrefix());
                if (alias == null) {
                    result.add(ns);
                } else {
                    result.add((Object)new AliasType((ModelElement)ns, fullName, alias));
                }
            }
            ++n2;
        }
        return result.toArray(new IType[result.size()]);
    }

    private String getAlias(IType ns, String currentNSName) {
        String result = ns.getElementName();
        result = result.startsWith(currentNSName = String.valueOf(currentNSName) + '\\') ? result.substring(currentNSName.length()) : null;
        return result;
    }

    @Override
    public SourceRange getReplacementRange(ICompletionContext context) throws BadLocationException {
        SourceRange replacementRange = super.getReplacementRange(context);
        if (replacementRange.getLength() > 0) {
            return new SourceRange(replacementRange.getOffset(), replacementRange.getLength() - 1);
        }
        return replacementRange;
    }

    protected Object getExtraInfo() {
        return 2;
    }
}

