/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.format;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.php.internal.core.documentModel.parser.regions.IPhpScriptRegion;
import org.eclipse.php.internal.core.format.FormatterUtils;
import org.eclipse.php.internal.core.format.IndentationUtils;
import org.eclipse.php.internal.core.format.PHPHeuristicScanner;
import org.eclipse.php.internal.core.util.text.PHPTextSequenceUtilities;
import org.eclipse.php.internal.core.util.text.TextSequence;
import org.eclipse.wst.sse.core.internal.parser.ContextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionContainer;

public class IndentationBaseDetector {
    private IStructuredDocument document;
    private List<BlockCalculationCache> cache = new ArrayList<BlockCalculationCache>();

    public IndentationBaseDetector(IStructuredDocument document) {
        this.document = document;
    }

    public int getIndentationBaseLine(int currLineIndex, int offset, boolean checkMultiLine) throws BadLocationException {
        if (checkMultiLine) {
            currLineIndex = this.adjustLine(currLineIndex, offset);
        }
        while (currLineIndex > 0) {
            if (this.isIndentationBase(offset, currLineIndex, checkMultiLine)) {
                return currLineIndex;
            }
            currLineIndex = this.getNextLineIndex(offset, currLineIndex, checkMultiLine);
        }
        return 0;
    }

    private int adjustLine(int currLineIndex, int offset) throws BadLocationException {
        int peer;
        PHPHeuristicScanner scanner;
        int token;
        IRegion lineInfo = this.document.getLineInformation(currLineIndex);
        int lineEnd = lineInfo.getOffset() + lineInfo.getLength();
        if ((lineEnd = Math.min(lineEnd, offset)) == lineInfo.getOffset()) {
            lineEnd = IndentationUtils.moveLineStartToNonBlankChar(this.document, lineEnd, currLineIndex) - 1;
        }
        if (lineEnd == this.document.getLength() && lineEnd > 0) {
            --lineEnd;
        }
        if ((token = (scanner = PHPHeuristicScanner.createHeuristicScanner((IDocument)this.document, lineEnd, true)).previousToken(lineEnd, -2)) == 7) {
            token = scanner.previousToken(scanner.getPosition(), -2);
        }
        if (token == 6 ? (peer = scanner.findOpeningPeer(scanner.getPosition(), -2, '(', ')')) != -1 : token == 4 && (peer = scanner.findOpeningPeer(scanner.getPosition(), -2, '[', ']')) != -1) {
            return this.document.getLineOfOffset(scanner.getPosition());
        }
        return currLineIndex;
    }

    /*
     * Unable to fully structure code
     */
    private boolean isIndentationBase(int forOffset, int currLineIndex, boolean checkMultiLine) throws BadLocationException {
        lineInfo = this.document.getLineInformation(currLineIndex);
        if (lineInfo.getLength() == 0) {
            return false;
        }
        checkedOffset = Math.min(lineInfo.getOffset() + lineInfo.getLength(), forOffset);
        lineStart = lineInfo.getOffset();
        if (IndentationUtils.isBlanks(this.document, lineStart, checkedOffset, forOffset)) {
            return false;
        }
        scanner = PHPHeuristicScanner.createHeuristicScanner((IDocument)this.document, checkedOffset, true);
        if (!IndentationUtils.inBracelessBlock(scanner, this.document, checkedOffset)) ** GOTO lbl12
        return true;
lbl-1000:
        // 1 sources

        {
            ++lineStart;
lbl12:
            // 2 sources

            ** while (Character.isWhitespace((char)this.document.getChar((int)lineStart)))
        }
lbl13:
        // 1 sources

        checkedLineBeginState = FormatterUtils.getPartitionType(this.document, lineStart, true);
        checkedLineEndState = FormatterUtils.getPartitionType(this.document, checkedOffset, true);
        forLineEndState = FormatterUtils.getPartitionType(this.document, forOffset);
        if (this.isMultilineAfterBraceless(checkedOffset)) {
            return false;
        }
        lineContainIncompleteBlock = false;
        result = new BlockCalculationCache(checkedOffset, lineStart, currLineIndex);
        index = this.cache.indexOf(result);
        if (index != -1) {
            lineContainIncompleteBlock = this.cache.get((int)index).lineContainIncompleteBlock;
        } else {
            result.lineContainIncompleteBlock = lineContainIncompleteBlock = this.lineContainIncompleteBlock(checkedOffset, lineStart, currLineIndex);
            this.cache.add(result);
        }
        shouldNotConsiderAsIndentationBase = this.shouldNotConsiderAsIndentationBase(checkedLineBeginState, forLineEndState);
        if (!lineContainIncompleteBlock && shouldNotConsiderAsIndentationBase) {
            return false;
        }
        if (!lineContainIncompleteBlock && (shouldNotConsiderAsIndentationBase || checkMultiLine && this.isInMultiLineStatement(checkedLineBeginState, checkedLineEndState, checkedOffset, lineStart, currLineIndex) && !this.isMultilineContentInsideBraceless(checkedOffset))) {
            return false;
        }
        if ((checkedLineBeginState == "org.eclipse.php.PHP_MULTI_LINE_COMMENT" || checkedLineBeginState == "org.eclipse.php.PHP_DOC") && checkedLineBeginState == forLineEndState) {
            sdRegion = this.document.getRegionAtCharacterOffset(lineStart);
            phpScriptRegion = sdRegion.getRegionAtCharacterOffset(lineStart);
            phpContentStartOffset = sdRegion.getStartOffset(phpScriptRegion);
            if (phpScriptRegion instanceof ITextRegionContainer) {
                container = (ITextRegionContainer)phpScriptRegion;
                phpScriptRegion = container.getRegionAtCharacterOffset(lineStart);
                phpContentStartOffset += phpScriptRegion.getStart();
            }
            if (phpScriptRegion instanceof IPhpScriptRegion) {
                scriptRegion = (IPhpScriptRegion)phpScriptRegion;
                checkedRegion = (ContextRegion)scriptRegion.getPhpToken(lineStart - phpContentStartOffset);
                currentRegion = (ContextRegion)scriptRegion.getPhpToken(forOffset - phpContentStartOffset);
                checkedType = checkedRegion.getType();
                currentType = currentRegion.getType();
                if (currentType.equals("PHPDOC_COMMENT_START") || currentType.equals("PHP_COMMENT_START")) {
                    return checkedType.equals("PHPDOC_COMMENT_START") != false || checkedType.equals("PHP_COMMENT_START") != false;
                }
            }
        }
        return this.lineShouldIndent(checkedLineBeginState, checkedLineEndState) != false || forLineEndState == checkedLineBeginState;
    }

    private int getMultiLineStatementStartOffset(int lineStart, int currLineIndex, int checkedOffset) throws BadLocationException {
        TextSequence textSequence = PHPTextSequenceUtilities.getStatement(lineStart = IndentationUtils.moveLineStartToNonBlankChar(this.document, lineStart, currLineIndex), this.document.getRegionAtCharacterOffset(lineStart), true);
        if (textSequence != null && IndentationUtils.isRegionTypeAllowedMultiline(FormatterUtils.getRegionType(this.document, textSequence.getOriginalOffset(0))) && this.document.getLineOfOffset(textSequence.getOriginalOffset(0)) < currLineIndex) {
            return this.document.getLineOfOffset(textSequence.getOriginalOffset(0));
        }
        return -1;
    }

    private boolean lineContainIncompleteBlock(int checkedOffset, int lineStart, int currLineIndex) throws BadLocationException {
        TextSequence textSequence;
        PHPHeuristicScanner scanner = PHPHeuristicScanner.createHeuristicScanner((IDocument)this.document, lineStart, true);
        if (checkedOffset == this.document.getLength() && checkedOffset > 0) {
            --checkedOffset;
        }
        if ((textSequence = PHPTextSequenceUtilities.getStatement(lineStart, this.document.getRegionAtCharacterOffset(lineStart), true)) != null && IndentationUtils.isRegionTypeAllowedMultiline(FormatterUtils.getRegionType(this.document, textSequence.getOriginalOffset(0)))) {
            int statementStart = textSequence.getOriginalOffset(0);
            int openParenPeer = scanner.findOpeningPeer(checkedOffset - 1, statementStart, '(', ')');
            int bound = openParenPeer != -1 ? Math.max(statementStart, openParenPeer) : statementStart;
            int openBracePeer = scanner.findOpeningPeer(checkedOffset - 1, bound, '{', '}');
            bound = openBracePeer != -1 || openParenPeer != -1 ? Math.max(statementStart, Math.max(openParenPeer, openBracePeer)) : statementStart;
            int openBracketPeer = scanner.findOpeningPeer(checkedOffset - 1, bound, '[', ']');
            int biggest = Math.max(openParenPeer, openBracePeer);
            if ((biggest = Math.max(biggest, openBracketPeer)) != -1 && biggest >= lineStart) {
                IStructuredDocumentRegion sdRegion = this.document.getRegionAtCharacterOffset(lineStart);
                ITextRegion phpScriptRegion = sdRegion.getRegionAtCharacterOffset(lineStart);
                sdRegion.getStartOffset(phpScriptRegion);
                if (phpScriptRegion instanceof ITextRegionContainer) {
                    ITextRegionContainer container = (ITextRegionContainer)phpScriptRegion;
                    phpScriptRegion = container.getRegionAtCharacterOffset(lineStart);
                    phpScriptRegion.getStart();
                }
                if (phpScriptRegion instanceof IPhpScriptRegion && lineStart <= phpScriptRegion.getEnd()) {
                    IPhpScriptRegion scriptRegion = (IPhpScriptRegion)phpScriptRegion;
                    ITextRegion[] tokens = null;
                    try {
                        tokens = scriptRegion.getPhpTokens(Math.min(lineStart - 1, scriptRegion.getEnd()), biggest - lineStart + 1);
                    }
                    catch (BadLocationException badLocationException) {}
                    if (tokens != null && tokens.length > 0) {
                        HashSet<String> tokenTypeSet = new HashSet<String>();
                        int i = 0;
                        while (i < tokens.length) {
                            tokenTypeSet.add(tokens[i].getType());
                            ++i;
                        }
                        if (biggest == openParenPeer) {
                            if (tokenTypeSet.contains("PHP_NEW") || tokenTypeSet.contains("PHP_FUNCTION") || tokenTypeSet.contains("PHP_ARRAY")) {
                                return true;
                            }
                        } else if (biggest == openBracePeer) {
                            if (tokenTypeSet.contains("PHP_NEW") || tokenTypeSet.contains("PHP_FUNCTION")) {
                                return true;
                            }
                        } else {
                            if (biggest == openBracketPeer && scanner.previousToken(biggest - 1, -2) < 2000) {
                                return true;
                            }
                            if (tokenTypeSet.contains("PHP_ARRAY")) {
                                return true;
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private int getNextLineIndex(int offset, int currLineIndex, boolean checkMultiLine) throws BadLocationException {
        int index;
        IRegion lineInfo = this.document.getLineInformation(currLineIndex);
        int currLineEndOffset = lineInfo.getOffset() + lineInfo.getLength();
        String checkedLineBeginState = FormatterUtils.getPartitionType(this.document, lineInfo.getOffset(), true);
        String forLineEndState = FormatterUtils.getPartitionType(this.document, currLineEndOffset);
        int insideBraceless = this.getMultilineInsideBraceless(Math.min(currLineEndOffset, offset));
        if (insideBraceless >= 0) {
            return this.document.getLineOfOffset(insideBraceless);
        }
        if (this.isMultilineType(checkedLineBeginState) && (checkMultiLine || this.shouldNotConsiderAsIndentationBase(checkedLineBeginState, forLineEndState)) && (index = this.getMultiLineStatementStartOffset(lineInfo.getOffset(), currLineIndex)) > -1) {
            return index;
        }
        if (checkMultiLine) {
            int result = this.adjustLine(currLineIndex, currLineEndOffset);
            if (result == currLineIndex && result != 0) {
                --result;
            }
            return result;
        }
        return currLineIndex - 1;
    }

    private int getMultiLineStatementStartOffset(int lineStart, int currLineIndex) {
        lineStart = IndentationUtils.moveLineStartToNonBlankChar(this.document, lineStart, currLineIndex);
        TextSequence textSequence = PHPTextSequenceUtilities.getStatement(lineStart, this.document.getRegionAtCharacterOffset(lineStart), true);
        int textOriginalOffset = textSequence.getOriginalOffset(0);
        int textSequenceLine = this.document.getLineOfOffset(textOriginalOffset);
        if (textSequence != null && textSequenceLine < currLineIndex && IndentationUtils.isRegionTypeAllowedMultiline(FormatterUtils.getRegionType(this.document, textOriginalOffset))) {
            return textSequenceLine;
        }
        return -1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int getMultilineInsideBraceless(int checkedOffset) {
        try {
            int openParent;
            PHPHeuristicScanner scanner = PHPHeuristicScanner.createHeuristicScanner((IDocument)this.document, checkedOffset - 1, true);
            int start = scanner.previousToken(checkedOffset - 1, -2);
            if (start != 2) {
                return -1;
            }
            int openingPeer = scanner.findOpeningPeer(scanner.getPosition(), -2, '{', '}');
            if (openingPeer == -1) {
                return -1;
            }
            int prev = scanner.previousToken(openingPeer - 1, -2);
            if (prev == 6) {
                openParent = scanner.findOpeningPeer(scanner.getPosition(), -2, '(', ')');
                if (openParent == -1) {
                    return -1;
                }
                prev = scanner.previousToken(openParent - 1, -2);
            }
            if (!IndentationUtils.inBracelessBlock(scanner, this.document, scanner.getPosition() - 1)) {
                return -1;
            }
            prev = scanner.previousToken(scanner.getPosition() - 1, -2);
            if (prev == 6 && (openParent = scanner.findOpeningPeer(scanner.getPosition(), -2, '(', ')')) == -1) {
                return -1;
            }
            prev = scanner.previousToken(scanner.getPosition() - 1, -2);
            int result = scanner.getPosition();
            if (prev != 109) return result;
            prev = scanner.previousToken(start, -2);
            if (prev != 1014) return result;
            return scanner.getPosition();
        }
        catch (BadLocationException badLocationException) {
            return -1;
        }
    }

    private boolean isMultilineContentInsideBraceless(int checkedOffset) {
        try {
            PHPHeuristicScanner scanner = PHPHeuristicScanner.createHeuristicScanner((IDocument)this.document, checkedOffset - 1, true);
            int start = scanner.previousToken(checkedOffset - 1, -2);
            if (start == 1 && scanner.isBracelessBlockStart(scanner.getPosition() - 1, -2)) {
                return true;
            }
        }
        catch (BadLocationException badLocationException) {}
        return false;
    }

    private boolean lineShouldIndent(String beginState, String endState) {
        return beginState == "org.eclipse.php.PHP_DEFAULT" || endState == "org.eclipse.php.PHP_DEFAULT";
    }

    private boolean isInMultiLineStatement(String checkedLineBeginState, String checkedLineEndState, int checkedOffset, int lineStart, int currLineIndex) throws BadLocationException {
        return this.getMultiLineStatementStartOffset(lineStart, currLineIndex, checkedOffset) > -1;
    }

    private boolean shouldNotConsiderAsIndentationBase(String currentState, String forState) {
        return currentState != forState && this.isMultilineType(currentState);
    }

    private boolean isMultilineAfterBraceless(int checkedOffset) {
        return this.getMultilineInsideBraceless(checkedOffset) >= 0;
    }

    private boolean isMultilineType(String state) {
        return state.equals("org.eclipse.php.PHP_QUOTED_STRING") || state.equals("org.eclipse.php.PHP_MULTI_LINE_COMMENT") || state.equals("org.eclipse.php.PHP_DOC");
    }

    private class BlockCalculationCache {
        int checkedOffset;
        int lineStart;
        int currLineIndex;
        boolean lineContainIncompleteBlock;

        public BlockCalculationCache(int checkedOffset, int lineStart, int currLineIndex) {
            this.checkedOffset = checkedOffset;
            this.lineStart = lineStart;
            this.currLineIndex = currLineIndex;
        }

        public boolean equals(Object obj) {
            if (obj instanceof BlockCalculationCache) {
                BlockCalculationCache tmpResult = (BlockCalculationCache)obj;
                return this.checkedOffset == tmpResult.checkedOffset && this.lineStart == tmpResult.lineStart && this.currLineIndex == tmpResult.currLineIndex;
            }
            return false;
        }
    }
}

