/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.typeinference.evaluators;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.dltk.ast.ASTListNode;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.ast.references.TypeReference;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.dltk.evaluation.types.AmbiguousType;
import org.eclipse.dltk.ti.GoalState;
import org.eclipse.dltk.ti.IContext;
import org.eclipse.dltk.ti.ISourceModuleContext;
import org.eclipse.dltk.ti.goals.GoalEvaluator;
import org.eclipse.dltk.ti.goals.IGoal;
import org.eclipse.dltk.ti.types.IEvaluatedType;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.core.compiler.ast.nodes.ClassDeclaration;
import org.eclipse.php.internal.core.compiler.ast.nodes.FullyQualifiedReference;
import org.eclipse.php.internal.core.compiler.ast.nodes.NamespaceReference;
import org.eclipse.php.internal.core.compiler.ast.nodes.UsePart;
import org.eclipse.php.internal.core.project.ProjectOptions;
import org.eclipse.php.internal.core.typeinference.PHPClassType;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;
import org.eclipse.php.internal.core.typeinference.PHPSimpleTypes;
import org.eclipse.php.internal.core.typeinference.context.INamespaceContext;
import org.eclipse.php.internal.core.typeinference.context.MethodContext;
import org.eclipse.php.internal.core.typeinference.evaluators.PHPTraitType;

public class TypeReferenceEvaluator
extends GoalEvaluator {
    private TypeReference typeReference;
    private IEvaluatedType result;

    public TypeReferenceEvaluator(IGoal goal, TypeReference typeReference) {
        super(goal);
        this.typeReference = typeReference;
    }

    private boolean isSelfOrStatic() {
        String name = this.typeReference.getName();
        if (this.goal.getContext() instanceof ISourceModuleContext && PHPVersion.PHP5_4.isLessThan(ProjectOptions.getPhpVersion((IModelElement)((ISourceModuleContext)this.goal.getContext()).getSourceModule()))) {
            name = name.toLowerCase();
        }
        return "self".equals(name) || "static".equals(name);
    }

    private boolean isParent() {
        String name = this.typeReference.getName();
        if (this.goal.getContext() instanceof ISourceModuleContext && PHPVersion.PHP5_4.isLessThan(ProjectOptions.getPhpVersion((IModelElement)((ISourceModuleContext)this.goal.getContext()).getSourceModule()))) {
            name = name.toLowerCase();
        }
        return "parent".equals(name);
    }

    public IGoal[] init() {
        IContext context = this.goal.getContext();
        String className = this.typeReference.getName();
        if (this.isSelfOrStatic()) {
            MethodContext methodContext;
            IEvaluatedType instanceType;
            if (context instanceof MethodContext && (instanceType = (methodContext = (MethodContext)context).getInstanceType()) instanceof PHPClassType) {
                this.result = instanceType;
            }
        } else if (this.isParent()) {
            if (context instanceof MethodContext) {
                LinkedList types;
                block15: {
                    MethodContext methodContext = (MethodContext)context;
                    ModuleDeclaration rootNode = methodContext.getRootNode();
                    ISourceModule sourceModule = ((ISourceModuleContext)context).getSourceModule();
                    final IType currentNamespace = PHPModelUtils.getCurrentNamespace(sourceModule, rootNode.sourceStart());
                    final ModuleDeclaration moduleDeclaration = SourceParserUtil.getModuleDeclaration((ISourceModule)sourceModule);
                    final MethodDeclaration methodDecl = methodContext.getMethodNode();
                    types = new LinkedList();
                    try {
                        rootNode.traverse(new ASTVisitor(){
                            private TypeDeclaration currentType;
                            private boolean found;

                            public boolean visit(MethodDeclaration s) throws Exception {
                                if (s == methodDecl && this.currentType instanceof ClassDeclaration) {
                                    ClassDeclaration classDecl = (ClassDeclaration)this.currentType;
                                    ASTListNode superClasses = classDecl.getSuperClasses();
                                    List childs = superClasses.getChilds();
                                    for (ASTNode node : childs) {
                                        Object type;
                                        String fullName;
                                        Map<String, UsePart> result;
                                        String prefix;
                                        NamespaceReference namespace = null;
                                        SimpleReference reference = null;
                                        if (!(node instanceof SimpleReference)) continue;
                                        reference = (SimpleReference)node;
                                        String typeName = reference.getName();
                                        if (reference instanceof FullyQualifiedReference) {
                                            FullyQualifiedReference ref = (FullyQualifiedReference)node;
                                            namespace = ref.getNamespace();
                                        }
                                        if (namespace != null && !namespace.getName().equals("")) {
                                            String nsName = namespace.getName();
                                            if (nsName.equals("\\")) {
                                                typeName = String.valueOf(nsName) + typeName;
                                            } else {
                                                if (nsName.startsWith("namespace\\")) {
                                                    nsName = nsName.replace("namespace\\", "");
                                                }
                                                typeName = String.valueOf(nsName) + '\\' + typeName;
                                            }
                                        }
                                        if (typeName.indexOf(92) > 0) {
                                            prefix = typeName.substring(0, typeName.indexOf(92));
                                            result = PHPModelUtils.getAliasToNSMap(prefix, moduleDeclaration, reference.sourceStart(), currentNamespace, true);
                                            if (result.containsKey(prefix)) {
                                                fullName = result.get(prefix).getNamespace().getFullyQualifiedName();
                                                typeName = typeName.replace(prefix, fullName);
                                            }
                                        } else if (typeName.indexOf(92) < 0 && (result = PHPModelUtils.getAliasToNSMap(prefix = typeName, moduleDeclaration, reference.sourceStart(), currentNamespace, true)).containsKey(prefix)) {
                                            typeName = fullName = result.get(prefix).getNamespace().getFullyQualifiedName();
                                        }
                                        if ((type = PHPSimpleTypes.fromString(typeName)) == null) {
                                            type = typeName.indexOf(92) != -1 || currentNamespace == null ? new PHPClassType(typeName) : new PHPClassType(currentNamespace.getElementName(), typeName);
                                        }
                                        types.add(type);
                                    }
                                    this.found = true;
                                }
                                return !this.found;
                            }

                            public boolean visit(TypeDeclaration s) throws Exception {
                                this.currentType = s;
                                return !this.found;
                            }

                            public boolean endvisit(TypeDeclaration s) throws Exception {
                                this.currentType = null;
                                return super.endvisit(s);
                            }

                            public boolean visit(ASTNode n) throws Exception {
                                return !this.found;
                            }
                        });
                    }
                    catch (Exception e) {
                        if (!DLTKCore.DEBUG) break block15;
                        e.printStackTrace();
                    }
                }
                if (types.size() == 1) {
                    this.result = (IEvaluatedType)types.get(0);
                } else if (types.size() > 1) {
                    this.result = new AmbiguousType(types.toArray(new IEvaluatedType[types.size()]));
                }
            }
        } else {
            String fullyQualifiedName;
            String parentNamespace = null;
            if (context instanceof INamespaceContext) {
                parentNamespace = ((INamespaceContext)context).getNamespace();
            }
            if (this.typeReference instanceof FullyQualifiedReference) {
                fullyQualifiedName = ((FullyQualifiedReference)this.typeReference).getFullyQualifiedName();
            } else {
                fullyQualifiedName = this.typeReference.getName();
                className = PHPModelUtils.extractElementName(fullyQualifiedName);
            }
            ISourceModule sourceModule = ((ISourceModuleContext)context).getSourceModule();
            int offset = this.typeReference.sourceStart();
            String extractedNamespace = PHPModelUtils.extractNamespaceName(fullyQualifiedName, sourceModule, offset);
            if (extractedNamespace != null) {
                parentNamespace = extractedNamespace;
                className = PHPModelUtils.getRealName(fullyQualifiedName, sourceModule, offset, className);
            }
            this.result = PHPModelUtils.isInUseTraitStatement(((ISourceModuleContext)context).getRootNode(), this.typeReference.sourceStart()) ? (parentNamespace != null ? new PHPTraitType(parentNamespace, className) : new PHPTraitType(className)) : (parentNamespace != null ? new PHPClassType(parentNamespace, className) : new PHPClassType(className));
        }
        return IGoal.NO_GOALS;
    }

    public Object produceResult() {
        return this.result;
    }

    public IGoal[] subGoalDone(IGoal subgoal, Object result, GoalState state) {
        return IGoal.NO_GOALS;
    }
}

